<?php require_once(public_path("smart/inc/init.php")); ?>
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            <?php echo $__env->make("operation-reports.layouts.pts-report-form", ['enableAirline' => true, 'enableAirport' => true, 'enablePeriod' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="clearfix"></div>
        </article>

        <article class="col-sm-12 col-md-12 col-lg-12">
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <h2><?php echo app('translator')->get("content.list"); ?></h2>
                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding" style="min-height: 50px !important;">

                        <div class="table-responsive">

                            <table class="table table-bordered table-hover" border="1">
                                <thead>
                                <tr>
                                    
                                    <th style="min-width: 60px !important;"><?php echo app('translator')->get("content.date"); ?></th>
                                    <th><?php echo app('translator')->get("content.station"); ?></th>

                                    <th style="min-width: 50px !important;">DEP<br>FLT No</th>
                                    <th>TO</th>
                                    <th>STD</th>
                                    <th style="min-width: 50px !important;">ARR<br>FLT No</th>
                                    <th>FROM</th>
                                    <th style="min-width: 100px !important;">STA</th>

                                    <th style="min-width: 50px !important;">A/C Reg</th>
                                    <th>A/C Type</th>
                                    <th>ATA</th>
                                    <th>ATD</th>

                                    <th>DL Code</th>
                                    <th>DL Time</th>

                                    <th>JETWAY/STEPS</th>
                                    <th>JETWAY ON</th>
                                    <th>FIRST PAX OFF</th>
                                    <th>LAST PAX OFF</th>
                                    <th>CLEANERS ON BOARD</th>
                                    <th>FUELLING STARTED</th>
                                    <th>PRE-BOARDING STARTED</th>
                                    <th>CLEANERS OFF</th>
                                    <th>PILOT HEADSET</th>
                                    <th>BOARD PAX</th>
                                    <th>ALL PAX ON BOARD</th>
                                    <th>GATEBAGS COLLECTED BY LOADING TEAM</th>
                                    <th>LOADSHEET ONBOARD</th>
                                    <th>ALL DOORS CLOSED</th>
                                    <th>TUG CONNECTED</th>
                                    <th>JETWAY OFF</th>
                                    <th>PUSHBACK</th>
                                    <th>FINAL WALK AROUND</th>
                                    <th>ALL DOORS & PANELS ARE CLOSED</th>
                                    <th>BACK STEPS USED</th>
                                    <th>CABIN BAGS AT CHECK-IN</th>
                                    <th>CABIN BAGS AT GATE</th>
                                    <th>CKIN OPEN</th>
                                    <th>CKIN CLOSE</th>
                                    <th>MHB AHL</th>
                                    <th>MHB OHD</th>
                                    <th>MHB DPR</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php $depFn = $depAp = $arrAp = $depAC = null ?>

                                    <tr>
                                        <?php $depAp = getFlightDepartureAirport($flight, false, true) ?>
                                        <?php $arrAp = getFlightArrivalAirport($flight, false, true) ?>
                                        <?php $depSTD = $flight->std && $flight->std != EMPTY_DATETIME ? baseDateFormat($flight->std, true) : null ?>
                                        <?php $depSTDDate = $depSTD ? date("Y-m-d", strtotime($depSTD)) : null ?>

                                        <?php $depFn = getFlightNumberFull($flight->flightNumber) ?>
                                        <?php $depAC = getFlightAircraft($flight) ?>
                                        <?php $depACType = getFlightAircraftType($flight) ?>

                                        <?php $arrFlight = $flight->flightParent ?>
                                        <?php $arrFN = $arrFlight ? getFlightNumberFull($arrFlight->flightNumber) : null ?>
                                        <?php $arrDepAp = $arrFlight ? getFlightDepartureAirport($arrFlight, false, true) : null ?>
                                        <?php $arrSTA = $arrFlight && $arrFlight->sta && $arrFlight->sta != EMPTY_DATETIME ? baseDateFormat($arrFlight->sta, true) : null ?>
                                        <?php $arrSTADate = $arrSTA ? date("Y-m-d", strtotime($arrSTA)) : null ?>

                                        <td><?php echo e(getFlightDepartureInitialDate($flight, true)); ?></td>

                                        
                                        <td><?php echo e($depAp); ?></td>
                                        <td><?php echo e($depFn); ?></td>
                                        <td><?php echo e($arrAp); ?></td>
                                        <td><?php echo e(baseTimeFormat($depSTD)); ?></td>

                                        
                                        <td><?php echo e($arrFN); ?></td>
                                        <td><?php echo e($arrDepAp); ?></td>
                                        <td><?php echo e(($depSTDDate != $arrSTADate ? $arrSTADate." " : ""). baseTimeFormat($arrSTA)); ?></td>

                                        <td><?php echo e($depAC); ?></td>
                                        <td><?php echo e($depACType); ?></td>

                                        
                                        <td><?php echo e($arrFlight && $arrFlight->ata && $arrFlight->ata != EMPTY_DATETIME ? baseTimeFormat($arrFlight->ata) : ""); ?></td>

                                        
                                        <td><?php echo e($flight->atd && $flight->atd != EMPTY_DATETIME ? baseTimeFormat($flight->atd) : ""); ?></td>

                                        
                                        <?php list($codes, $times) = getFlightDelays($flight) ?>
                                        <?php if(count($codes)): ?>
                                            <td class="color-red">DL <?php echo e(implode("/", $codes)); ?></td>
                                            <td class="color-red"><?php echo e(implode("/", $times)); ?></td>
                                        <?php else: ?>
                                            <td></td>
                                            <td></td>
                                        <?php endif; ?>

                                        <td data-center><?php echo e($flight->jetway_steps); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->jetway_on)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->first_pax_off)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->last_pax_off)); ?></td>

                                        <td data-center><?php echo e(baseTimeFormat($flight->cleaners_onboard)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->fuelling_started)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->pre_boarding_started)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->cleaners_off)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->pilot_headset)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->board_pax)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->all_pax_onboard)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->gatebags_collected)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->loadsheet_onboard)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->all_doors_closed)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->tug_connected)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->jetway_off)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->pushback)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->final_walk_around)); ?></td>
                                        <td data-center=""><?php echo e($flight->all_doors_panels_closed); ?></td>
                                        <td data-center><?php echo $flight->back_steps_used ? '<i class="fa fa-check"></i>' : ""; ?> </td>
                                        <td data-right><?php echo e($flight->cabin_bags_checkin); ?></td>
                                        <td data-right><?php echo e($flight->cabin_bags_gate); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->ckin_open)); ?></td>
                                        <td data-center><?php echo e(baseTimeFormat($flight->ckin_close)); ?></td>
                                        <td data-right><?php echo e($flight->mhb_ahl); ?></td>
                                        <td data-right><?php echo e($flight->mhb_ohd); ?></td>
                                        <td data-right><?php echo e($flight->mhb_dpr); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        <?php if(ghaModule()): ?>
            ApplyOperationsFormFilter(<?php echo json_encode($flightNumbers); ?>, <?php echo json_encode(\request("flightNumber")); ?>, <?php echo json_encode($sectors); ?>, <?php echo json_encode($sectorsByAirlines); ?>, <?php echo json_encode(\request("sector")); ?>);
        <?php endif; ?>

        ApplyTableFilter(".table", false, [[ 0, "asc" ], [ 4, "asc" ]]);

    };

    pagefunction();

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/operation-reports/pts-report.blade.php ENDPATH**/ ?>