<div class="tab-pane tab_holder <?php echo e(!$reportType || $reportType === 'Hours' ? 'active' : ''); ?>" id="hours">
    <div class="col-md-12" style="margin-bottom: 10px;">

        <?php echo Form::open(['method' => 'GET', 'url' => url("crew/report?reportType=Hours"), 'class'=>"form-inline", 'id' => 'formHours' ]); ?>

        <div class="form-group margin_right">
            <label class="control-label"><?php echo app('translator')->get("content.crew"); ?></label>
            <?php echo Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']); ?>

        </div>
        <div class="form-group margin_right">
            <label class="control-label"><?php echo app('translator')->get("content.designation"); ?></label>
            <?php echo Form::select('designation', $designationList , \request("destination"), ['class'=>'form-control input_roster crew_designation']); ?>

        </div>
        <div class="form-group margin_right">
            <label class="control-label"><?php echo app('translator')->get("content.report_date"); ?></label>
            <?php echo Form::input('text', 'hoursReportDate', $date, ['class'=>'dateFrom form-control', 'id'=>'hoursReportDate']); ?>

        </div>

        <div class="form-group">

            <?php echo Form::input('submit', 'submit','Submit',[ 'class' => "btn btn-primary"]); ?>

        </div>
        <?php echo Form::close(); ?>

    </div>

    <?php if(count($crew) && count($crewHours)): ?>
        <div class="clearfix"></div>
        <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
            <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            data-widget-colorbutton="false"
            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

            -->
            <header>
                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2><?php echo app('translator')->get("content.list"); ?> </h2>

            </header>

            <!-- widget div-->
            <div>

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">
                    <table class="table table-bordered table-striped table-hover" id="hoursTable">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2"></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.first_name"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.last_name"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.base"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.designation"); ?></th>
                            <th colspan="3"><?php echo app('translator')->get("content.flight_hours"); ?></th>
                            <th colspan="3"><?php echo app('translator')->get("content.not_available"); ?></th>
                        </tr>
                        <tr>
                            <th>7 <?php echo app('translator')->get("content.days"); ?></th>
                            <th>28 <?php echo app('translator')->get("content.days"); ?></th>
                            <th><?php echo app('translator')->get("content.year_to_date"); ?></th>
                            <th><?php echo app('translator')->get("content.from"); ?></th>
                            <th><?php echo app('translator')->get("content.to"); ?></th>
                            <th><?php echo app('translator')->get("content.reason"); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $i = 0 ?>
                        <?php $__currentLoopData = $crew; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $i++ ?>
                            <?php $designation = Crew_Designation($crewType, $each) ?>
                            <?php $picture = $each->thumb ? '/storage/users/' . $each->thumb : '/assets/img/default-user-picture.png' ?>
                            <?php $last['last7days'] = isset($crewHours[$id]['last7days']) ? round($crewHours[$id]['last7days'], 1) : 0 ?>
                            <?php $last['last28days'] = isset($crewHours[$id]['last28days']) ? round($crewHours[$id]['last28days'], 1) : 0 ?>
                            <?php $last['yearToDate'] = isset($crewHours[$id]['yearToDate']) ? round($crewHours[$id]['yearToDate'], 1) : 0 ?>
                            <?php $class = Get_Limitation_Class($last) ?>

                            <tr class="<?php echo e($each->is_contractor ? 'contractorCrew' : ''); ?>">
                                <td><?php echo e($i); ?></td>
                                <td>
                                    <a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$each->id}")); ?>" target="_blank">
                                        <img src="<?php echo e($picture); ?>" class="img-thumbnail thumb_report_prev"/>
                                    </a>
                                </td>
                                <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$each->id}")); ?>" target="_blank"><?php echo e($each->first_name); ?></a></td>
                                <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$each->id}")); ?>" target="_blank"><?php echo e($each->last_name); ?></a></td>
                                <td><?php echo e($each->location ? $each->location->airport->iata : ''); ?></td>
                                <td><?php echo e($designation); ?></td>
                                <td class="<?php echo e($class['last7days']); ?>"> <?php echo e(round($last['last7days'], 1)); ?></td>
                                <td class="<?php echo e($class['last28days']); ?>"><?php echo e(round($last['last28days'],1)); ?></td>
                                <td class="<?php echo e($class['yearToDate']); ?>"><?php echo e(round($last['yearToDate'],1)); ?></td>
                                <?php $from = '' ?>
                                <?php $to = '' ?>
                                <?php $reason = '' ?>
                                <?php $__empty_1 = true; $__currentLoopData = $each->userHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if(strtotime($date) <= strtotime($history->to)): ?>
                                        <?php $from .= $history->from.'<br/>' ?>
                                        <?php $to .= $history->to.'<br/>' ?>
                                        <?php $reason .= (isset($conditions[$history->condition_id]) ? $conditions[$history->condition_id] : "").'<br/>' ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>

                                <td><?php echo e($from); ?></td>
                                <td><?php echo e($to); ?></td>
                                <td><?php echo e($reason); ?></td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/crew/report-hours-tab.blade.php ENDPATH**/ ?>