<?php if($flightsOPS): ?>
    <table class="table table-bordered table-hover table-striped ops-table" id="flightMessages">
        <thead>
        <tr class="ops-header">
            <?php if(env(CARRIER) == HANDLING): ?>
                <th style="width: 50px; color: #ffffff; background-color: #1b63de;" data-center><?php echo app('translator')->get("content.AIRLINE"); ?></th>
            <?php endif; ?>
            <th style="width: 90px !important; color: #ffffff; background-color: #1b63de;" data-center><?php echo app('translator')->get("content.FLT"); ?></th>
            <th style="width: 90px !important;; color: #ffffff; background-color: #1b63de;" data-center><?php echo app('translator')->get("content.SECTOR"); ?></th>
            <th style="width: 140px !important;; color: #ffffff; background-color: #1b63de;" data-center><?php echo app('translator')->get("content.DEP_TIME"); ?></th>
            <th style="width: 140px !important;; color: #ffffff; background-color: #1b63de;" data-center><?php echo app('translator')->get("content.ARR_TIME"); ?></th>
            <th style="color: #ffffff; background-color: #1b63de; min-width: 500px !important;"><?php echo app('translator')->get("content.MESSAGES"); ?></th>
        </tr>
        </thead>
        <tbody>

        <?php $j = 0 ?>

        <?php $__currentLoopData = $flightsOPS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <?php if(!$flight || !count($flight->message)): ?>
                <?php continue; ?>
            <?php endif; ?>

            <?php $aircraft = $flight->aircraft ?>
            <?php $flightNumber = $flight->flightNumber ?>
            <?php $departureAirport   = $flightNumber ? $flight->flightNumber->departureAirport : null ?>
            <?php $arrivalAirport     = $flightNumber ? $flight->flightNumber->arrivalAirport : null ?>
            <?php $sector  = ($departureAirport    ? $departureAirport->iata  : "")."-" ?>
            <?php $sector .=  $arrivalAirport      ? $arrivalAirport->iata    : "" ?>

            <?php $airline = $flightNumber->airline ?>
            <?php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") ?>

            <?php $depTime = getFlightDepartureDate($flight) ?>
            <?php $depTimeType = getFlightDepartureTimeType($flight) ?>

            <?php $arrTime = getFlightArrivalDate($flight) ?>
            <?php $arrTimeType = getFlightArrivalTimeType($flight) ?>

            <tr class="ops-body <?php echo e(isset($selectedFlightId) && $selectedFlightId == $flight->id ? "selected" : ""); ?>">
                <?php if(env(CARRIER) == HANDLING): ?>
                    <td style="padding: 5px;" data-center>
                        <a target="_blank" href="<?php echo e(route("homepage")."#". url("/airline/{$airline->id}")); ?>" class="">
                            <img class='ops-airline-logo' src='<?php echo e($picture); ?>'/>
                        </a>
                    </td>
                <?php endif; ?>

                <td style="padding: 5px;" data-center>
                    <a target="_blank" href="<?php echo e(url("flight-tracker/{$flight->id}")); ?>">
                        <?php echo e(($flightNumber && $flightNumber->airline ? ($flightNumber->airline->iata ? $flightNumber->airline->iata : $flightNumber->airline->icao)."-" : "").($flightNumber ? $flightNumber->flight_number : "-")); ?>

                    </a>
                </td>
                <td style="padding: 5px;" data-center><?php echo e($sector); ?></td>
                <td style="padding: 5px;" data-center><?php echo departureArrivalTypeSpan($depTimeType, "left") . baseDateFormat($depTime, true); ?></td>
                <td style="padding: 5px;" data-center><?php echo departureArrivalTypeSpan($arrTimeType, "left") . baseDateFormat($arrTime, true); ?></td>
                <td style="padding: 5px;" ><?php echo getFlightMessages($flight, 2, ""); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>

    </table>
<?php endif; ?>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-tracker/layouts/flight-messages-tab.blade.php ENDPATH**/ ?>