<?php $airlineID = isset($airlineID) && $airlineID ? $airlineID : null ?>
<?php $currentAirlineId = isset($currentAirlineId) ? $currentAirlineId : '' ?>
<?php $urlAirlineID = $currentAirlineId ? $currentAirlineId : ($airlineID ? $airlineID : \request("airline_id")) ?>
<?php $addURL = "aircraft/add?s=".rand(100, 999) . ($airlineID ? "&airline_id={$airlineID}" : "") ?>
<?php $sprAdm = isSprAdm() ?>

<div class="col-md-12 no-padding margin-bottom-10">
    <a target="_blank" href="<?php echo e(route("homepage")."#".url("{$addURL}")); ?>" class="btn btn-primary"><?php echo app('translator')->get("content.add_new_aircraft"); ?></a>
</div>

<div class="clearfix"></div>

<?php if(count($aircraft)): ?>
    <!-- Widget ID (each widget will need unique ID)-->
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-aircraft" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
        <!-- widget options:
        usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

        data-widget-colorbutton="false"
        data-widget-editbutton="false"
        data-widget-togglebutton="false"
        data-widget-deletebutton="false"
        data-widget-fullscreenbutton="false"
        data-widget-custombutton="false"
        data-widget-collapsed="true"
        data-widget-sortable="false"

        -->
        <header>

            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

            <h2><?php echo app('translator')->get("content.list"); ?></h2>


        </header>

        <!-- widget div-->
        <div class="editable_div">

            <!-- widget edit box -->
            <div class="jarviswidget-editbox">
                <!-- This area used as dropdown edit box -->

            </div>
            <!-- end widget edit box -->

            <!-- widget content -->
            <div class="widget-body no-padding">

                <div class="table-responsive">

                    <?php $ghaModule = ghaModule() ?>

                    <table class="table table-bordered table-hover" id="aircraft-table" style="min-width: 100% !important;">
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2"><?php echo app('translator')->get("content.ac_reg"); ?></th>
                            <th rowspan="2">MVT</th>
                            <th rowspan="2">HEX <?php echo app('translator')->get("content.code"); ?></th>
                            <th colspan="2"><?php echo app('translator')->get("content.type"); ?></th>
                            <?php if($isAdmin): ?>
                                <th rowspan="2">Type ID</th>
                                <th rowspan="2">STS</th>
                            <?php endif; ?>

                            <?php if($ghaModule): ?>
                                <th colspan="3"><?php echo app('translator')->get("content.airline"); ?></th>
                            <?php endif; ?>

                            <th rowspan="2"><?php echo app('translator')->get("content.fleet_type"); ?></th>
                            <th colspan="4"><?php echo app('translator')->get("content.configuration"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.flexi_config"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.engine"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.delivered"); ?></th>

                            <th rowspan="2">MSN</th>
                            <th rowspan="2"><?php echo app('translator')->get("content.line_number"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.first_flight"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.status"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.email_forwarding"); ?></th>
                            <th rowspan="2" style="min-width: 220px;"><?php echo app('translator')->get("content.actions"); ?></th>
                        </tr>
                        <tr>
                            <td>IATA</td>
                            <td>ICAO</td>

                            <?php if($ghaModule): ?>
                                <td><?php echo app('translator')->get("content.name"); ?></td>
                                <td>IATA</td>
                                <td>ICAO</td>
                            <?php endif; ?>

                            <th>F</th>
                            <th>C</th>
                            <th>W</th>
                            <th>Y</th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php $__currentLoopData = $aircraft; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if($each->deleted_at): ?>
                                <?php continue; ?>
                            <?php endif; ?>

                            <tr>
                                <td><?php echo e($i + 1); ?></td>
                                <td><?php echo e($each->name); ?></td>
                                <td><?php echo e($each->mvt_name); ?></td>
                                <td><?php if($sprAdm): ?>
                                        <a href="#" data-field='hex_code' data-model="Aircraft" data-type="text" data-id='<?php echo e($each->id); ?>'
                                           data-placeholder="Required"
                                           class="editable <?php echo e($each->hex_code ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->hex_code ? $each->hex_code : 'Empty'); ?></a>
                                    <?php else: ?>
                                        <?php echo e($each->hex_code); ?>

                                    <?php endif; ?>
                                </td>

                                <?php if($each->type): ?>
                                    <td><?php echo e($each->type->iata_name); ?></td>
                                    <td><?php echo e($each->type->icao); ?></td>
                                <?php else: ?>
                                    <td></td>
                                    <td></td>
                                <?php endif; ?>

                                <?php if($isAdmin): ?>
                                    <td><?php echo e($each->aircraft_type_id); ?></td>
                                    <td><?php echo e($each->type && $each->type->deleted_at ? "DELETED" : ""); ?></td>
                                <?php endif; ?>

                                <?php if($ghaModule): ?>
                                    <?php if($each->airline): ?>
                                        <td><?php echo e($each->airline->airline); ?></td>
                                        <td><?php echo e($each->airline->iata); ?></td>
                                        <td><?php echo e($each->airline->icao); ?></td>
                                    <?php else: ?>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <td><?php echo e($each->type && $each->type->wide_board ? "W B" : "N B"); ?></td>
                                <td>
                                    <?php if($sprAdm): ?>
                                        <a href="#" data-field='config_a' data-model="Aircraft" data-type="text" data-id='<?php echo e($each->id); ?>'
                                           data-placeholder="Required"
                                           class="editable <?php echo e($each->config_a || $each->config_a === 0 ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->config_a || $each->config_a === 0 ? $each->config_a : 'Empty'); ?></a>
                                    <?php else: ?>
                                        <?php echo e($each->config_a); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($sprAdm): ?>
                                        <a href="#" data-field='config_c' data-model="Aircraft" data-type="text" data-id='<?php echo e($each->id); ?>'
                                           data-placeholder="Required"
                                           class="editable <?php echo e($each->config_c || $each->config_c === 0 ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->config_c || $each->config_c === 0 ? $each->config_c : 'Empty'); ?></a>
                                    <?php else: ?>
                                        <?php echo e($each->config_c); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($sprAdm): ?>
                                        <a href="#" data-field='config_w' data-model="Aircraft" data-type="text" data-id='<?php echo e($each->id); ?>'
                                           data-placeholder="Required"
                                           class="editable <?php echo e($each->config_w || $each->config_w === 0 ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->config_w || $each->config_w === 0 ? $each->config_w : 'Empty'); ?></a>
                                    <?php else: ?>
                                        <?php echo e($each->config_w); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($sprAdm): ?>
                                        <a href="#" data-field='config_y' data-model="Aircraft" data-type="text" data-id='<?php echo e($each->id); ?>'
                                           data-placeholder="Required"
                                           class="editable <?php echo e($each->config_y || $each->config_y === 0 ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->config_y || $each->config_y === 0 ? $each->config_y : 'Empty'); ?></a>
                                    <?php else: ?>
                                        <?php echo e($each->config_y); ?>

                                    <?php endif; ?>
                                </td>
                                <td><?php echo $each->type && $each->type->flexi_config ? '<i class="fa fa-check"></i>' : ''; ?></td>
                                <td><?php echo e($each->engine ? $each->engine->name : ""); ?></td>
                                <td><?php if($sprAdm): ?>
                                        <a href="#" data-field='delivery_date' data-model="Aircraft" data-type="date" data-id='<?php echo e($each->id); ?>'
                                           data-placeholder="Required" data-date_format="d-m-y"
                                           class="editable <?php echo e($each->delivery_date ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->delivery_date ? $each->delivery_date : 'Empty'); ?></a>
                                    <?php else: ?>
                                        <?php echo e($each->delivery_date); ?>

                                    <?php endif; ?>
                                </td>

                                <td><?php echo e($each->msn); ?></td>
                                <td><?php echo e($each->line_number); ?></td>
                                <td><?php echo e($each->first_flight && $each->first_flight != EMPTY_DATE ? $each->first_flight : ""); ?></td>

                                <td><?php echo ($each->maintenance_id) ? "<span class='glyphicon glyphicon-remove'></span>" : "<span class='glyphicon glyphicon-ok'></span>"; ?>

                                </td>
                                <td data-center><?php echo $each->email_recipients && trim($each->email_recipients) && !$each->stop_emails ? "<i class='glyphicon glyphicon-ok color-green'></i>" : "<i class='glyphicon glyphicon-remove color-red'></i>"; ?></td>
                                <td>
                                    <div class="btn-group">
                                        <a target="_blank" href="<?php echo e(route("homepage")."#". url("aircraft/show-flights/{$each->id}")); ?>"
                                           class="btn btn-primary btn-sm"><?php echo app('translator')->get("content.show_flights"); ?></a>
                                        <a target="_blank" href="<?php echo e(route("homepage")."#". url("aircraft/{$each->id}?current_airline_id={$currentAirlineId}")); ?>"
                                           class="btn btn-success btn-sm"><?php echo app('translator')->get("content.view"); ?></a>
                                        <a target="_blank" href="<?php echo e(route("homepage")."#". url("aircraft/{$each->id}/edit?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}")); ?>"
                                           class="btn btn-warning btn-sm"><?php echo app('translator')->get("content.edit"); ?></a>
                                        <a href="<?php echo e(route("homepage")."#". url("aircraft/delete/{$each->id}?current_airline_id={$currentAirlineId}")); ?>"
                                           data-confirm-text="Are you sure?" class="btn btn-danger confirm btn-sm"><?php echo app('translator')->get("content.remove"); ?></a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>

                </div>

            </div>



        </div>

    </div>
<?php endif; ?>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/aircraft/list-aircraft.blade.php ENDPATH**/ ?>