<?php

    //initilize the page
    require_once(public_path("smart/inc/init.php"));

    //require UI configuration (nav, ribbon, etc.)
    require_once(public_path("smart/inc/config.ui.php"));

    include_once(public_path("smart/inc/user_variables.php"));


    /*---------------- PHP Custom Scripts ---------

    YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
    E.G. $page_title = "Custom Title" */

    $page_title = "Flight Tracker";

    /* ---------------- END PHP Custom Scripts ------------- */

    //include header
    //you can add your custom css in $page_css array.
    //Note: all css files are inside css/ folder
    $page_css[] = "your_style.css";

    $no_main_header = true;

    $page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

    include(public_path("smart/inc/header.php"));

?>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" class="no-padding" >
    <!--<span id="logo"></span>-->

    <div id="logo-group"  style="height: 60px; width: 100%; padding: 0 15px;" class="flightTrackerBackground">
        <h2 class="flightTracker color-white">FlightTracker</h2>
        

        <!-- END AJAX-DROPDOWN -->
    </div>

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="col-sm-12" style="padding: 0 0 20px 0;">
                        <?php echo $__env->make("flight-tracker.form", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="clearfix"></div>

                    <ul class="nav nav-tabs bordered">
                        <li class="active">
                            <a href="#flights" data-toggle="tab"><i class="fa fa-plane fa-lg"></i> <?php echo app('translator')->get("content.flights"); ?></a>
                        </li>

                        <li class="">
                            <a href="#flight_messages" data-toggle="tab"><i class="fa fa-plane fa-lg"></i> <?php echo app('translator')->get("content.flight_messages"); ?></a>
                        </li>
                    </ul>

                    
                    <div class="tab-content">

                        <div class="tab-pane active bg-color-white" id="flights" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                            <?php if(airlineModule()): ?>
                                <?php echo $__env->make("flight-tracker.layouts.flights-list-airline", ["flightsOPS" => $historicFlights], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php else: ?>
                                <?php echo $__env->make("flight-tracker.layouts.flights-list", ["flightsOPS" => $historicFlights], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>

                        <div class="tab-pane bg-color-white" id="flight_messages" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                            <?php echo $__env->make("flight-tracker.layouts.flight-messages-tab", ["flightsOPS" => $historicFlights], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>

                </article>

            </div>

        </section>

    </div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<script type="text/javascript">
    var baseUrl = "<?php echo e(url('/')); ?>";
    var baseDashboardUrl = "<?php echo e(url('home/dashboard')); ?>";
    var baseHomeUrl = "<?php echo e(route("homepage")."#". url('/')); ?>";
    var AIRLINE = "<?php echo e(env("AIRLINE")); ?>";
    var CARRIER = "<?php echo e(env("CARRIER")); ?>";
    var CURRENT_IATA_CODE = "<?php echo e(env("IATA_CODE")); ?>";
</script>

<?php
    //include required scripts
    include(public_path("smart/inc/scripts.php"));
?>


<!-- PAGE RELATED PLUGIN(S)-->

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyValidationDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#ops-table");

        <?php if(ghaModule()): ?>
            ApplyOperationsFormFilter(<?php echo json_encode($flightNumbers); ?>, <?php echo json_encode(\request("flightNumber")); ?>);
        <?php endif; ?>
    };

    pagefunction();

</script>

<script type="text/javascript">

    runAllForms();

</script>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-tracker/index.blade.php ENDPATH**/ ?>