<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <?php if(in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN])): ?>
                <div class="col-md-12 no-padding margin-bottom-10">
                    <a class="btn btn-primary" href="<?php echo e(route("homepage")."#department/add"); ?>"><?php echo app('translator')->get("content.add_new_department"); ?></a>
                    <a class="btn btn-success" href="<?php echo e(route("homepage")."#department/organization"); ?>" target="_blank"><?php echo app('translator')->get("content.organisation"); ?></a>
                </div>
            <?php endif; ?>

            <div class="clearfix"></div>

            <div>
                <?php if(count($departments)): ?>
                    <div class="jarviswidget jarviswidget-color-blueDark margin-bottom-10" id="wid-id-online"
                         data-widget-editbutton="false" data-widget-colorbutton="false"
                         data-widget-deletebutton="false">

                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                            <h2><?php echo app('translator')->get("content.list"); ?></h2>
                        </header>

                        <!-- widget div-->
                        <div>

                            <!-- widget edit box -->
                            <div class="jarviswidget-editbox">
                                <!-- This area used as dropdown edit box -->

                            </div>
                            <!-- end widget edit box -->

                            <!-- widget content -->
                            <div class="widget-body no-padding" style="min-height: 50px !important;">

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped table-hover">
                                        <thead>
                                        <tr>
                                            <th><?php echo app('translator')->get("content.name"); ?></th>
                                            <th><?php echo app('translator')->get("content.staff_no"); ?></th>
                                            <th><?php echo app('translator')->get("content.subdepartment"); ?></th>
                                            <th><?php echo app('translator')->get("content.library"); ?></th>
                                            <th><?php echo app('translator')->get("content.last_update"); ?></th>
                                            <th style="width: 340px"><?php echo app('translator')->get("content.actions"); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td data-left><?php echo e($department->name); ?></td>
                                                <td><?php echo e(isset($staffByDepartment[$department->id]) ? $staffByDepartment[$department->id]["counter"] : ""); ?></td>
                                                <td><?php echo $department->has_subdepartment ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>"; ?></td>
                                                <td><?php echo $department->has_library ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>"; ?></td>
                                                <td><?php echo e($department->updated_at); ?></td>
                                                <td>
                                                    <div class="btn-group">
                                                        <a class="btn btn-sm btn-primary" target="_blank"
                                                           href="<?php echo e(route("homepage")."#department/organization/{$department->id}"); ?>"><?php echo app('translator')->get("content.organisation"); ?></a>
                                                        <a target="_blank" class="btn btn-sm btn-warning"
                                                           href="<?php echo e(route("homepage")."#department/edit?s=".rand(100, 999)."&id={$department->id}"); ?>"><?php echo app('translator')->get("content.edit"); ?></a>
                                                        <?php if($department->has_subdepartment): ?>
                                                            <a class="btn btn-sm btn-info"
                                                               href="<?php echo e(route("homepage")."#subdepartment/index?department_id={$department->id}"); ?>"><?php echo app('translator')->get("content.subdepartments"); ?></a>
                                                        <?php endif; ?>
                                                        <a class="btn btn-sm btn-success"
                                                               href="<?php echo e(route("homepage")."#position/index?department_id={$department->id}"); ?>"><?php echo app('translator')->get("content.positions"); ?></a>

                                                        <a class="btn btn-sm btn-danger confirm"
                                                           data-confirm-text="Are you sure you want to remove this department?"
                                                           href="<?php echo e(route("homepage")."#department/delete?id={$department->id}"); ?>"><?php echo app('translator')->get("content.delete"); ?></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning margin-top-10">No departments listed.</div>
                <?php endif; ?>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        ApplyTableFilter(".table");

    };

    pagefunction();

</script>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/department/index.blade.php ENDPATH**/ ?>