<table id="<?php echo e($headFltType); ?>_table" class="flightsTable table table-bordered table-hover" style="width: 100%; height: 100%;">
    <thead>
        <tr class="table-title">
            <th style="padding: 0 !important;" ></th>
            <th style="">Flight Details</th>
        </tr>
        </thead>

        <tbody>

        <?php $logoWidth = $airlineModule ? 32 : 64 ?>

        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <?php $fltType = $flight->type ?>

            <?php $flightNumber = $flight->flightNumber ?>
            <?php $airline = $flightNumber ? $flightNumber->airline : null ?>
            <?php list($fn1, $fn2, $fn3) = getFlightNumberStrings($flight) ?>

            <?php $childDiff = false ?>
            <?php if($flight->flightChild): ?>
                <?php $childDiff = strtotime(getFlightDepartureDate($flight->flightChild)) > strtotime(getFlightDepartureDate($flight)) ?>
            <?php endif; ?>

            <?php $depAP = getFlightDepartureAirport($flight) ?>
            <?php $dep = $depAP ? $depAP->iata : "" ?>

            <?php $arrAP = getFlightArrivalAirport($flight) ?>
            <?php $arr = $arrAP ? $arrAP->iata : "" ?>

            <?php $depType = getFlightDepartureTimeType($flight, true) ?>
            <?php $depInitialType = getFlightDepartureInitialTimeType($flight, true) ?>

            <?php $arrType = getFlightArrivalTimeType($flight, true) ?>
            <?php $arrInitialType = getFlightArrivalInitialTimeType($flight, true) ?>

            <?php $fnReady = $fn3 ? $fn3 : $fn2 ?>
            <?php $sectorReady = " | ".$dep."-".$arr."" ?>

            
            <?php $ac = getFlightAircraft($flight) ?>
            <?php $acType = getFlightAircraftType($flight) ?>

            <?php $cap =  getFlightCapacity($flight) ?>
            <?php $bookedPax = getFlightBookedPax($flight) ?>
            <?php $actualPax = getFlightActualPax($flight) ?>

            <?php $capReady = "CFG ".($cap[0] ? $cap[0]."C " : "").$cap[1]."Y" ?>
            <?php $bookedPaxReady = ($bookedPax[0] || $bookedPax[1]) ? "BKD ".($bookedPax[0] ? $bookedPax[0]."C " : "").$bookedPax[1]."Y" : "" ?>
            <?php $actualPaxReady = ($actualPax[0] || $actualPax[1]) ? "ACT ".($actualPax[0] ? $actualPax[0]."C " : "").$actualPax[1]."Y" : "" ?>

            <?php $aircraftDetails = $acType.($ac ? " | ".$ac : "") ?>

            <?php $fltDepDetails = $aircraftDetails." | ".$capReady.($bookedPaxReady ? " | ".$bookedPaxReady : "").($actualPaxReady ? " | ".$actualPaxReady : "") ?>
            <?php $fltArrDetails = $aircraftDetails." | ".$capReady.($actualPaxReady ? " | ".$actualPaxReady : "") ?>

            

            <?php $flightRadarLink = ($airline ? $airline->iata ? $airline->iata : ($airline->icao ? $airline->icao : "") : "") .ltrim($flightNumber->flight_number, "0") ?>
            <?php $flightStatus = getFlightClassNameStrict($flight, $fltType) ?>

            <?php list($delayCodes, $delayTimes) = getFlightDelays($flight, true) ?>

            <?php if(isset($isMobile) && $isMobile): ?>

                <?php $depSpan = departureArrivalTypeSpan($depType, null, "inline-block", "22px !important") ?>
                <?php $depInitialSpan = departureArrivalTypeSpan($depInitialType, null, "inline-block", "22px !important") ?>

                <?php $arrSpan = departureArrivalTypeSpan($arrType, null, "inline-block", "22px !important") ?>
                <?php $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null, "inline-block", "22px !important") ?>

                <?php $depInitialTxt = $depInitialSpan . "<span class='dep-time-initial'>" . baseDateFormat(getFlightDepartureInitialDate($flight), true, " ", true, false, "") . "</span>" ?>
                <?php $depTxt = $depSpan . "<span id='flt_dep_arr_time' class='dep-time'>" . baseDateFormat(getFlightDepartureDate($flight), true, " ", true, false, "") . "</span>" ?>

                <?php $arrInitialTxt = $arrInitialSpan . "<span class='arr-time-initial'>" . baseDateFormat(getFlightArrivalInitialDate($flight), true, " ", true, false, "") . "</span>" ?>
                <?php $arrTxt = $arrSpan . "<span id='flt_dep_arr_time' class='arr-time'>" . baseDateFormat(getFlightArrivalDate($flight), true, " ", true, false, ""). "</span>" ?>

                <?php echo e(debug($fnReady." ".$fltType)); ?>

                <?php if($fltType == DEPARTURE): ?>
                    <tr class="flight_row" data-child_id="<?php echo e($flight->flightChild && $childDiff ? $flight->flightChild->id : ''); ?>" data-flight_id="<?php echo e($flight->id); ?>" data-parent_id="<?php echo e($flight->parent_id); ?>" data-fn="<?php echo e($fnReady); ?>" data-sector="<?php echo e($sectorReady); ?>" data-remark="<?php echo e($flight->remark); ?>"
                        data-dep="<?php echo e($depTxt); ?>" data-arr="<?php echo e($arrTxt); ?>" data-flight_radar="<?php echo e($flightRadarLink); ?>"
                        data-flt_ac_type="<?php echo e($acType); ?>" data-flt_ac="<?php echo e($ac); ?>" data-flt_cfg="<?php echo e($capReady); ?>"
                        data-flt_bkd="<?php echo e($bookedPaxReady); ?>" data-flt_act="<?php echo e($actualPaxReady); ?>"
                        data-flt_dep_details="<?php echo e($fltDepDetails); ?>" data-flt_type="<?php echo e($fltType); ?>">
                <?php else: ?>
                    <tr class="flight_row" data-child_id="<?php echo e($flight->flightChild && $childDiff ? $flight->flightChild->id : ''); ?>" data-flight_id="<?php echo e($flight->id); ?>" data-parent_id="<?php echo e($flight->parent_id); ?>" data-fn="<?php echo e($fnReady); ?>" data-sector="<?php echo e($sectorReady); ?>" data-remark="<?php echo e($flight->remark); ?>"
                        data-dep="<?php echo e($depTxt); ?>" data-arr="<?php echo e($arrTxt); ?>" data-flight_radar="<?php echo e($flightRadarLink); ?>"
                        data-flt_ac_type="<?php echo e($acType); ?>" data-flt_ac="<?php echo e($ac); ?>" data-flt_cfg="<?php echo e($capReady); ?>"
                        data-flt_bkd="" data-flt_act="<?php echo e($actualPaxReady); ?>"
                        data-flt_arr_details="<?php echo e($fltArrDetails); ?>" data-flt_type="<?php echo e($fltType); ?>">
                <?php endif; ?>

                    <td class="flight-status <?php echo e($flightStatus); ?>"></td>

                    <td class="flight-box" style="padding: 10px 5px !important; width: 98% !important;">
                        <?php if($headFltType == CANCELLED || $flight->cancelled_at): ?>
                            <div style="float: none; clear: both;">
                                <span id="" style="display:inline-block; font-size: 18px"
                                      class="label label-danger departureArrivalType">FLIGHT CANCELLED</span>
                            </div>
                        <?php endif; ?>

                        <?php if(!$airlineModule): ?>
                            <div style="float: left; padding: 20px 10px;">
                                <?php $icon = strtolower($fltType)."64.png" ?>
                                <img class="dep-arr-icon" style="max-height: 64px; max-width: 48px;" src="<?php echo e(asset("assets/img/icons/others/{$icon}")); ?>" />
                            </div>
                        <?php endif; ?>

                        <div style="float: left; margin-left: 5px; height: 100%; width: calc(100% - 160px);">
                            
                            <div style="float: left; margin: 15px 5px; width: <?php echo e($logoWidth * 2); ?>px; ">
                                <img class='flightTracker-airline-logo' style="max-height: 40px; max-width: 100%;" src='<?php echo e(getAirlineLogo($airline, true)); ?>'/>
                            </div>

                            <div style="float: left; margin: 5px; width: 150px">
                                <?php $addStyles = strlen($fnReady) >= 7 ? "font-size:30px; padding: 2px 0;" : "" ?>
                                <h1 class="flightTracker-airline" style="margin: 5px 0 !important; <?php echo e($addStyles); ?>"><?php echo e($fnReady); ?></h1>
                            </div>
                            <div style="float: left; margin: 5px 10px; margin-left: 0; width: 210px;">
                                <h1 class="flightTracker-airline" style="margin: 5px 0 !important;"><?php echo e($sectorReady); ?></h1>
                            </div>

                            <div style="float: left; margin: 15px 0; ">
                                <h3 class="ac-details" style="line-height: 30px; margin: 0;">| <?php echo e($aircraftDetails); ?></h3>
                            </div>

                            <div style="float: left; margin-left: 5px;">
                                <?php if($airlineModule): ?>
                                    <h3 class="flight-timings" style="margin: 5px 0;"><?php echo $depInitialTxt." ".$depTxt ." ". $arrTxt; ?>


                                    </h3>
                                <?php else: ?>
                                    <?php if($fltType == DEPARTURE): ?>
                                        <h3 class="flight-timings" style="margin: 5px 0;"><?php echo ($depType == $depInitialType ? "" :  $depInitialTxt) ." ". $depTxt; ?></h3>
                                    <?php else: ?>
                                        <h3 class="flight-timings" style="margin: 5px 0;"><?php echo ($arrType == $arrInitialTxt ? "" :  $arrInitialTxt) ." ". $arrTxt; ?></h3>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="flight_msg_count" style="float: right; padding: 10px;">
                            <span class="font-lg badge badge-warning" style="background-color: #00bd00; font-size: 24px;"></span>
                        </div>
                    </td>

                </tr>
            <?php else: ?>
                <?php $depSpan = departureArrivalTypeSpan($depType, null) ?>
                <?php $depInitialSpan = departureArrivalTypeSpan($depInitialType, null) ?>

                <?php $arrSpan = departureArrivalTypeSpan($arrType, null) ?>
                <?php $arrInitialSpan = departureArrivalTypeSpan($arrInitialType, null) ?>

                <?php $depInitialTxt = $depInitialSpan . "<span class='dep-time-initial'>" . baseDateFormat(getFlightDepartureInitialDate($flight), true, " ", true, false, "") . "</span>" ?>
                <?php $depTxt = $depSpan . "<span id='flt_dep_arr_time' class='dep-time'>" . baseDateFormat(getFlightDepartureDate($flight), true, " ", true, false, "") . "</span>" ?>

                <?php $arrInitialTxt = $arrInitialSpan . "<span class='arr-time-initial'>" . baseDateFormat(getFlightArrivalInitialDate($flight), true, " ", true, false, "") . "</span>" ?>
                <?php $arrTxt = $arrSpan . "<span id='flt_dep_arr_time' class='arr-time'>" . baseDateFormat(getFlightArrivalDate($flight), true, " ", true, false, ""). "</span>" ?>

                <tr class="flight_row" data-child_id="<?php echo e($flight->flightChild && $childDiff ? $flight->flightChild->id : ''); ?>" data-parent_id="<?php echo e($flight->parent_id); ?>" data-flight_id="<?php echo e($flight->id); ?>" data-fn="<?php echo e($fnReady); ?>" data-sector="<?php echo e($sectorReady); ?>" data-remark="<?php echo e($flight->remark); ?>"
                    data-dep="<?php echo e($depTxt); ?>" data-arr="<?php echo e($arrTxt); ?>" data-flight_radar="<?php echo e($flightRadarLink); ?>"
                    data-flt_ac_type="<?php echo e($acType); ?>" data-flt_ac="<?php echo e($ac); ?>" data-flt_cfg="<?php echo e($capReady); ?>"
                    data-flt_bkd="<?php echo e($bookedPaxReady); ?>" data-flt_act="<?php echo e($actualPaxReady); ?>"
                    data-flt_dep_details="<?php echo e($fltDepDetails); ?>" data-flt_arr_details="<?php echo e($fltArrDetails); ?>" data-flt_type="<?php echo e($fltType); ?>">

                    <td style="width: 10px !important;" class="flight-status <?php echo e($flightStatus); ?>"></td>

                    <td class="flight-box" style="padding: 0 5px !important; width: 98% !important;">
                        <?php if($headFltType == CANCELLED || $flight->cancelled_at): ?>
                            <div style="float: none;">
                            <span id="" style="display:inline-block; font-size: 18px"
                                  class="label label-danger departureArrivalType">FLIGHT CANCELLED</span>
                            </div>
                        <?php endif; ?>

                        <?php if(!$airlineModule): ?>
                            <div style="float: left; padding: 10px 7px 10px 3px;">
                                <?php $icon = strtolower($fltType)."32.png" ?>
                                <img class="dep-arr-icon" style="max-height: 32px; max-width: 24px" src="<?php echo e(asset("assets/img/icons/others/{$icon}")); ?>" />
                            </div>
                        <?php endif; ?>

                        <div style="float:left;">
                            <div style="float: left; margin: 5px; width: <?php echo e($logoWidth); ?>px; ">
                                <img class='flightTracker-airline-logo' style="max-height: 30px; max-width: 100%;" src='<?php echo e(getAirlineLogo($airline, true)); ?>'/>
                            </div>
                            <div style="float: left; margin: 0 5px; width: 65px;">
                                <?php $addStyles = strlen($fnReady) >= 7 ? "font-size:15px; padding: 2px 0;" : "" ?>
                                <h4 class="flightTracker-airline" style="margin: 5px 0 !important; <?php echo e($addStyles); ?>">
                                    <?php echo e($fnReady); ?>

                                </h4>
                            </div>
                            <div style="float: left; margin: 0 5px; width: 105px;">
                                <h4 class="flightTracker-airline" style="margin: 5px 0 !important;">
                                    <?php echo e($sectorReady); ?>

                                </h4>
                            </div>
                            <div style="float: left; margin: 5px 0; height: 100%; vertical-align: middle">
                                <h6 class="ac-details" style="line-height: 20px;">| <?php echo e($aircraftDetails); ?></h6>
                            </div>
                            <div class="clearfix"></div>
                            <div>
                                <?php if($airlineModule): ?>
                                    <h6 class="flight-timings"><?php echo $depInitialTxt." ".$depTxt." ". $arrTxt; ?> <span class="color-red"><strong><?php echo e($delayCodes ? "*DL ".$delayCodes : ""); ?></strong></span></h6>
                                <?php else: ?>
                                    <?php if($fltType == DEPARTURE): ?>
                                        <h6 class="flight-timings"><?php echo ($depType == $depInitialType ? "" :  $depInitialTxt) ." ". $depTxt; ?></h6>
                                    <?php else: ?>
                                        <h6 class="flight-timings"><?php echo ($arrType == $arrInitialType ? "" :  $arrInitialTxt) ." ". $arrTxt; ?></h6>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="flight_msg_count" style="float: right;line-height: 50px; height: 100%;">
                            <span class="badge badge-warning" style="background-color: #00bd00"></span>
                        </div>
                    </td>

                </tr>
            <?php endif; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>

    </table>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-com/layouts/flights-table.blade.php ENDPATH**/ ?>