

<div class="clearfix"></div>

<?php if(!count($flights)): ?>
    <div class="alert alert-info">
        <?php if(\request("type") && \request("type") == $type): ?>
            <?php echo app('translator')->get("content.found"); ?> 0 <?php echo app('translator')->get("content.records"); ?>
        <?php else: ?>
            <?php echo app('translator')->get("content.please_select_period_and_press_submit"); ?>
        <?php endif; ?>
    </div>
<?php else: ?>

    <div class="col-md-12 form-inline" style="margin: 10px 0 20px 0">
        <label class="control-label" style="margin-right: 20px">
            <?php echo Form::checkbox("select_all", "1", false, ['class' => 'form-control select-all']); ?>

            <?php echo app('translator')->get("content.select_all"); ?>
        </label>
        <?php if($type == CANCELLED): ?>
            <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected"
                    data-url="<?php echo e(url("flight-view/delete-selected")); ?>"
                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.remove"); ?> <?php echo app('translator')->get("content.selected_flights"); ?></button>

            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected"
                    data-url="<?php echo e(url("flight-view/restore-selected")); ?>"
                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.restore"); ?> <?php echo app('translator')->get("content.selected_flights"); ?></button>
        <?php elseif($type == REMOVED): ?>
            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected"
                    data-url="<?php echo e(url("flight-view/cancel-selected")); ?>"
                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.cancel"); ?> <?php echo app('translator')->get("content.selected_flights"); ?></button>

            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected"
                    data-url="<?php echo e(url("flight-view/restore-selected")); ?>"
                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.restore"); ?> <?php echo app('translator')->get("content.selected_flights"); ?></button>
        <?php else: ?>
            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected"
                    data-url="<?php echo e(url("flight-view/cancel-selected")); ?>"
                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.cancel"); ?> <?php echo app('translator')->get("content.selected_flights"); ?></button>

            <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected"
                    data-url="<?php echo e(url("flight-view/delete-selected")); ?>"
                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.remove"); ?> <?php echo app('translator')->get("content.selected_flights"); ?></button>
        <?php endif; ?>
    </div>

    <div class="clearfix"></div>

    <div class="jarviswidget jarviswidget-color-blueDark" id="<?php echo e($type); ?>_container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2><?php echo app('translator')->get("content.list"); ?></h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important; ">

            <div class="table-responsive">

                <table class="table table-bordered table-hover">
                    <thead>
                    <tr>
                        <th rowspan="2">SEL</th>
                        <th rowspan="2">No</th>

                            <th rowspan="2" style="min-width: 160px;"><?php echo app('translator')->get("content.actions"); ?></th>


                        <th rowspan="2" style="min-width: 50px;"><?php echo app('translator')->get("content.flight"); ?></th>
                        <th rowspan="2">SVC TYPE</th>
                        <th rowspan="2">DEP</th>
                        <th rowspan="2">ARR</th>
                        <th rowspan="2">AC TYPE</th>
                        <th rowspan="2"><?php echo app('translator')->get("content.aircraft"); ?></th>
                        <th class="bg-success" rowspan="2"><?php echo app('translator')->get("content.staff_assigned"); ?></th>

                        <th colspan="5" data-center><?php echo app('translator')->get("content.departure_time"); ?></th>
                        <th colspan="5" data-center><?php echo app('translator')->get("content.arrival_time"); ?></th>

                        <th colspan="3">PAX BKD</th>
                        <th colspan="3">PAX ACT</th>

                        <th rowspan="2" style="min-width: 200px;"><?php echo app('translator')->get("content.messages"); ?></th>

                        <?php if($type == CANCELLED): ?>
                            <th colspan="2"><?php echo app('translator')->get("content.cancelled"); ?></th>
                        <?php elseif($type == REMOVED): ?>
                            <th colspan="2"><?php echo app('translator')->get("content.removed"); ?></th>
                        <?php else: ?>
                            <th rowspan="2"><?php echo app('translator')->get("content.notes"); ?></th>
                        <?php endif; ?>

                        <th colspan="2" data-center><?php echo app('translator')->get("content.last_update"); ?></th>
                        <th colspan="2" data-center><?php echo app('translator')->get("content.created"); ?></th>
                    </tr>
                    <tr>
                        <th style="min-width: 100px;">STD</th>
                        <th style="min-width: 100px;">PTD</th>
                        <th style="min-width: 100px;">ETD</th>
                        <th style="min-width: 100px;">ATD</th>
                        <th style="min-width: 100px;">ABN</th>

                        <th style="min-width: 100px;">STA</th>
                        <th style="min-width: 100px;">PTA</th>
                        <th style="min-width: 100px;">ETA</th>
                        <th style="min-width: 100px;">TDN</th>
                        <th style="min-width: 100px;">ATA</th>

                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>

                        <th>C</th>
                        <th>Y</th>
                        <th>INF</th>

                        <?php if($type == CANCELLED || $type == REMOVED): ?>
                            <th style="min-width: 80px;"><?php echo app('translator')->get("content.date"); ?></th>
                            <th style="min-width: 120px;"><?php echo app('translator')->get("content.reason"); ?></th>
                        <?php endif; ?>

                        <th style="min-width: 120px;"><?php echo app('translator')->get("content.user"); ?></th>
                        <th style="min-width: 100px;"><?php echo app('translator')->get("content.date"); ?></th>

                        <th style="min-width: 140px;"><?php echo app('translator')->get("content.schedule"); ?></th>
                        <th style="min-width: 100px;"><?php echo app('translator')->get("content.data"); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $aircraft = $each->aircraft ?>
                        <?php $flightNumber = $each->flightNumber ?>
                        <?php $acType = getFlightAircraftType($each) ?>

                        <?php if($each->deleted_at): ?>
                            <?php $notes = "Removed at ". $each->deleted_at. " (".$each->remark.")"; ?>
                        <?php elseif($each->cancelled_at): ?>
                            <?php $notes = "Cancelled at ". $each->cancelled_at. " (".$each->remark.")"; ?>
                        <?php else: ?>
                            <?php $notes = $each->remark ?>
                        <?php endif; ?>

                        <tr data-flight_id="<?php echo e($each->id); ?>">
                            <td>
                                <?php echo Form::checkbox("selected", "1", false, ['class' => 'form-control flight', "data-flight_id" => $each->id ]); ?>

                            </td>
                            <td><?php echo e($j + 1); ?></td>

                                <td>
                                    <div class="btn-group">
                                        <?php if($type == REMOVED): ?>
                                            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.restore"); ?></button>
                                            <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.cancel"); ?></button>


                                        <?php elseif($type == CANCELLED): ?>
                                            <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                    data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.restore"); ?></button>
                                            <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                    data-url="<?php echo e(url('flight-view/delete-selected')); ?>" data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.remove"); ?></button>


                                        <?php else: ?>
                                            <?php if($each->deleted_at): ?>
                                                <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                        data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.restore"); ?></button>

                                                <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                        data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.cancel"); ?></button>
                                                

                                            <?php elseif($each->cancelled_at): ?>
                                                <button type="button" class="btn btn-primary confirmation-modal-action-btn" data-action="restore-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                        data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.restore"); ?></button>
                                                <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                        data-url="<?php echo e(url('flight-view/delete-selected')); ?>" data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.remove"); ?></button>


                                            <?php else: ?>
                                                <a target="_blank" href="<?php echo e(route("homepage")."#".url("flight/$each->id/edit")); ?>" class="btn btn-success"><?php echo app('translator')->get("content.edit"); ?></a>
                                                <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="cancel-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                        data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.cancel"); ?></button>
                                                <button type="button" class="btn btn-danger confirmation-modal-action-btn" data-action="delete-selected" data-flight_id="<?php echo e($each->id); ?>"
                                                        data-url="<?php echo e(url('flight-view/delete-selected')); ?>" data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.remove"); ?></button>


                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </td>

                            <td><a target="_blank" href="<?php echo e(url("flight-tracker/{$each->id}")); ?>"><?php echo e(getFlightNumberFull($flightNumber)); ?></a></td>
                            <td><?php echo e(getFlightNumberType($each->flightNumber)); ?></td>
                            <td><?php echo e(getFlightDepartureAirport($each, false, true)); ?></td>
                            <td><?php echo e(getFlightArrivalAirport($each, false, true)); ?></td>
                            <td><?php echo e($acType); ?></td>
                            <td><?php echo e($aircraft ? $aircraft->name : "-"); ?></td>
                            <td data-center><?php echo $each->staff_exists ? "<i class='fa fa-check color-green'></i>" : ""; ?></td>

                            <td data-center><?php echo $each->std && $each->std != EMPTY_DATETIME ? baseUSDateFormat($each->std, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->ptd && $each->ptd != EMPTY_DATETIME ? baseUSDateFormat($each->ptd, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->etd && $each->etd != EMPTY_DATETIME ? baseUSDateFormat($each->etd, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->atd && $each->atd != EMPTY_DATETIME ? baseUSDateFormat($each->atd, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->abn && $each->abn != EMPTY_DATETIME ? baseUSDateFormat($each->abn, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>

                            <td data-center><?php echo $each->sta && $each->sta != EMPTY_DATETIME ? baseUSDateFormat($each->sta, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->pta && $each->pta != EMPTY_DATETIME ? baseUSDateFormat($each->pta, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->eta && $each->eta != EMPTY_DATETIME ? baseUSDateFormat($each->eta, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->tdn && $each->tdn != EMPTY_DATETIME ? baseUSDateFormat($each->tdn, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>
                            <td data-center><?php echo $each->ata && $each->ata != EMPTY_DATETIME ? baseUSDateFormat($each->ata, true, "-") : "<i class='fa fa-remove color-red'></i>"; ?></td>

                            <td><?php echo e($each->pax_c_booked); ?></td>
                            <td><?php echo e($each->pax_y_booked); ?></td>
                            <td><?php echo e($each->pax_inf_booked); ?></td>

                            <td><?php echo e($each->pax_c_actual); ?></td>
                            <td><?php echo e($each->pax_y_actual); ?></td>
                            <td><?php echo e($each->pax_inf_actual); ?></td>

                            <td><?php echo getFlightMessages($each, 2, ""); ?></td>

                            <?php if($type == CANCELLED): ?>
                                <td><span class='color-red'><?php echo e(baseUSDateFormat($each->cancelled_at, true, "-")); ?></span></td>
                                <td><span class='color-red'><?php echo e($each->remark); ?></span></td>
                            <?php elseif($type == REMOVED): ?>
                                <td><span class='color-red'><?php echo e(baseUSDateFormat($each->deleted_at, true, "-")); ?></span></td>
                                <td><span class='color-red'><?php echo e($each->remark); ?></span></td>
                            <?php else: ?>
                                <td><span class='color-red'><?php echo e($notes); ?></span></td>
                            <?php endif; ?>

                            <td><?php echo e($each->user ? $each->user->first_name." ".$each->user->last_name : "-"); ?></td>
                            <td><?php echo e($each->updated_at ? baseUSDateFormat($each->updated_at, true, "-") : "-"); ?></td>

                            <?php if($each->flightSchedule): ?>
                                <td><?php echo e($each->flightSchedule->name); ?></td>
                                <td><?php echo e(baseUSDateFormat($each->flightSchedule->created_at, true, "-")); ?></td>
                            <?php else: ?>
                                <td>-</td>
                                <td><?php echo e(baseUSDateFormat($each->created_at, true, "-")); ?></td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>

            </div>
        </div>

    </div>

</div>
<?php endif; ?><?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-view/layouts/flights-list.blade.php ENDPATH**/ ?>