<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#library" role="tab" data-toggle="tab"><?php echo e(str_replace("_", " ", env(AIRLINE))); ?></a>
                </li>
                <?php if(ghaModule()): ?>
                    <li>
                        <a href="#airlines" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.airlines"); ?></a>
                    </li>
                <?php else: ?>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a href="#dept<?php echo e($department->id); ?>" role="tab" data-toggle="tab"><?php echo e($department->name); ?></a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </ul>

            <?php $active = 0 ?>
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="library">
                    <?php echo $__env->make("library.layouts.index-library-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>

                <?php if(ghaModule()): ?>
                    <div class="tab-pane" id="airlines">
                        <?php echo $__env->make("library.layouts.index-airlines-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                <?php else: ?>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane" id="dept<?php echo e($department->id); ?>">
                            <?php echo $__env->make("library.layouts.index-department-tab", ["department" => $department] , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    }

    pagefunction();

</script><?php /**PATH /home/avbis/public_html/coastal/resources/views/library/index.blade.php ENDPATH**/ ?>