<div class="col-md-12 no-padding margin-bottom-10">
    <a href="<?php echo e(route("homepage")."#". url("staff-license/create/{$user->id}")); ?>" class="btn btn-primary"><?php echo app('translator')->get("content.attach_license_approval"); ?></a>
</div>

<div class="clearfix"></div>

<?php if(!count($staffLicenses)): ?>
    <div class="alert alert-info" role="alert">
        <a href="#" class="alert-link"><?php echo app('translator')->get("content.info"); ?><br/></a>
        <?php echo app('translator')->get("content.there_are_no_licenses_attached"); ?>
    </div>
<?php else: ?>
    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-license-tab" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2><?php echo app('translator')->get("content.list"); ?></h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive editable_div">

                <table class="table table-bordered table-hover" id="licenses-table">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th><?php echo app('translator')->get("content.license_approval"); ?></th>
                        <th style="min-width: 80px;"><?php echo app('translator')->get("content.abbr"); ?></th>
                        <th style="min-width: 100px;"><?php echo app('translator')->get("content.doi"); ?></th>
                        <th style="min-width: 100px;"><?php echo app('translator')->get("content.dex"); ?></th>
                        <th><?php echo app('translator')->get("content.remove"); ?></th>
                        <th><?php echo app('translator')->get("content.status"); ?></th>
                        <th style="min-width: 340px;"><?php echo app('translator')->get("content.actions"); ?></th>
                        <th><?php echo app('translator')->get("content.upload"); ?></th>
                        <th style="min-width: 120px;"><?php echo app('translator')->get("content.created"); ?></th>
                        <th style="min-width: 120px;"><?php echo app('translator')->get("content.updated"); ?></th>

                        <?php $logPermission = isAdminOrSuperAdmin() ?>
                        <?php if($logPermission): ?>
                            <th><?php echo app('translator')->get("content.history"); ?></th>
                        <?php endif; ?>
                    </tr>






                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $staffLicenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $licenseExists = $each->attachment_file ? true : false ?>
                        <?php if(!$each->license): ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <tr>
                            <td data-center><?php echo e($i + 1); ?></td>
                            <td><?php echo e($each->license->name); ?></td>
                            <td><strong><?php echo e($each->license->abbr); ?></strong></td>

                            <td>
                                <a href="#" data-field='license_id' data-field_value="<?php echo e($each->license->id); ?>" data-model="StaffLicense" data-foreign_key='user_id' data-type="date" data-id='<?php echo e($user->id); ?>' data-placeholder="Required" data-format='d-M-Y'
                                   data-js_format = 'DD-MMM-YYYY'  data-value_key="issue_date"  data-value='<?php echo e($each->issue_date); ?>'
                                   class="editable <?php echo e($each->issue_date ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->issue_date ? date('d-M-Y', strtotime($each->issue_date))  : 'Empty'); ?></a>
                            </td>

                            <td>
                                <a href="#" data-field='license_id' data-field_value="<?php echo e($each->license->id); ?>" data-model="StaffLicense" data-foreign_key='user_id' data-type="date" data-id='<?php echo e($user->id); ?>' data-placeholder="Required" data-format='d-M-Y'
                                   data-js_format = 'DD-MMM-YYYY'  data-value_key="expiry_date"  data-value='<?php echo e($each->expiry_date); ?>'
                                   class="editable <?php echo e($each->expiry_date ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->expiry_date ? date('d-M-Y', strtotime($each->expiry_date))  : 'Empty'); ?></a>
                            </td>
                            <td>
                                <a href="<?php echo e(url("staff-license/delete/{$each->id}")); ?>" class="btn btn-danger"><?php echo app('translator')->get("content.delete"); ?></a>
                            </td>

                            <td><?php echo Expiration_Date($each->expiry_date, $each->issue_date)['status']; ?></td>

                            <td>
                                <div class="btn-group">
                                    <?php if($licenseExists): ?>
                                        <a target="_blank" href="<?php echo e(url("staff-license/{$each->id}")); ?>?view=1" class="btn btn-warning"><?php echo app('translator')->get("content.view"); ?></a>
                                        <a href="<?php echo e(url("staff-license/{$each->id}")); ?>?download=1" class="btn btn-primary"><?php echo app('translator')->get("content.download"); ?></a>
                                        <a href="<?php echo e(route("homepage")."#". url("staff-license/delete/file/{$each->id}")); ?>" class="btn btn-danger"><?php echo app('translator')->get("content.remove"); ?></a>
                                    <?php endif; ?>
                                    <a class="btn btn-success edit-update"><?php echo app('translator')->get("content.upload"); ?></a>
                                </div>
                            </td>
                            <td>
                                <div class="upload-container" style="padding: 15px; display: none" >
                                    <?php echo Form::open(['files' => true, 'method' => 'POST', 'url' => url("staff-license/{$each->id}")]); ?>

                                        <?php echo Form::file('file'); ?>


                                        <br/>
                                        <div class="btn-group">
                                            <?php echo Form::submit( trans("content.upload"), ['class' => 'btn btn-success', 'name' => 'upload']); ?>

                                        </div>

                                    <?php echo Form::close(); ?>

                                </div>
                            </td>

                            <td><?php echo e(baseDateFormat($each->created_at, true)); ?></td>

                            <td><?php echo e(baseDateFormat($each->updated_at, true)); ?></td>

                            

                            <?php if($logPermission): ?>
                                <td>
                                    <a target="_blank" href="<?php echo e(route("homepage")."#". url("system-log/staff-license/{$each->id}")); ?>">
                                        <?php echo app('translator')->get("content.show_history"); ?>
                                    </a>
                                </td>
                            <?php endif; ?>
                        </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>
<?php endif; ?><?php /**PATH /home/avbis/public_html/coastal/resources/views/staff/layouts/licenses-tab.blade.php ENDPATH**/ ?>