<div class="tab-pane tab_holder <?php echo e(($reportType && $reportType === 'Standby') ? 'active' : ''); ?>" id="standby">
    <?php $dateFrom = \request("monthlyHoursPeriodFrom") ? \request("monthlyHoursPeriodFrom") : date('Y-m-d', strtotime('first day of this month')) ?>
    <?php $dateTo = \request("monthlyHoursPeriodTo") ? \request("monthlyHoursPeriodTo") : date('Y-m-d') ?>
    <div class="col-md-12" style="margin-bottom: 10px;">
        <?php echo Form::open(['method' => 'GET', 'url' => url("crew/report?reportType=Standby"), 'class'=>"form-inline", 'id' => 'formStandby' ]); ?>

        <div class="form-group marginBottomRight">
            <label class="control-label"><?php echo app('translator')->get("content.crew"); ?></label>
            <?php echo Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']); ?>

        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label"><?php echo app('translator')->get("content.designation"); ?></label>
            <?php echo Form::select('designation', $designationList , \request("destination"), ['class'=>'form-control input_roster crew_designation']); ?>

        </div>
        <div class="form-group marginBottomRight">
            <label><?php echo Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo'); ?> <?php echo app('translator')->get("content.period"); ?> <?php echo app('translator')->get("content.from"); ?></label>
            <?php echo Form::input('text', 'dateFrom', $dateFrom, ['class'=>'dateFrom form-control']); ?>

            <label class="control-label"><?php echo app('translator')->get("content.to"); ?></label>
            <?php echo Form::input('text', 'dateTo', $dateTo, ['class'=>'dateTo form-control']); ?>

        </div>

        <div class="form-group marginBottomRight">
            <label><?php echo Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear'); ?> <?php echo app('translator')->get("content.month"); ?></label>
            <div class="btn-group">
                <?php echo Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect']); ?>

            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label for="year" class="control-label"><?php echo app('translator')->get("content.year"); ?></label>
            <div class="btn-group">
                <?php echo Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect']); ?>

            </div>
        </div>

        <div class="form-group marginBottomRight">

            <?php echo Form::input('submit', 'submit','Submit',[ 'class' => "btn btn-primary"]); ?>

        </div>
        <?php echo Form::close(); ?>

    </div>

    <?php if(count($crew) && count($crewStandbyHours)): ?>
        <div class="clearfix"></div>
        <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
            <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            data-widget-colorbutton="false"
            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

            -->
            <header>
                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2><?php echo app('translator')->get("content.list"); ?> </h2>

            </header>

            <!-- widget div-->
            <div style="width: 100%;overflow: auto;">

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">
                    <table class="table table-bordered table-striped table-hover" data-excel='1'>
                        <thead>
                        <tr>
                            <th rowspan="2">No</th>
                            <th rowspan="2"></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.first_name"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.last_name"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.base"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.designation"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.qty"); ?></th>
                            <th rowspan="2"><?php echo app('translator')->get("content.standby_hours"); ?></th>
                            <?php if(\request("dateSearch") && \request("dateSearch") == 'monthYear'): ?>
                                <th colspan="<?php echo e(count($monthArray)); ?>"><?php echo app('translator')->get("content.monthly_hours"); ?></th>
                            <?php endif; ?>
                            <th colspan="3"><?php echo app('translator')->get("content.not_available"); ?></th>
                        </tr>
                        <tr>
                            <?php if(\request("dateSearch") && \request("dateSearch") == 'monthYear'): ?>
                                <?php $__currentLoopData = $monthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($month); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <th><?php echo app('translator')->get("content.from"); ?></th>
                            <th><?php echo app('translator')->get("content.to"); ?></th>
                            <th><?php echo app('translator')->get("content.reason"); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $i = 0 ?>
                        <?php $__currentLoopData = $crew; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id=>$each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $i++ ?>
                            <?php $designation = Crew_Designation($crewType, $each) ?>
                            <?php $counter = isset($standbyCount[$id]) ? round($standbyCount[$id], 2) : 0 ?>
                            <?php $picture = $each->thumb ? '/storage/users/'.$each->thumb : '/assets/img/default-user-picture.png' ?>
                            <?php $hoursTotal = isset($crewStandbyHours[$id]) ? round($crewStandbyHours[$id], 2) : 0 ?>
                            <tr class="<?php echo e($each->is_contractor ? 'contractorCrew' : ''); ?>">
                                <td><?php echo e($i); ?></td>
                                <td>
                                    <a href="<?php echo e(route("homepage")."#".url("crew/profile?id={$each->id}")); ?>" target="_blank">
                                        <img src="<?php echo e($picture); ?>" class="img-thumbnail thumb_report_prev"/>
                                    </a>
                                </td>
                                <td><a href="<?php echo e(route("homepage")."#".url("crew/profile?id={$each->id}")); ?>" target="_blank"><?php echo e($each->first_name); ?></a></td>
                                <td><a href="<?php echo e(route("homepage")."#".url("crew/profile?id={$each->id}")); ?>" target="_blank"><?php echo e($each->last_name); ?></a></td>
                                <td><?php echo e($each->location ? $each->location->airport->iata : ''); ?></td>
                                <td><?php echo e($designation); ?></td>
                                <td> <?php echo e($counter); ?></td>
                                <td> <?php echo e($hoursTotal); ?></td>
                                <?php if(\request("dateSearch") && \request("dateSearch") == 'monthYear'): ?>
                                    <?php $__currentLoopData = $monthArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m => $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $last['last28days'] = isset($crewStandbyMonthlyHours[$id][$month]) ? round($crewStandbyMonthlyHours[$id][$month], 2) : 0; ?>
                                        <?php $class = Get_Limitation_Class($last); ?>
                                        <?php if(isset($crewStandbyMonthlyHours[$id][$month])): ?>
                                            <td class="<?php echo e($class['last28days']); ?>"><?php echo e(round($crewStandbyMonthlyHours[$id][$month], 2)); ?></td>
                                        <?php else: ?>
                                            <td>0</td>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <?php $from = '' ?>
                                <?php $to = '' ?>
                                <?php $reason = '' ?>

                                <?php $__empty_1 = true; $__currentLoopData = $each->userHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if(!(strtotime($history->condition_to) < strtotime($dateFrom) || strtotime($history->condition_from) > strtotime($dateTo))): ?>
                                        <?php $from .= $history->condition_from.'<br/>' ?>
                                        <?php $to .= $history->condition_to.'<br/>' ?>
                                        <?php $reason .= ($history->condition_id ? $conditions[$history->condition_id] : '-').'<br/>' ?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>

                                <td><?php echo $from; ?></td>
                                <td><?php echo $to; ?></td>
                                <td><?php echo $reason; ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/crew/report-standby-tab.blade.php ENDPATH**/ ?>