<?php $selectedAirline = isset($selectedAirline) ? $selectedAirline : \request("airline") ?>
<?php $selectedAirport = isset($selectedAirport) ? $selectedAirport : \request("airport") ?>

<?php echo Form::open(['class' => 'form-inline', 'method' => 'GET', 'url' => url("flight-tracker"),  'id' => 'formSearch' ]); ?>


    <div class="col-lg-12">
        <?php if(env(MULTIPLE_AIRLINE)): ?>
            <div class="form-group marginBottomRight">
                <label><?php echo app('translator')->get("content.airline"); ?></label>

                <div class="btn-group">
                    <?php echo Form::select('airline[]', $airlines, $selectedAirline, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']); ?>

                </div>
            </div>
        <?php endif; ?>

        <div class="form-group marginBottomRight">
            <label><?php echo app('translator')->get("content.airport"); ?></label>

            <div class="btn-group">
                <?php echo Form::select('airport[]', $airports, $selectedAirport, ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']); ?>

            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label><?php echo app('translator')->get("content.flight_number"); ?></label>

            <div class="btn-group">
                <?php if(is_array($flightNumbers)): ?>
                    <?php echo Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']); ?>

                <?php else: ?>
                    <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                        <?php $__currentLoopData = $flightNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($each->id); ?>" <?php echo \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : ""; ?> data-airline_id ="<?php echo e($each->airline_id); ?>"><?php echo e($each->sector); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-group marginLeftRightBottom">
            <label><?php echo app('translator')->get("content.from"); ?></label>
                <?php echo Form::text('dateFrom', $dateFrom, ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']); ?>

            <label><?php echo app('translator')->get("content.to"); ?></label>
                <?php echo Form::text('dateTo', $dateTo, ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']); ?>

        </div>


        <div class="form-group marginBottomRight">
            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("content.submit"); ?></button>
        </div>
    </div>

<?php echo Form::close(); ?>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-tracker/form.blade.php ENDPATH**/ ?>