<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">
    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            <div class="col-lg-7 col-lg-offset-1">

                <?php echo Form::open(['method' => 'POST', 'class' => "form-horizontal", 'url' => url("staff"), "autocomplete" => "off"]); ?>


                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red"><?php echo app('translator')->get("content.first_name"); ?>*</label>
                        <div class="col-sm-9">
                            <?php echo Form::text('first_name', null, ['class' => 'form-control', 'placeholder' => trans("content.first_name"), 'id' => 'first_name', "required" => "required"]); ?>

                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red"><?php echo app('translator')->get("content.last_name"); ?>*</label>
                        <div class="col-sm-9">
                            <?php echo Form::text('last_name', null, ['class' => 'form-control', 'placeholder' => trans("content.last_name"), 'id' => 'last_name', "required" => "required"]); ?>

                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red"><?php echo app('translator')->get("content.email"); ?>*</label>
                        <div class="col-sm-9">
                            <?php echo Form::text('email', null, ['class' => 'form-control', 'placeholder' => trans("content.email"), 'id' => 'email', "required" => "required"]); ?>

                            <span class="glyphicon glyphicon glyphicon-ok form-control-feedback"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-3 color-red"><?php echo app('translator')->get("content.location"); ?>*</label>
                        <div class="col-sm-9">
                            <?php echo Form::select('location', $locations, null, ['class' => 'form-control', 'id' => 'location']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label color-red"><?php echo app('translator')->get("content.department"); ?>*</label>
                        <div class="col-sm-9">
                            <?php echo Form::select('department_id', $departments, null, ['class' => 'form-control', 'id' => 'department_id']); ?>

                        </div>
                    </div>
                    <div class="form-group" id="subdepartment" style="display: none;">
                        <label class="col-sm-3 control-label"><?php echo app('translator')->get("content.subdepartment"); ?></label>
                        <div class="col-sm-9">
                            <?php echo Form::select('subdepartment_id', [], null, ['class' => 'form-control', 'id' => 'subdepartment_id']); ?>

                        </div>
                    </div>

                    <div class="form-group" id="position" style="display: none;">
                        <label class="col-sm-3 control-label color-red"><?php echo app('translator')->get("content.position"); ?></label>
                        <div class="col-sm-9">
                            <?php echo Form::select('position_id', [], null, ['class' => 'form-control', 'id' => 'position_id']); ?>

                        </div>
                    </div>

                    <div class="form-group" id="other_position" style="display: none;">
                        <label class="col-sm-3 control-label color-red"><?php echo app('translator')->get("content.other_position"); ?></label>
                        <div class="col-sm-9">
                            <?php echo Form::text('other_position', null, ['class' => 'form-control', 'id' => 'other_position_id']); ?>

                        </div>
                    </div>

                    <?php if(env(CARRIER) == AIRLINE): ?>
                    <div class="form-group">
                        <label class="control-label col-sm-3"><?php echo app('translator')->get("content.crew"); ?></label>
                        <div class="col-sm-9">
                            <label class="radio-inline">
                                <?php echo Form::radio('crew', 0, true, ['id' => 'no_crew']); ?> <?php echo app('translator')->get("content.off"); ?>
                            </label>
                            <label class="radio-inline"><?php echo Form::radio('crew', CCM_CREW, null, ['id' => 'ccm']); ?> <?php echo app('translator')->get("content.cabin_crew"); ?></label>
                            <label class="radio-inline"><?php echo Form::radio('crew', FCM_CREW, null, ['id' => 'fcm']); ?> <?php echo app('translator')->get("content.flight_crew"); ?></label>
                        </div>
                    </div>
                    <?php endif; ?>

                    <div class="form-group">
                        <label class="control-label col-sm-3 color-red"><?php echo app('translator')->get("content.password"); ?>*</label>
                        <div class="col-sm-9">
                            <?php echo Form::password('password', ['class' => 'form-control', 'placeholder' => trans("content.password"), 'id' => 'password', "required" => "required"]); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-3 color-red"><?php echo app('translator')->get("content.confirm_password"); ?>*</label>
                        <div class="col-sm-9">
                            <?php echo Form::password('password_confirmation', ['class' => 'form-control', 'placeholder' => trans("content.confirm_password"), 'id' => 'password_confirmation', "required" => "required"]); ?>

                        </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3"><?php echo app('translator')->get("content.date_of_birth"); ?></label>
                        <div class="col-sm-9">
                            <?php echo Form::text('dob', null, ['class' => 'form-control date', 'placeholder' => 'YYYY-MM-DD', 'id' => 'dob']); ?>

                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-sm-3"><?php echo app('translator')->get("content.contractor"); ?></label>
                        <div class="col-sm-9">
                            <label class="checkbox-inline">
                                <?php echo Form::checkbox('is_contractor', 1, null, ['id' => 'is_contractor']); ?> <?php echo app('translator')->get("content.yes_no"); ?>
                            </label>
                       </div>
                    </div>
                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3 color-red"><?php echo app('translator')->get("content.company"); ?></label>
                        <div class="col-sm-9">
                            <?php echo Form::text('company', null, ['class' => 'form-control', 'placeholder' => trans("content.company"), 'id' => 'company']); ?>

                        </div>
                    </div>

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3"><?php echo app('translator')->get("content.id_card_no"); ?></label>
                        <div class="col-sm-9">
                            <?php echo Form::text('idcard_number', null, ['class' => 'form-control', 'placeholder' => trans("content.id_card_no"), 'id' => 'idcard_number']); ?>

                        </div>
                    </div>

                    <div class="form-group has-feedback">
                        <label class="control-label col-sm-3"><?php echo app('translator')->get("content.id_card_expiry"); ?></label>
                        <div class="col-sm-9">
                            <?php echo Form::text('idcard_expiry', null, ['class' => 'form-control  input-sm date', 'placeholder' => trans("content.id_card_expiry"), 'id' => 'idcard_expiry']); ?>

                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-sm-offset-3 col-sm-9">
                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("content.add"); ?></button>
                            <a href="<?php echo route("homepage")."#". url("staff"); ?>" class="btn btn-default"><?php echo app('translator')->get("content.back"); ?></a>
                        </div>
                    </div>

                <?php echo Form::close(); ?>


            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("<?php echo e(asset("/assets/js/views/user/add-user.js?4")); ?>", pagefunction);

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/staff/create.blade.php ENDPATH**/ ?>