<?php echo Form::open(['method' => 'GET', 'class' => 'form-inline', 'id' => 'formSearch']); ?>

    <div class="form-group marginBottomRight">
        <?php echo Form::label('name', trans("content.first_name"), ['class' => 'control-label']); ?>

        <?php echo Form::input('text', 'first_name', \request("first_name"), ['class' => 'form-control']); ?>

    </div>

    <div class="form-group marginBottomRight">
        <?php echo Form::label('name', trans("content.last_name"), ['class' => 'control-label']); ?>

        <?php echo Form::input('text', 'last_name', \request("last_name"), ['class' => 'form-control']); ?>

    </div>

    <div class="form-group marginBottomRight">
        <?php echo Form::label('department', trans("content.department"), ['class' => 'control-label']); ?>

        <?php echo Form::select('department', $departments, \request("department"), ['class' => 'form-control']); ?>

    </div>

    <?php if(in_array(\Auth::user()->user_role_id, [ROLE_ADMIN, ROLE_SUPER_ADMIN])): ?>
        <div class="form-group marginBottomRight">
            <?php echo Form::label('privilege', trans("content.privilege"), ['class' => 'control-label']); ?>

            <?php echo Form::select('privilege', ['' => "All"] + $roles, \request("privilege"), ['class' => 'form-control']); ?>

        </div>
    <?php endif; ?>

    <div class="form-group">
        <?php echo Form::submit(trans("content.search"), ['name' => 'search', 'class' => 'btn btn-primary']); ?>

    </div>

<?php echo Form::close(); ?>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/admin/form-search-users.blade.php ENDPATH**/ ?>