<?php $currentAirlineId = isset($currentAirlineId) ? $currentAirlineId : '' ?>
<?php $emailGroups = getEmailNotificationGroup() ?>

<div class="col-md-12 no-padding margin-bottom-10">
    <a target="_blank" href="<?php echo e(route("homepage")."#". url("delay-code/create?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}")); ?>" class="btn btn-primary"><?php echo app('translator')->get("content.add_new_delay"); ?></a>
</div>

<div class="col-md-12 form-inline" style="margin: 10px 0 20px 0">
    <label class="control-label" style="margin-right: 20px">
        <?php echo Form::checkbox("select_all", "1", false, ['class' => 'form-control select-all']); ?>

        <?php echo app('translator')->get("content.select_all"); ?>
    </label>

    <p class="inline"><?php echo app('translator')->get("content.notification_group"); ?></p>
    <label class="select">
        <?php echo Form::select('email_notification', $emailGroups, null, ['class' => 'input-sm', "id" => "email_group_id"]); ?>

        <i></i>
    </label>

    <button type="button" class="btn btn-warning confirmation-modal-action-btn" data-action="delete-selected"
            data-url="<?php echo e(url("delay-code/apply-changes")); ?>"
            data-toggle="modal" data-target="#confirmation-modal"><?php echo app('translator')->get("content.apply"); ?></button>
</div>


<div class="clearfix"></div>

<?php $id = isset($id) ? $id : "delays" ?>

<?php if(count($delays)): ?>
    <div class="jarviswidget jarviswidget-color-blueDark" id="<?php echo e($id); ?>-container" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2><?php echo app('translator')->get("content.list"); ?></h2>
    </header>

    <!-- widget div-->
    <div class="editable_div">

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="<?php echo e($id); ?>" style="min-width: 100% !important;">
                    <thead>
                    <tr>
                        <th rowspan="2">SEL</th>
                        <th rowspan="2">No</th>
                        <th rowspan="2"><?php echo app('translator')->get("content.group"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.group"); ?>(<?php echo app('translator')->get("content.local"); ?>)</th>
                        <th rowspan="2"><?php echo app('translator')->get("content.airline"); ?></th>
                        <th colspan="2" style="min-width: 180px;"><?php echo app('translator')->get("content.code"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.email"); ?><br/><?php echo app('translator')->get("content.notification_group"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.description"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.description"); ?>(<?php echo app('translator')->get("content.local"); ?>)</th>
                        <th rowspan="2"><?php echo app('translator')->get("content.explanation"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.explanation"); ?>(<?php echo app('translator')->get("content.local"); ?>)</th>
                        <th rowspan="2" style="min-width: 140px;"><?php echo app('translator')->get("content.actions"); ?></th>
                    </tr>
                    <tr>
                        <th><?php echo app('translator')->get("content.numeric_alpha"); ?></th>
                        <th><?php echo app('translator')->get("content.alpha"); ?></th>
                    </tr>

                    </thead>
                    <tbody>

                    <?php $__currentLoopData = $delays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($each->deleted_at): ?>
                            <?php continue; ?>
                        <?php endif; ?>
                        <tr>
                            <td>
                                <?php echo Form::checkbox("selected", "1", false, ['class' => 'form-control flight', "data-id" => $each->id ]); ?>

                            </td>
                            <td data-center><?php echo e($i + 1); ?></td>
                            <td><?php echo e($each->group ? $each->group->name : "-"); ?></td>
                            <td><?php echo e($each->group ? $each->group->name_ln : "-"); ?></td>
                            <td><?php echo e($each->airline ? $each->airline->iata : "-"); ?></td>
                            <td class="text-center"><strong><?php echo e($each->code); ?></strong></td>
                            <td class="text-center"><strong><?php echo e($each->alpha_code); ?></strong></td>
                            <td>
                                <a href="#" data-field='email_notification_id' data-model="Delay" data-type="select" data-id='<?php echo e($each->id); ?>'
                                   data-placeholder="Required" data-value='<?php echo e($each->email_notification_id); ?>' class="editable <?php echo e($each->email_notification_id ? 'editable-click' : 'editable-empty'); ?>">
                                    <?php echo e($each->emailNotification ? $each->emailNotification->name : 'Empty'); ?></a>
                            </td>
                            <td>
                                <a href="#" data-field='description' data-model="Delay" data-type="textarea" data-id='<?php echo e($each->id); ?>'
                                   data-placeholder="Required"
                                   class="editable <?php echo e($each->description ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->description ? $each->description : 'Empty'); ?></a>
                            </td>
                            <td>
                                <a href="#" data-field='description_ln' data-model="Delay" data-type="textarea" data-id='<?php echo e($each->id); ?>'
                                   data-placeholder="Required"
                                   class="editable <?php echo e($each->description_ln ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->description_ln ? $each->description_ln : 'Empty'); ?></a>
                            </td>
                            <td>
                                <a href="#" data-field='explanation' data-model="Delay" data-type="textarea" data-id='<?php echo e($each->id); ?>'
                                   data-placeholder="Required"
                                   class="editable <?php echo e($each->explanation ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->explanation ? $each->explanation : 'Empty'); ?></a>
                            </td>
                            <td>
                                <a href="#" data-field='explanation_ln' data-model="Delay" data-type="textarea" data-id='<?php echo e($each->id); ?>'
                                   data-placeholder="Required"
                                   class="editable <?php echo e($each->explanation_ln ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($each->explanation_ln ? $each->explanation_ln : 'Empty'); ?></a>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a target="_blank" href="<?php echo e(route("homepage")."#". url("delay-code/{$each->id}/edit?current_airline_id={$currentAirlineId}")); ?>" class="btn btn-warning"><?php echo app('translator')->get("content.edit"); ?></a>
                                    <a href="<?php echo e(route("homepage")."#". url("delay-code/{$each->id}/delete?current_airline_id={$currentAirlineId}")); ?>" class="btn btn-danger"><?php echo app('translator')->get("content.delete"); ?></a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>

                </table>

            </div>

        </div>

    </div>

    </div>

    <div class="clearfix"></div>

    <?php echo $__env->make("delay-code.layouts.confirmation", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php endif; ?>

<script type="text/javascript">
    $(document).ready(function () {
       $("body").removeClass("modal-open")
                .attr("style", "margin-bottom: 30px;");
    });

    var confirmation_modal = $(document).find("#confirmation-modal"),
        tabContent = $(document).find("#tabContent"),
        confirmation_text = confirmation_modal.find(".confirmation-text"),
        ids = confirmation_modal.find("#ids"),
        group_id = confirmation_modal.find("#group_id")
    ;

    $(document).on("click", ".select-all:checkbox", function () {

        var selectAll = $(this).is(":checked"),
            checkboxes = $(document).find(".flight:checkbox");

        $.each(checkboxes, function () {
            if (selectAll){
                $(this).prop("checked", true);
            }
            else {
                $(this).prop("checked", false);
            }
        });
    });

    $(document).on("click", ".confirmation-modal-action-btn", function () {
        var id = $(this).data('id'),
            url = $(this).data('url'),
            action = $(this).data('action'),
            selected_checkboxes = $(document).find(".flight:checkbox:checked"),
            email_group_id = $("#email_group_id"),
            items = "";

        console.log(email_group_id.val());
        group_id.val(email_group_id.val());

        $("#confirmation-form").attr("action", url);

        switch (action) {
            default:
            case "delete-selected":
                // confirmation_text.text("Are you sure you want to delete selected schedules?");
                $.each(selected_checkboxes, function () {
                    items += $(this).data("id").toString() + ","
                });
                ids.val(items);

                console.log(items)
                break;
        }
    });

    $('#modal-form').submit(function() {
        // Coding
        $('#custom-delete-modal').modal('toggle');
        return false;
    });
</script><?php /**PATH /home/avbis/public_html/coastal/resources/views/delay-code/layouts/index-list-tab.blade.php ENDPATH**/ ?>