<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

            <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            <?php echo $__env->make("flight-view.layouts.form", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make("flight-view.layouts.confirmation", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </article>

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding">

                <ul id="tabFlights" class="nav nav-tabs bordered">

                    <li class="<?php echo e(!$tab || ($tab == ALL) ? "active" : ""); ?>">
                        <a href="#all" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.live"); ?></a>
                    </li>

                    <li class="<?php echo e($tab == CANCELLED ? "active" : ""); ?>">
                        <a href="#cancelled" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.cancelled"); ?></a>
                    </li>

                    <li class="<?php echo e($tab == REMOVED ? "active" : ""); ?>">
                        <a href="#removed" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.removed"); ?></a>
                    </li>

                    <li class="<?php echo e($tab == MANUALLY_CREATED ? "active" : ""); ?>">
                        <a href="#manually_created" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.manually_created"); ?></a>
                    </li>

                    <li class="<?php echo e($tab == AUTO_CREATED ? "active" : ""); ?>">
                        <a href="#auto_created" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.auto_created"); ?></a>
                    </li>
                </ul>

                <div id="tabContent" class="tab-content padding-10 background-white" style="min-height: 500px;">

                    <div class="tab-pane <?php echo e(!$tab || ($tab == ALL) ? "active" : ""); ?>" id="all" style="min-height: 300px;">

                        <?php echo $__env->make("flight-view.layouts.flights-list", [ "flights" => (isset($flights[ALL]) && $flights[ALL] ? $flights[ALL] : []), "type" => ALL], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e($tab == CANCELLED ? "active" : ""); ?>" id="cancelled" style="min-height: 300px;">

                        <?php echo $__env->make("flight-view.layouts.flights-list", [ "flights" => (isset($flights[CANCELLED]) && $flights[CANCELLED] ? $flights[CANCELLED] : []), "type" => CANCELLED], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e($tab == REMOVED ? "active" : ""); ?>" id="removed" style="min-height: 300px;">

                        <?php echo $__env->make("flight-view.layouts.flights-list", [ "flights" => (isset($flights[REMOVED]) && $flights[REMOVED] ? $flights[REMOVED] : []), "type" => REMOVED], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e($tab == MANUALLY_CREATED ? "active" : ""); ?>" id="manually_created" style="min-height: 300px;">

                        <?php echo $__env->make("flight-view.layouts.flights-list", [ "flights" => (isset($flights[MANUALLY_CREATED]) && $flights[MANUALLY_CREATED] ? $flights[MANUALLY_CREATED] : []), "type" => MANUALLY_CREATED], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e($tab == AUTO_CREATED ? "active" : ""); ?>" id="auto_created" style="min-height: 300px;">

                        <?php echo $__env->make("flight-view.layouts.flights-list", [ "flights" => (isset($flights[AUTO_CREATED]) && $flights[AUTO_CREATED] ? $flights[AUTO_CREATED] : []), "type" => AUTO_CREATED], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                </div>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    $(function() {
        pageSetUp();
        var pagefunction = function () {
            ApplyFormSubmit();
            ApplyValidationDateFormats();
            Apply_Multiselect();
            ApplyTableFilter(".table");
//        ApplyTableFilter("#ALL_flights");
//        ApplyTableFilter("#Cancelled_flights");
//        ApplyTableFilter("#Removed_flights");
//        ApplyTableFilter("#Auto_Created_flights");
//        ApplyTableFilter("#Manually_Created_flights");

            $('#confirmation-form').submit(function() {
                // Coding
                $('#confirmation-modal').modal('toggle');
                return false;
            });

            var confirmation_modal = $(document).find("#confirmation-modal"),
                tabContent = $(document).find("#tabContent"),
                confirmation_text = confirmation_modal.find(".confirmation-text"),
                flight_ids = confirmation_modal.find("#flight_ids");

            $(document).on("click", ".select-all:checkbox", function () {

                var selectAll = $(this).is(":checked"),
                    active_tab = tabContent.find(".tab-pane.active"),
                    checkboxes = active_tab.find(".flight:checkbox");

                $.each(checkboxes, function () {
                    if (selectAll){
                        $(this).prop("checked", true);
                    }
                    else {
                        $(this).prop("checked", false);
                    }
                });
            });

            $(document).on("click", ".confirmation-modal-action-btn", function () {
                var url = $(this).data('url'),
                    confirmation_form = $("#confirmation-form"),
                    action = $(this).data('action'),
                    flightID = $(this).data('flight_id'),
                    active_tab = tabContent.find(".tab-pane.active"),
                    selected_checkboxes = active_tab.find(".flight:checkbox:checked"),
                    fltIDs = "";

                console.log(action)
                console.log(flightID)
                switch (action) {
                    case "cancel-selected":
                        confirmation_text.text("Are you sure you want to cancel selected flights?");

                        if (!url){
                            url = baseUrl + "/flight-view/cancel-selected";
                        }
                        if (flightID){
                            flight_ids.val(flightID);
                        }
                        else if (active_tab.length){

                            $.each(selected_checkboxes, function () {
                                fltIDs += $(this).data("flight_id") + ",";
                            });

                            if (fltIDs){
                                flight_ids.val(fltIDs);
                            }
                        }
                        break;

                    case "delete-selected":
                        confirmation_text.text("Are you sure you want to remove selected flights?");

                        if (!url){
                            url = baseUrl + "/flight-view/delete-selected";
                        }
                        if (flightID){
                            flight_ids.val(flightID);
                        }
                        else if (active_tab.length){

                            $.each(selected_checkboxes, function () {
                                fltIDs += $(this).data("flight_id") + ",";
                            });

                            if (fltIDs){
                                flight_ids.val(fltIDs);
                            }
                        }
                        break;

                    case "restore-selected":
                        confirmation_text.text("Are you sure you want to restore selected flights?");

                        if (!url){
                            url = baseUrl + "/flight-view/restore-selected";
                        }
                        if (flightID){
                            flight_ids.val(flightID);
                        }
                        else if (active_tab.length){

                            $.each(selected_checkboxes, function () {
                                fltIDs += $(this).data("flight_id") + ",";
                            });

                            if (fltIDs){
                                flight_ids.val(fltIDs);
                            }
                        }
                        break;
                }

                confirmation_form.attr("action", url);
            });

            $('#modal-form').submit(function() {
                // Coding
                $('#custom-delete-modal').modal('toggle');
                return false;
            });
        };
        pagefunction();
    });

    

</script><?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-view/index.blade.php ENDPATH**/ ?>