<?php if(count($maintenance)): ?>
    <table class="table table-bordered table-striped table-hover">
        <thead>
        <tr>
            <th>No</th>
            <th><?php echo app('translator')->get("content.ac_reg"); ?></th>
            <th><?php echo app('translator')->get("content.notes"); ?></th>
            <th><?php echo app('translator')->get("content.location"); ?></th>
            <th><?php echo app('translator')->get("content.start_date"); ?></th>
            <th><?php echo app('translator')->get("content.end_date"); ?></th>

            <?php if(checkAuthorization(ADMIN)): ?>
                <th><?php echo app('translator')->get("content.updated_by"); ?></th>
                <th><?php echo app('translator')->get("content.last_updated"); ?></th>
            <?php endif; ?>

            <th><?php echo app('translator')->get("content.actions"); ?></th>
        </tr>
        </thead>

        <tbody>
        <?php $__currentLoopData = $maintenance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $user = App\Models\User::find($item->user_id) ?>
            <tr class="records">
                <td><?php echo e($i + 1); ?></td>
                <td><?php echo e(getAircraft($item->aircraft)); ?></td>
                <td class="editable" data-item="note" data-model = 'Maintenance' data-var_type = 'varchar'><?php echo e($item->note); ?></td>
                <td class="editable" data-item="location_code" data-model = 'Maintenance' data-var_type = 'varchar'><?php echo e($item->location_code); ?></td>
                <td class="editable" data-item="arrival_time" data-model = 'Maintenance' data-date_format = 'd M Y H:i'><?php echo e(date('d M Y H:i', strtotime($item->arrival_time))); ?></td>
                <td class="editable" data-item="departure_time" data-model = 'Maintenance' data-date_format = 'd M Y H:i'><?php echo e(date('d M Y H:i', strtotime($item->departure_time))); ?></td>

                <?php if(checkAuthorization(ADMIN)): ?>
                    <td><?php echo e($user ? $user->first_name.' '.$user->last_name : ''); ?></td>
                    <td><?php echo e(date('M d, Y H:i', strtotime($item->updated_at))); ?></td>
                <?php endif; ?>

                <td>
                    <a class="btn btn-warning" target="_blank" href="<?php echo e(route("homepage")."#".url("aircraft/maintenance/{$item->aircraft_id}")); ?>"><?php echo app('translator')->get("content.view"); ?></a>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php else: ?>
    <p class="alert alert-info"><?php echo app('translator')->get("content.found"); ?> 0 <?php echo app('translator')->get("content.records"); ?></p>
<?php endif; ?><?php /**PATH /home/avbis/public_html/coastal/resources/views/aircraft/layouts/maintenance-list.blade.php ENDPATH**/ ?>