<div class="message_box"></div>
<?php echo Form::open(['method' => 'POST', 'class' => 'form-inline']); ?>


<table class="table table-bordered table-striped table-hover editable_table" data-Agency_id="<?php echo e($user->id); ?>"
       style="width:100%; padding: 0; margin: 0">
    <thead>

    </thead>
    <tbody>
    <tr>
        <td class="header_profile color-red"><?php echo app('translator')->get("content.tax_code"); ?></td>
        <td>
            <a href="#" data-field='tax_code' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" class="editable <?php echo e($user->tax_code ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->tax_code ? $user->tax_code : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.passport_no"); ?></td>
        <td>
            <a href="#" data-field='passport_num' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" class="editable <?php echo e($user->passport_num ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->passport_num ? $user->passport_num : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.passport_doi"); ?></td>
        <td>
            <a href="#" data-field='passport_doi' data-model="User" data-type="date" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-format='d-M-Y' data-js_format='DD-MMM-YYYY' data-value='<?php echo e($user->passport_doi); ?>'
               class="editable <?php echo e($user->passport_doi ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->passport_doi  ?  date('d-M-Y', strtotime($user->passport_doi))  : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.passport_dex"); ?></td>
        <td>
            <a href="#" data-field='passport_dex' data-model="User" data-type="date" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-format='d-M-Y'
               data-js_format='DD-MMM-YYYY' data-value='<?php echo e($user->passport_dex); ?>'
               class="editable <?php echo e($user->passport_dex ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->passport_dex  ?  date('d-M-Y', strtotime($user->passport_dex))  : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.staff_no"); ?></td>
        <td>
            <a href="#" data-field='staff_number' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->staff_number ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->staff_number ? $user->staff_number : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.id_card_no"); ?></td>
        <td>
            <a href="#" data-field='idcard_number' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->idcard_number ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->idcard_number ? $user->idcard_number : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.cost_center"); ?></td>
        <td>
            <a href="#" data-field='cost_center' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->cost_center ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->cost_center ? $user->cost_center : 'Empty'); ?></a>
        </td>
    </tr>


    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.nationality"); ?></td>
        <td>
            <a href="#" data-field='nationality_id' data-model="User" data-type="select" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-value='<?php echo e($user->nationality_id); ?>' class="editable <?php echo e($user->nationality_id ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->nationality ? $user->nationality->nationality : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.place_of_birth"); ?></td>
        <td>
            <a href="#" data-field='pob_country_id' data-model="User" data-type="select" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-value='<?php echo e($user->pob_country_id); ?>' class="editable <?php echo e($user->pob_country_id ? 'editable-click' : 'editable-empty'); ?>">
               <?php echo e($user->pob ? $user->pob->country : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.address"); ?></td>
        <td>
            <a href="#" data-field='address' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->address ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->address ? $user->address : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.city"); ?></td>
        <td>
            <a href="#" data-field='address_city_id' data-model="User" data-type="select" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-value='<?php echo e($user->address_city_id); ?>' class="editable <?php echo e($user->address_city_id ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->addressCity ? $user->addressCity->city : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile color-red"><?php echo app('translator')->get("content.date_of_termination"); ?></td>
        <td>
            <a href="#" data-field='resigned_date' data-model="User" data-type="date" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-format='d-M-Y'
               data-js_format='DD-MMM-YYYY' data-value='<?php echo e($user->resigned_date); ?>'
               class="editable <?php echo e($user->resigned_date ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->resigned_date  ?  date('d-M-Y', strtotime($user->resigned_date))  : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile color-red"><?php echo app('translator')->get("content.reason_of_termination"); ?></td>
        <td>
            <a href="#" data-field='termination_reason' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->termination_reason ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->termination_reason ? $user->termination_reason : 'Empty'); ?></a>
        </td>
    </tr>

    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.min_hours"); ?></td>
        <td>
            <a href="#" data-field='min_hours' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->min_hours ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->min_hours ? $user->min_hours : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.max_hours"); ?></td>
        <td>
            <a href="#" data-field='max_hours' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->max_hours ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->max_hours ? $user->max_hours : 'Empty'); ?></a>
        </td>
    </tr>


    <tr>
        <td class="header_profile">Preferred Days Off</td>
        <td>
            <a href="#" data-field='roster_off_days' data-model="User" data-type="multiselect" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-value='<?php echo $user->roster_off_days ? json_encode(explode(";", $user->roster_off_days)) : null; ?>'
               class="editable <?php echo e($user->roster_off_days ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->roster_off_days ? weekDaysSelected($user->roster_off_days) : 'Empty'); ?></a>
        </td>
    </tr>
    </tbody>
</table>

<table class="table table-bordered table-striped table-hover editable_table margin-top-10" data-Agency_id="<?php echo e($user->id); ?>"
       style="width:100%; padding: 0; margin: 0">
    <tr>
        <td class="header_profile" colspan="3">Not available for work</td>
    </tr>
    <tr>
        <th>Day</th>
        <th>From</th>
        <th>To</th>
    </tr>
    <?php $preferredOff = getPreferredDaysOff($user->id) ?>
    <?php $__currentLoopData = weekDaysArray(true, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $error = checkFromTo($preferredOff->{"{$i}_from"}, $preferredOff->{"{$i}_to"}) ?>
        <?php $recordExists = $preferredOff->{"{$i}_from"} && $preferredOff->{"{$i}_to"} ?>
        <tr class="<?php echo e($error ? 'bg-danger' : ($recordExists ? "bg-success" : "")); ?>">
            <td class="header_profile">
                <?php echo e($day); ?>

                <?php if($error): ?>
                    <div class="label label-danger"><?php echo app('translator')->get("content.error"); ?></div>
                <?php endif; ?>
            </td>
            <td>
                <a href="#" data-field='<?php echo e("{$i}_from"); ?>' data-field_value="<?php echo e($preferredOff->{"{$i}_from"}); ?>" data-model="UserPreferredOff"
                   data-type="time" data-id='<?php echo e($preferredOff->id); ?>' data-placeholder="Required" data-format='H:i'
                   data-js_format = 'HH-mm'
                   class="editable <?php echo e($preferredOff->{"{$i}_from"} ? 'editable-click' : 'editable-empty'); ?>">
                    <?php echo e($preferredOff->{"{$i}_from"} ? date("H:i", strtotime($preferredOff->{"{$i}_from"})) : 'Empty'); ?></a>
            </td>
            <td>
                <a href="#" data-field='<?php echo e("{$i}_to"); ?>' data-field_value="<?php echo e($preferredOff->{"{$i}_to"}); ?>" data-model="UserPreferredOff"
                   data-type="time" data-id='<?php echo e($preferredOff->id); ?>' data-placeholder="Required" data-format='H:i'
                   data-js_format = 'HH-mm'
                   class="editable <?php echo e($preferredOff->{"{$i}_to"} ? 'editable-click' : 'editable-empty'); ?>">
                    <?php echo e($preferredOff->{"{$i}_to"} ? date("H:i", strtotime($preferredOff->{"{$i}_to"})) : 'Empty'); ?></a>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<?php echo Form::close(); ?>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/staff/layouts/general-details-tab.blade.php ENDPATH**/ ?>