<?php if(count($list)): ?>

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2><?php echo app('translator')->get("content.list"); ?></h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="flight-schedule-table" style="min-width: 100% !important;">
                    <thead>
                    <tr>
                        <th rowspan="2">No</th>
                        <th rowspan="2"><?php echo app('translator')->get("content.template"); ?></th>
                        <?php if(env(CARRIER) == HANDLING): ?>
                            <th rowspan="2" style="max-width: 20%;"><?php echo app('translator')->get("content.airlines"); ?></th>
                        <?php endif; ?>
                        <th colspan="2"><?php echo app('translator')->get("content.period"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.created"); ?></th>
                        <th colspan="2"><?php echo app('translator')->get("content.last_updated"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.status"); ?></th>
                        <th rowspan="2"><?php echo app('translator')->get("content.actions"); ?></th>
                    </tr>

                    <tr>
                        <th style="min-width: 60px"><?php echo app('translator')->get("content.from"); ?></th>
                        <th style="min-width: 60px"><?php echo app('translator')->get("content.to"); ?></th>

                        <th><?php echo app('translator')->get("content.user"); ?></th>
                        <th><?php echo app('translator')->get("content.date"); ?></th>
                    </tr>

                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td><?php echo e($i + 1); ?></td>
                            <td>
                                <a href="<?php echo e(route("homepage")."#".url("handling-flight-schedule-airlines/{$each->id}")); ?>"><?php echo e($each->name); ?></a>
                            </td>

                            <?php if(env(CARRIER) == HANDLING): ?>
                            <td>
                                <?php $__currentLoopData = $each->airlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $airline): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($airline->airline): ?>
                                        <?php $picture = $airline->airline->picture ? asset("storage/airlines/img/{$airline->airline->picture}") : asset("/assets/img/default-airline-picture.png") ?>
                                        <a href="<?php echo e(route("homepage")."#".url("handling-flight-schedule-flights/{$each->id}?airline_id={$airline->airline->id}")); ?>">
                                            <img class="flight-schedule-img"
                                                 src="<?php echo e($picture); ?>"/>
                                        </a>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                            <?php endif; ?>

                            <td><?php echo e(baseDateFormat($each->date_from)); ?></td>
                            <td><?php echo e(baseDateFormat($each->date_to)); ?></td>
                            <td><?php echo e(baseDateFormat($each->created_at, true)); ?></td>
                            <td><?php echo e($each->user ? $each->user->first_name." ".$each->user->last_name : "-"); ?></td>
                            <td><?php echo e(baseDateFormat($each->updated_at, true)); ?></td>
                            <td><?php echo $each->deleted_at ? "<span class='label label-danger'>".trans("content.removed")."</span>" : ""; ?> </td>
                            <td>
                                <div class="btn-group">
                                    <a class="btn btn-danger" href="<?php echo e(route("homepage")."#".url("handling-flight-schedule/destroy/{$each->id}")); ?>"><?php echo app('translator')->get("content.delete"); ?></a>
                                    <?php if(Auth::user()->user_role_id == ROLE_SUPER_ADMIN || in_array(Auth::user()->id, [531]) ): ?>
                                        <button data-sch_id="<?php echo e($each->id); ?>" class="btn btn-warning permanent_deletion"><?php echo app('translator')->get("content.permanent_deletion"); ?></button>

                                        <?php echo Form::text('delete_from', null, ['class'=>'form-control dateFrom delete_from', 'placeholder'=>'From']); ?>

                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>

        </div>
        <!-- end widget content -->

    </div>
    <!-- end widget div -->

</div>

<?php endif; ?>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/handling-flight-schedule/schedule-list.blade.php ENDPATH**/ ?>