<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">

                <ul id="tabStations" class="nav nav-tabs bordered">
                    <li class="active">
                        <a href="#airlines" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.aircraft"); ?></a>
                    </li>

                    <li>
                        <a href="#certificates" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.certificates"); ?></a>
                    </li>

                    <li>
                        <a href="#engines" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.engines"); ?></a>
                    </li>
                </ul>

                <div id="tabContent" class="tab-content padding-10 background-white">

                    <div class="tab-pane active" id="airlines">
                        <?php if(isset($aircraftType)): ?>
                            <h1 class="padding-0 margin-top-5">AC Type: <?php echo e(getAircraftType($aircraftType, true)); ?> / <?php echo e(getAircraftType($aircraftType)); ?></h1>
                        <?php endif; ?>

                        <?php echo $__env->make("aircraft.list-aircraft", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane" id="certificates">
                        <?php echo $__env->make("aircraft-certificate.layouts.aircraft-certificate-list", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane" id="engines">
                        <?php echo $__env->make("aircraft-engine.layouts.aircraft-engines-list", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#aircraft-table");
    };

    pagefunction();

</script><?php /**PATH /home/avbis/public_html/coastal/resources/views/aircraft/index.blade.php ENDPATH**/ ?>