<?php
	//initilize the page
	require_once(public_path("smart/inc/init.php"));

	//require UI configuration (nav, ribbon, etc.)
	require_once(public_path("smart/inc/config.ui.php"));

	/*---------------- PHP Custom Scripts ---------

	YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC. */

	include(public_path("smart/inc/user_variables.php"));


	/* ---------------- END PHP Custom Scripts ------------- */

	//include header
	//you can add your custom css in $page_css array.
	//Note: all css files are inside css/ folder
	$page_css[] = "your_style.css";
	include(public_path("smart/inc/header.php"));

	//include left panel (navigation)
	//follow the tree in inc/config.ui.php
	include(public_path("smart/inc/nav.php"));


?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->
<div id="main" role="main">
	<?php
		include(public_path("smart/inc/ribbon.php"));
	?>

	<?php echo $__env->make('template/modal-loading', [ 'text' => 'Please Wait...'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<?php echo $__env->make('layouts/alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<?php echo $__env->make('vendor/flash/message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<!-- MAIN CONTENT -->
	<div id="content">

	</div>
	<!-- END MAIN CONTENT -->
	
</div>
<!-- END MAIN PANEL -->

<!-- FOOTER -->
	<?php
		include(public_path("smart/inc/footer.php"));
	?>
<!-- END FOOTER -->

<!-- ==========================CONTENT ENDS HERE ========================== -->

<script type="text/javascript">
	var baseUrl = "<?php echo e(url('/')); ?>";
	var routeHomePageUrl = "<?php echo e(route("homepage")); ?>";
	var baseDashboardUrl = "<?php echo e(url('home/dashboard')); ?>";
	var baseHomeUrl = "<?php echo e(route("homepage")."#"); ?>";
	var AIRLINE = "<?php echo e(env("AIRLINE")); ?>";
	var CARRIER = "<?php echo e(env("CARRIER")); ?>";
	var CURRENT_IATA_CODE = "<?php echo e(env("IATA_CODE")); ?>";

	var GSRM = "GSRM";
	var FRAAI = "FRAAI";
	var TAJIK_AIR = "TAJIK_AIR";
	var QAZAQ_AIR = "QAZAQ_AIR";
	var AVIAM = "AVIAM";
	var SCO = "SCO";
	var IAG = "IAG";

	var $location1, $location2, $assets;
	if (CURRENT_IATA_CODE == "SZ"){
		$location1 = "DYU";
		$location2 = "LBD";
		$assets = "assets";
	}
	else {
		$location1 = "FRU";
		$location2 = "OSS";
		$assets = "assets";
	}


	var TAJIKAIR = "Tajik Air",
		OTHERAIRLINES = "Other Airlines";

	var FLIGHT_OPERATIONS_DIRECTOR_POSITION = "Captain",
		CAPTAIN_POSITION = "Captain",
		FIRST_OFFICER_POSITION = "First Officer",
		CHIEF_PILOT_POSITION = "Chief Pilot",
		PILOT_INSTRUCTOR_POSITION = "Pilot-instructor",
		COPILOT_JUNIOR_POSITION = "Co-Pilot Junior";

	var FLIGHT_ATTENDANT_POSITION = "Flight Attendant",
			FLIGHT_ATTENDANT_N2_POSITION = "Flight Attendant #2",
			FLIGHT_ATTENDANT_JUNIOR_POSITION = "Flight Attendant Junior",
			PURSER_POSITION = "Purser",
			INSTRUCTOR_FLIGHT_ATTENDANT_POSITION = "Instructor-Flight Attendant",
			SENIOR_INSTRUCTOR_FLIGHT_ATTENDANT_POSITION = "Senior Instructor-Flight Attendant";

	var authUserId = "", authUserName = "", authUserStatus = "";
	<?php if(isset($auth) && is_object($auth) && $auth->user()): ?>
        authUserId = "<?php echo e($auth->user()->id); ?>";
		authUserName = "<?php echo e($auth->user()->first_name." ".$auth->user()->last_name); ?>";
		authUserStatus = "<?php echo e($auth->user()->chatStatus ? $auth->user()->chatStatus->status : STATUS_ONLINE); ?>";
	<?php endif; ?>
</script>

<?php
	//include required scripts
	include(public_path("smart/inc/scripts.php"));
	//include footer
	// 	include(public_path("smart/inc/google-analytics.php"));

	echo "</body>".
	"</html>";
?>


<?php /**PATH /home/avbis/public_html/coastal/resources/views/smart/index.blade.php ENDPATH**/ ?>