<div class="tab-pane tab_holder <?php echo !$reportType && $reportType =='Late_No_Show' ? 'active' : ''; ?>" id="lateNoShow" style="padding: 10px 0;">

    <div class="col-lg-12" style="margin-bottom: 10px">
        <?php echo Form::open(['method' => 'GET',  'url' => url("crew/report?reportType=Late_No_Show"), 'class' => 'form-inline', 'id' => 'formLateNoShow']); ?>


            <?php echo Form::label('crew', trans("content.crew")); ?>

            <?php echo Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']); ?>

            
            <?php echo Form::label('dateFrom', trans("content.from")); ?>

            <?php echo Form::text('dateFrom', \request("dateFrom") ? \request("dateFrom") : date('Y-m-d'), ['class' => 'form-control dateFrom inputDateSmall', 'required' => true]); ?>

            <?php echo Form::label('dateFrom', trans("content.to")); ?>

            <?php echo Form::text('dateTo', \request("dateTo") ? \request("dateTo") : date('Y-m-d'), ['class' => 'form-control dateTo inputDateSmall', 'required' => true]); ?>

            <?php echo Form::label('perPage', trans("content.per_page")); ?>

            <?php echo Form::select('perPage', [10 => 10, 20 => 20, 50 => 50, '' => 'All'], \request("perPage"), ['class' => 'form-control']); ?>

            <?php echo Form::submit('Submit', ['class' => 'btn btn-primary']); ?>


        
        <?php echo Form::close(); ?>

    </div>

    <div class="col-lg-12" id="message-block"></div>
    <?php if($reportType =='Late_No_Show'): ?>
        <div class="col-lg-12 alert alert-dismissible alert-info">
            <button type="button" class="close" data-dismiss="alert">×</button>
            <?php echo app('translator')->get("content.found"); ?> <?php echo count($lateNoShow); ?> <?php echo app('translator')->get("content.crew"); ?>
        </div>
    <?php endif; ?>
    <?php if(count($lateNoShow)): ?>
        <div class="clearfix"></div>
        <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
            <!-- widget options:
            usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

            data-widget-colorbutton="false"
            data-widget-editbutton="false"
            data-widget-togglebutton="false"
            data-widget-deletebutton="false"
            data-widget-fullscreenbutton="false"
            data-widget-custombutton="false"
            data-widget-collapsed="true"
            data-widget-sortable="false"

            -->
            <header>
                <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                <h2><?php echo app('translator')->get("content.list"); ?> </h2>

            </header>

            <!-- widget div-->
            <div style="width: 100%;overflow: auto;">

                <!-- widget edit box -->
                <div class="jarviswidget-editbox">
                    <!-- This area used as dropdown edit box -->

                </div>
                <!-- end widget edit box -->

                <!-- widget content -->
                <div class="widget-body no-padding">
                    
                    <?php $eachId = 0 ?>
                    <table class="table table-bordered table-striped table-hover" style="margin: 0 0 10px 0 ">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th data-sorter="false"><?php echo app('translator')->get("content.crew_information"); ?>Crew Information</th>
                            <th>#</th>
                            <th><?php echo app('translator')->get("content.departure"); ?></th>
                            <th><?php echo app('translator')->get("content.flight_number"); ?></th>
                            <th><?php echo app('translator')->get("content.sector"); ?></th>
                            <th>STD</th>
                            <th><?php echo app('translator')->get("content.report_time"); ?></th>
                            <th><?php echo app('translator')->get("content.actual_report_time"); ?></th>
                            <th><?php echo app('translator')->get("content.difference"); ?></th>
                            <th><?php echo app('translator')->get("content.status"); ?></th>
                            <th><?php echo app('translator')->get("content.reason"); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $currentPage = \request("page") ? \request("page") - 1 : 0 ?>
                        <?php $perPage = \request("perPage") ? \request("perPage") : count($lateNoShow) ?>
                        <?php $k = 0 ?>
                        <?php $__currentLoopData = $lateNoShow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $crew): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($i >= $currentPage * $perPage && $i < $currentPage * $perPage + $perPage): ?>
            
                                <?php if(!isset($exportArray[$i])): ?>
                                    <?php $exportArray[$k] = [] ?>
                                <?php endif; ?>
            
                                <?php $__currentLoopData = $crew; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($each->report_time): ?>
                                        <?php $reportTime = Add_Minutes_To_DateTime($each->std, 75, null, TRUE) ?>
                                        <?php $timeDiff = DateTimeDifference($each->report_time, $reportTime) ?>
                                        <?php $timeDiffStr = $timeDiff['H'].':'.$timeDiff['i'] ?>
                                        <?php $actualReportTime = date('H:i', strtotime($each->report_time)) ?>
                                        <?php $totalMins = $timeDiff['total'] ?>
                                    <?php else: ?>
                                        <?php $timeDiffStr = "&mdash;" ?>
                                        <?php $actualReportTime = "&mdash;" ?>
                                        <?php $totalMins = 0 ?>
                                    <?php endif; ?>
            
                                    <?php if($j == 0): ?>
                                        <?php $picture = $each->thumb ? 'users/'.$each->thumb : 'default-user-picture.png' ?>
            
                                        <tr class="<?php echo $each->is_contractor ? 'contractorCrew' : ''; ?>">
                                            <td class="vertical-center text-center" rowspan="<?php echo count($crew); ?>"><?php echo $i + 1; ?></td>
            
                                            <td rowspan="<?php echo count($crew); ?>">
                                                <div class="col-sm-12">
                                                    <div class="col-xs-3 vertical-center" style="margin: 10px 0">
                                                        <a href="<?php echo route("homepage")."#". url('/'); ?>/crew/profile?id=<?php echo $each->user_id; ?>" target="_blank">
                                                            <img src="<?php echo route("homepage")."#". url('/').'/assets/img/'.$picture; ?>" width="60px" />
                                                        </a>
                                                    </div>
                                                    <div class="col-xs-9">
                                                        <h5><a href="<?php echo route("homepage")."#". url("/"); ?>/crew/profile?id=<?php echo $each->user_id; ?>" target="_blank"><?php echo $each->first_name." ".$each->last_name; ?></a></h5>
            
                                                        <?php if($crewType == 'fcm'): ?>
                                                            <h5><?php echo (isCaptain($each) ? 'Captain' : 'First Officer'); ?></h5>
                                                        <?php else: ?>
                                                            <h5><?php echo (isPurser($each) ? 'Purser' : 'Flight Attendant'); ?></h5>
                                                        <?php endif; ?>
                                                        <h5><?php echo $each->location; ?></h5>
                                                    </div>
                                                </div>
                                            </td>
                                        <?php else: ?>
                                            <?php $exportArray[$k] = [ '', '', '', ''] ?>
                                            <tr class="<?php echo $each->is_contractor ? 'contractorCrew' : ''; ?>">
                                        <?php endif; ?>
                                        <td><?php echo $j +1; ?></td>
                                        <td><?php echo date('d M Y', strtotime($each->std)); ?></td>
                                        <td><a target="_blank" href="<?php echo route("homepage")."#". url("/"); ?>/flight/details?id=<?php echo $each->flight_id; ?>"><?php echo $CURRENT_IATA_CODE.' '.$each->flight_number; ?></a></td>
                                        <td><?php echo $each->departure_airport."-".$each->arrival_airport; ?></td>
                                        <td><?php echo date('H:i', strtotime($each->std)); ?></td>
                                        <?php if($each->reason && in_array($each->reason, ['no_show', 'sick', 'roster_not_received'])): ?>
                                            <td><?php echo "&mdash;"; ?></td>
                                            <td><?php echo "&mdash;"; ?></td>
                                            <td><?php echo "&mdash;"; ?></td>
                                            <td><?php echo 'No Show'; ?></td>
                                            <td><?php echo ($each->reason == 'no_show' ? "" : $reasons[$each->reason]); ?></td>
                                        <?php else: ?>
                                            <td><?php echo date('H:i', strtotime($reportTime)); ?></td>
                                            <td><?php echo $actualReportTime; ?></td>
                                            <td class="<?php echo $totalMins < 75 ? 'red' : 'green'; ?>"><?php echo $timeDiffStr; ?></td>
                                            <td><?php echo $reasons[$each->reason]; ?></td>
                                            <td></td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
                    </tbody>
                </table>


            </div>
        </div>
    </div>
    <?php endif; ?>

</div><?php /**PATH /home/avbis/public_html/coastal/resources/views/crew/report-lateNoShow-tab.blade.php ENDPATH**/ ?>