<?php

//initilize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));

include_once(public_path("smart/inc/user_variables.php"));


/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = "Staff Report";

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));

?>


<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- possible classes: minified, no-right-panel, fixed-ribbon, fixed-header, fixed-width-->
<header id="header" class="no-padding" >
    <!--<span id="logo"></span>-->

    <div id="logo-group"  style="height: 60px; width: 100%; padding: 0 15px;" class="flightTrackerBackground">
        <h2 class="flightTracker color-white">Staff Report</h2>
    
    
    <!-- END AJAX-DROPDOWN -->
    </div>

</header>

<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" class="">
        <!-- widget grid -->
        <section id="widget-grid" class="">

            <!-- row -->
            <div class="row">

                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="col-sm-12 padding-0">

                        
                        <ul class="nav nav-tabs" id="tabs">

                            <li class="<?php echo e(!\request("tab") || \request("tab") == "hours" ? "active" : ""); ?>">
                                <a href="#hours_tab" data-toggle="tab">
                                    <span class="tabText"><?php echo app('translator')->get("content.roster_and_hours_reports"); ?></span>
                                </a>
                            </li>

                            <li class="<?php echo e(\request("tab") == "expiry" ? "active" : ""); ?>">
                                <a href="#expiry_tab" data-toggle="tab">
                                    <span class="tabText"><?php echo app('translator')->get("content.expiry_report"); ?></span>
                                </a>
                            </li>

                            <li class="<?php echo e(\request("tab") == "expiry_summary" ? "active" : ""); ?>">
                                <a href="#expiry_summary_tab" data-toggle="tab">
                                    <span class="tabText"><?php echo app('translator')->get("content.expiry_summary_report"); ?></span>
                                </a>
                            </li>


                        </ul>

                        
                        <div class="tab-content">

                            <div class="tab-pane <?php echo e(!\request("tab") || \request("tab") == "hours" ? "active" : ""); ?> bg-color-white" id="hours_tab" style="min-height: 550px; padding: 15px !important; width: 100%; ">

                                <div class="col-md-12" style="margin-bottom: 20px;">
                                    <?php echo $__env->make("staff-report.layouts.index-hours-form", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                                <?php if(\request("tab") == "hours"): ?>
                                    
                                    <ul class="nav nav-pills" id="tabs">

                                        <li class="active">
                                            <a href="#daily_tab" data-toggle="tab">
                                                <span class="tabText"><?php echo app('translator')->get("content.hours_report"); ?></span>
                                            </a>
                                        </li>
                                        <li class="">
                                            <a href="#export_tab" data-toggle="tab">
                                                <span class="tabText"><?php echo app('translator')->get("content.export_roster"); ?></span>
                                            </a>
                                        </li>
                                        <li class="">
                                            <a href="#ba_report_tab" data-toggle="tab">
                                                <span class="tabText">BA <?php echo app('translator')->get("content.report"); ?></span>
                                            </a>
                                        </li>
                                        
                                        
                                        
                                        
                                        
                                        <li class="">
                                            <a href="#by_staff_tab" data-toggle="tab">
                                                <span class="tabText"><?php echo app('translator')->get("content.by_staff"); ?></span>
                                            </a>
                                        </li>







                                        <li class="">
                                            <a href="#by_office_duties_tab" data-toggle="tab">
                                                <span class="tabText"><?php echo app('translator')->get("content.office_duties"); ?></span>
                                            </a>
                                        </li>

                                        <li class="">
                                            <a href="#by_airline_tab" data-toggle="tab">
                                                <span class="tabText"><?php echo app('translator')->get("content.by_airline"); ?></span>
                                            </a>
                                        </li>

                                        <li class="">
                                            <a href="#by_flight_tab" data-toggle="tab">
                                                <span class="tabText"><?php echo app('translator')->get("content.by_flight"); ?></span>
                                            </a>
                                        </li>

                                        <li class="">
                                            <a href="#by_flight_date_tab" data-toggle="tab">
                                                <span class="tabText"><?php echo app('translator')->get("content.by_flight_date"); ?></span>
                                            </a>
                                        </li>

                                    </ul>

                                    <div class="pill-content no-padding no-margin">

                                        <div class="pill-pane bg-color-white active" id="daily_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            <?php echo $__env->make("staff-report.layouts.index-daily-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                        <div class="pill-pane bg-color-white" id="export_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            <?php echo $__env->make("staff-report.layouts.index-export-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                        <div class="pill-pane bg-color-white " id="ba_report_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            <?php echo $__env->make("staff-report.layouts.index-ba-report-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                        
                                        
                                        

                                        
                                        <div class="pill-pane bg-color-white" id="by_staff_tab" style="min-height: 500px; padding: 15px 0 !important; width: 100%; overflow: auto;">
                                            <?php if($monthlyReport): ?>
                                                <?php echo $__env->make("staff-report.layouts.index-monthly-hours-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php else: ?>
                                                <?php echo $__env->make("staff-report.layouts.index-hours-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                        </div>





                                        <div class="pill-pane bg-color-white" id="by_office_duties_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            <?php echo $__env->make("staff-report.layouts.index-office-duties-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                        <div class="pill-pane bg-color-white" id="by_airline_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            <?php echo $__env->make("staff-report.layouts.index-airline-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                        <div class="pill-pane bg-color-white" id="by_flight_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            <?php echo $__env->make("staff-report.layouts.index-flight-number-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                        <div class="pill-pane bg-color-white" id="by_flight_date_tab" style="min-height: 250px; padding: 15px 0 !important; width: 100%; ">
                                            <?php echo $__env->make("staff-report.layouts.index-flight-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div>

                                    </div>
                                <?php endif; ?>
                            </div>

                            
                            <div class="tab-pane <?php echo e(\request("tab") == "expiry" ? "active" : ""); ?> bg-color-white" id="expiry_tab" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                                <?php echo $__env->make("staff-report.layouts.index-expiry-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="tab-pane <?php echo e(\request("tab") == "expiry_summary" ? "active" : ""); ?> bg-color-white" id="expiry_summary_tab" style="min-height: 550px; padding: 15px !important; width: 100%; overflow: auto;">
                                <?php echo $__env->make("staff-report.layouts.index-expiry-summary-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                        </div>

                    </div>

                </article>

            </div>

        </section>
    </div>
</div>



<script type="text/javascript">
    var baseUrl = "<?php echo e(url('/')); ?>";
    var baseDashboardUrl = "<?php echo e(url('home/dashboard')); ?>";
    var baseHomeUrl = "<?php echo e(route("homepage")."#". url('/')); ?>";
    var AIRLINE = "<?php echo e(env("AIRLINE")); ?>";
    var CARRIER = "<?php echo e(env("CARRIER")); ?>";
    var CURRENT_IATA_CODE = "<?php echo e(env("IATA_CODE")); ?>";
</script>

<?php
//include required scripts
include(public_path("smart/inc/scripts.php"));
?>


<script type="text/javascript">

    pageSetUp();

    // ApplyMultipleFormSubmit();

    var pagefunction = function () {

        ApplyValidationDateFormats();
        Apply_Multiselect();
        // ApplyTableFilter("#dailyTable", false, [[6, "asc"]]);
        ApplyTableFilter("#dailyTable");
        ApplyTableFilter("#exportTable");
        ApplyTableFilter("#baReportTable");
        ApplyTableFilter("#staff-table");
        ApplyTableFilter("#hoursTable");
        ApplyTableFilter("#office_duties_table");
        ApplyTableFilter("#airline-table");
        ApplyTableFilter("#flightNumberTable");
        ApplyTableFilter("#flightTable");
        ApplyTableFilter("#licensesTable");
        // ApplyTableFilterSortingOff(".sorting-off");

        <?php if(ghaModule()): ?>
            ApplyOperationsFormFilter(<?php echo json_encode($flightNumbers); ?>, <?php echo json_encode(\request("flightNumber")); ?>);
        <?php endif; ?>
    };

    pagefunction();

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/staff-report/index.blade.php ENDPATH**/ ?>