<!DOCTYPE html>
<html>
<head>
    <?php
    $page_title = "Flight Comms";
    $airline = env("AIRLINE");
    if ($airline == GSRM)
    {
        $title = "GSRM";
        $ico = "gsrm.ico";
    }
    elseif ($airline == DHS){
        $title = "DHS";
        $ico = "eos-64.ico";
    }
    elseif ($airline == FRAAI)
    {
        $title = "Air India";
        $ico = "air_india.ico";
    }
    elseif ($airline == TAJIK_AIR)
    {
        $title = "Tajik Air";
        $ico = "tajikair.ico";
    }
    elseif ($airline == QAZAQ_AIR)
    {
        $title = "Qazaq Air";
        $ico = "qazaqair.ico";
    }
    elseif ($airline == PEGASUS)
    {
        $title = "Pegasus";
        $ico = "pegasus.ico";
    }
    elseif ($airline == AVIAM)
    {
        $title = "AVIAM";
        $ico = "aviam.ico";
    }
    elseif ($airline == COASTAL){
        $title = "Coastal";
        $ico = "cq.ico";
    }
    else
    {
        $title = "AvBIS";
        $ico = "eos-64.ico";
    }
    ?>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    
    <title> <?php echo ($page_title != "" ? $page_title." - " : "").$title ; ?></title>
    <link rel="shortcut icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />
    <link rel="icon" href="<?php echo asset("/assets/img/icons/{$ico}") ?>" type="image/x-icon" />

    <link href="<?php echo e(asset("/assets/css/bootstrap.min.css")); ?>" rel="stylesheet" />
    
    <link rel="stylesheet" href="<?php echo e(asset("/assets/css/theme.blue.css")); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset("/assets/css/jquery.datetimepicker.css")); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset("/assets/css/bootstrap-multiselect.css")); ?>"/>


    <link href="<?php echo e(asset('assets/css/app.css?3')); ?>" rel="stylesheet" />

    <!-- Fonts -->
    <link href="<?php echo e(asset("/css/fonts.css")); ?>" rel="stylesheet" type='text/css' />

    <link href="<?php echo e(asset("/assets/css/prettify.css")); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset("/assets/css/jquery-ui.min.css")); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset("/assets/css/messenger.css")); ?>" rel="stylesheet" />

    
    <link href="<?php echo e(asset("/assets/css/timepicki.css")); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset("/assets/css/timepicki-style.css")); ?>" rel="stylesheet" />

    <link rel="stylesheet" type="text/css" media="screen" href="<?php echo e(asset("smart/css/font-awesome.min.css")); ?>">
        

        

    <?php echo $__env->yieldContent("css"); ?>

    <script>
        var baseUrl = "<?php echo e(url('/')); ?>";
        var CURRENT_IATA_CODE = "<?php echo e($CURRENT_IATA_CODE); ?>";

        var authUserId = "", authUserName = "", authUserStatus = "";
        <?php if(isset($auth) && is_object($auth) && $auth->user()): ?>
            authUserId = "<?php echo e($auth->user()->id); ?>";
            authUserName = "<?php echo e($auth->user()->first_name." ".$auth->user()->last_name); ?>";
            authUserStatus = "<?php echo e($auth->user()->chatStatus ? $auth->user()->chatStatus->status : STATUS_ONLINE); ?>";
        <?php endif; ?>

    </script>
</head>

<?php if(isset($auth) && is_object($auth) && $auth->user()): ?>
    
    <body style="margin: 0 !important; background: none;">
<?php else: ?>
    <body style="margin: 0 !important; background: none;">
<?php endif; ?>

    <div id="content" class="content">
        <?php echo $__env->yieldContent("content"); ?>
    </div>

    <?php echo $__env->make("flight-com.layouts.footer", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </body>



</html><?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-com/layouts/layout.blade.php ENDPATH**/ ?>