<?php
/**
 * Created by PhpStorm.
 * User: Dilovar Tursunov


 * Project: aviation.dev
 */
?>
<script type="text/template" id="general_tab_template" data-ignore = '1'>
    <div class="flight-info-header" style="padding:0 10px; background-color: <%= flightInfoHeaderBgColor %>">
        <h3 id="m_dep_airport" style="width: 70px; float: left;" data-toggle="tooltip" data-placement="top" data-original-title="<%= departureCity %>" class="text-warning"><%= departureCityCode %></h3>

        <div id="flight-progress" style="position: relative; top: 0; width: <%= progressBarPerc %>%; float: left;">
            <div class="progress progress-striped <%= flightBarPosition == 100 ? "" : "active" %>" style="margin: 10px auto; height: 10px; padding: 0; width: 100%" id="progressbar_container">
                <div class="progress-bar progress-bar-<%= progressStatus %>" role="progressbar" aria-valuenow="40" aria-valuemin="0"
                     aria-valuemax="100" style="width: <%= flightBarPosition %>%;" id="progressbar_line">
                </div>
            </div>
            
                
            
        </div>

        <h3 id="div_arr_airport"  style="width:<%= divAirportPerc %>%; float: left; text-align: center;" data-toggle="tooltip" data-placement="top" class="text-warning"><%= divAirport %></h3>

        <div id="div_panel" style="width: <%= divPanelPerc %>%; float: left;">
            <h4 style="color: red; font-size: 14px; padding: 7px 0;" ><%= originalDestinationLabel %></h4>
        </div>

        <h3 id="m_arr_airport"  style="width: 70px; color: <%= arrAirportColor %>; float: right; text-align: right;" data-toggle="tooltip" data-placement="top" data-original-title="<%= arrivalCity %>" class="text-warning"><%= arrivalCityCode %></h3>
    </div>

    <div class="clearfix"></div>

    <div style="width: 100%; padding: 5px 10px; display: inline-block">
        <h5 class="local_timings" id="m_dep_local" style="float: left;"><span class="badge badge-warning"><%= departureDateType %></span> <%= departureLocalDate %>, <strong><%= departureLocalTime %></strong> (Local Time)</h5>
        <h5 class="local_timings" id="m_arr_local" style="float: right; text-align: right;"><span class="badge badge-secondary"><%= arrivalDateType %></span> <%= arrivalLocalDate %>, <strong><%= arrivalLocalTime %></strong> (Local Time)</h5>
    </div>

    <div class="clearfix"></div>

    <div class="row flight-info-body">
        <!-- Departure, Arrival Information -->
        <div class="col-sm-12" style="margin: 5px 15px; color: #ffffff; display: <%= (delays) ? "block" : "none" %>;">
            <strong style="line-height: 1.5em; width: 95%; padding: 4px; background-color: #FF0500;"><%= delays %></strong>
        </div>

        <div class="clearfix"></div>

        <div class="col-sm-12" style="margin-top: 5px;">

            <!-- Departure dates table -->
            <!-- PAX Info -->

                <div class="float-left" style="width: 100%;">

                    <table class="pax-modal">
                        <tbody>
                        <tr class="exclude">
                            
                            <td style="width: 50px;"></td>
                            <td colspan="3" style="" >FLIGHT DETAILS</td>

                            
                            <td></td>
                            <td>PAX BKD - PNL</td>
                            <td></td>
                            <td colspan="8">PAX ACT - LDM</td>
                        </tr>
                        <tr class="exclude">
                            
                            <td class=""></td>
                            <td class="width-100">DEPARTURE</td>

                            <td class=""></td>
                            <td class="width-100">ARRIVAL</td>

                            
                            <td></td>
                            <td><?php echo e(strtoupper(trans("content.total"))); ?></td>
                            <td></td>
                            <td><?php echo e(strtoupper(trans("content.total"))); ?></td>
                            <%= airport_tr %>
                        </tr>
                        <tr class="">
                            
                            <td>STD</td>
                            <td class="data"><%= std %></td>
                            <td>STA</td>
                            <td class="data"><%= sta %></td>

                            
                            <td>F</td>
                            <td class="data"><%= pax_a_booked %></td>
                            <td>F</td>
                            <td class="data"><%= pax_a_actual %></td>
                            <%= pax_a_tr %>
                        </tr>
                        <tr class="">
                            
                            <td>PTD</td>
                            <td class="data"><%= ptd %></td>
                            <td>PTA</td>
                            <td class="data"><%= pta %></td>

                            
                            <td>C</td>
                            <td class="data"><%= pax_c_booked %></td>
                            <td>C</td>
                            <td class="data"><%= pax_c_actual %></td>
                            <%= pax_c_tr %>
                        </tr>
                        <tr class="">
                            
                            <td>ETD</td>
                            <td class="data"><%= etd %></td>
                            <td>ETA</td>
                            <td class="data"><%= eta %></td>

                            
                            <td>W</td>
                            <td class="data"><%= pax_w_booked %></td>
                            <td>W</td>
                            <td class="data"><%= pax_w_actual %></td>
                            <%= pax_w_tr %>
                        </tr>
                        <tr class="">
                            
                            <td>ATD</td>
                            <td class="data"><%= atd %></td>
                            <td>TDN</td>
                            <td class="data"><%= tdn %></td>

                            
                            <td>Y</td>
                            <td class="data"><%= pax_y_booked %></td>
                            <td>Y</td>
                            <td class="data"><%= pax_y_actual %></td>
                            <%= pax_y_tr %>


                        </tr>
                        <tr class="">
                            
                            <td>ABN</td>
                            <td class="data"><%= abn %></td>
                            <td>ATA</td>
                            <td class="data"><%= ata %></td>

                            
                            <td>INF</td>
                            <td class="data"><%= pax_inf_booked %></td>
                            <td>INF</td>
                            <td class="data"><%= pax_inf_actual %></td>
                            <%= pax_inf_tr %>



                        </tr>
                        <tr class="">
                            
                            <td></td>
                            <td class="data-unimportant"></td>
                            <td></td>
                            <td class="data-unimportant"></td>


                            <td></td>
                            <td>PAX - MVT</td>

                            <td>CH</td>
                            <td class="data-unimportant"><%= pax_ch_actual %></td>
                            <%= pax_ch_tr %>

                        </tr>
                        <tr class="">
                            
                            <td></td>
                            <td class="data-unimportant"></td>
                            <td></td>
                            <td class="data-unimportant"></td>

                            <td>PAX</td>
                            <td class="data-unimportant"><%= pax_mvt_px %></td>


                            <td>AD</td>
                            <td class="data-unimportant"><%= pax_adults_actual %></td>
                        </tr>

                        <tr>
                            
                            <td></td>
                            <td class="data-unimportant"></td>
                            <td></td>
                            <td class="data-unimportant"></td>

                            
                            <td>INF</td>
                            <td class="data-unimportant"><%= pax_mvt_inf %></td>

                            <td>M</td>
                            <td class="data-unimportant"><%= pax_m_actual %></td>
                            <%= pax_m_tr %>

                        </tr>
                        <tr>
                            
                            <td></td>
                            <td class="data-unimportant"></td>
                            <td></td>
                            <td class="data-unimportant"></td>

                            
                            <td><?php echo e(strtoupper(trans("content.total"))); ?></td>
                            <td class="data-unimportant"><%= pax_mvt_total %></td>

                            <td>F</td>
                            <td class="data-unimportant"><%= pax_f_actual %></td>
                            <%= pax_f_tr %>

                        </tr>
                        </tbody>
                    </table>
                </div>
            
            </div>



            <div class="clearfix"></div>

            <div class="col-sm-12" style="margin-top: 5px;">
                <table class="pax-modal">
                    <tbody>
                    <tr class="exclude">
                        <td style="width: 8%; max-width: 50px;" class=""></td>
                        <td style="" class="">BAGGAGE PCs / WT</td>
                        <td style="width: 18%" class="">CARGO PCs / WT</td>
                        <td style="width: 18%" class="">EIC</td>
                        <td style="width: 18%" class="">MAIL</td>
                        <td style="width: 18%" class=""><?php echo e(strtoupper(trans("content.total"))); ?></td>
                    </tr>
                    <%= baggage_content %>
                    <tr>
                        <td><?php echo e(strtoupper(trans("content.total"))); ?></td>
                        <td class="data"><%= baggage_pcs_total %> / <%= baggage_total %></td>
                        <td class="data"><%= cargo_pcs_total %> / <%= cargo_total %></td>
                        <td class="data"><%= eic_total %></td>
                        <td class="data"><%= mail_total %></td>
                        <td class="data"><%= total_bcme %></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        



            <div class="clearfix"></div>

            <div class="col-sm-12" style="margin-top: 5px;">
                <table class="pax-modal">
                    <tbody>
                    <tr class="exclude">
                        <td style="width: 8%; max-width: 50px;">FUEL</td>
                        <td style="" class="">IN TANKS</td>
                        <td style="width: 15%" class="">UPLIFTED</td>
                        <td style="width: 15%" class="">DEPARTURE</td>
                        <td style="width: 15%" class="">UTILISED</td>
                        <td style="width: 15%" class="">ARRIVAL</td>
                        <td style="width: 15%" class="">DEFUEL</td>
                    </tr>
                    <tr>
                        <td><?php echo e(strtoupper(trans("content.total"))); ?></td>
                        <td class="data"><%= in_tanks %></td>
                        <td class="data"><%= uplifted %></td>
                        <td class="data"><%= dep_fuel %></td>
                        <td class="data"><%= utilised %></td>
                        <td class="data"><%= arr_fuel %></td>
                        <td class="data"><%= defuel %></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            

            <?php if(airlineModule()): ?>
                <div class="clearfix"></div>

                <div class="col-sm-12" style="margin-top: 5px;">
                    <table class="pax-modal">
                        <tbody>
                        <tr class="exclude">
                            <td style="width: 8%"></td>
                            <td style="width: 46%">CAPTAIN(s)</td>
                            <td style="width: 46%">FIRST OFFICER(s)</td>
                        </tr>
                        <tr>
                            <td>OPT</td>
                            <td class="data"><%= (captains) ? captains : "&mdash;" %></td>
                            <td class="data"><%= (first_officers) ? first_officers : "&mdash;" %></td>
                        </tr>
                        <tr>
                            <td>SBY</td>
                            <td class="data"><%= (captains_standby) ? captains_standby : "&mdash;" %></td>
                            <td class="data"><%= (first_officers_standby) ? first_officers_standby : "&mdash;" %></td>
                        </tr>
                        <tr>
                            <td>DHC</td>
                            <td class="data"><%= (captains_dhc) ? captains_dhc : "&mdash;" %></td>
                            <td class="data"><%= (first_officers_dhc) ? first_officers_dhc : "&mdash;" %></td>
                        </tr>
                        </tbody>
                    </table>
                </div>

                <div class="clearfix"></div>

                <div class="col-sm-12" style="margin-top: 5px;">
                    <table class="pax-modal">
                        <tbody>
                        <tr class="exclude">
                            <td style="width: 8%"></td>
                            <td style="width: 92%">CABIN CREW(s)</td>
                        </tr>
                        <tr>
                            <td>OPT</td>
                            <td class="data"><%= (cabin_crew) ? cabin_crew : "&mdash;" %></td>
                        </tr>
                        <tr>
                            <td>SBY</td>
                            <td class="data"><%= (cabin_crew_standby) ? cabin_crew_standby : "&mdash;" %></td>
                        </tr>
                        <tr>
                            <td>DHC</td>
                            <td class="data"><%= (cabin_crew_dhc) ? cabin_crew_dhc : "&mdash;" %></td>
                        </tr>
                        <tr>
                            <td>SNY</td>
                            <td class="data"><%= (cabin_crew_sup) ? cabin_crew_sup : "&mdash;" %></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
    </div>
</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-watch/templates/flight-info-general-tab.blade.php ENDPATH**/ ?>