<div class="message_box"></div>
<?php echo Form::open(['method' => 'POST', 'url' => url("staff/{$user->id}"), 'class' => 'exclude-form']); ?>


<table class="table table-bordered table-striped table-hover editable_table" data-user_id="<?php echo e($user->id); ?>" style="width:100%; padding: 0; margin: 0">
    <thead>
    </thead>

    <tbody>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.first_name"); ?></td>
        <td>
            <a href="#" data-field='first_name' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->first_name ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->first_name ? $user->first_name : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.middle_name"); ?></td>
        <td>
            <a href="#" data-field='middle_name' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" class="editable <?php echo e($user->middle_name ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->middle_name ? $user->middle_name : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.last_name"); ?></td>
        <td>
            <a href="#" data-field='last_name' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" class="editable <?php echo e($user->last_name ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->last_name ? $user->last_name : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.email"); ?></td>
        <td>
            <a href="#" data-field='email' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>' data-placeholder="Required"
            class="editable <?php echo e($user->email ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->email ? $user->email : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.dob"); ?></td>
        <td>
            <a href="#" data-field='dob' data-model="User" data-type="date" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-format='d-M-Y'
               data-js_format='DD-MMM-YYYY' data-value='<?php echo e($user->dob); ?>'
               class="editable <?php echo e($user->dob ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->dob  ?  date('d-M-Y', strtotime($user->dob))  : 'Empty'); ?></a>
        </td>
    </tr>
    
        
        
            
               
               
               
                
        
    
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.doj"); ?></td>
        <td>
            <a href="#" data-field='doj' data-model="User" data-type="date" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-format='d-M-Y'
               data-js_format='DD-MMM-YYYY' data-value='<?php echo e($user->doj); ?>'
               class="editable <?php echo e($user->doj ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->doj  ?  date('d-M-Y', strtotime($user->doj))  : 'Empty'); ?></a>
        </td>
    </tr>
    <?php $locationAirport = $user->location && $user->location->airport ? $user->location->airport : null ?>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.location"); ?></td>
        <td>
            <a href="#" data-field='location_id' data-model="User" data-type="select" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-value='<?php echo e($user->location ? $user->location->id : null); ?>'
               class="editable <?php echo e($locationAirport ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($locationAirport ? $user->location->airport->iata : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.work_type"); ?></td>
        <td>
            <a href="#" data-field='work_type' data-model="User" data-type="select" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required" data-value='<?php echo e($user->work_type); ?>'
               class="editable <?php echo e($user->work_type ? 'editable-click' : 'editable-empty'); ?>">
                <?php echo e($user->work_type ? workTypeSelected($user->work_type) : 'Empty'); ?></a>

            
            
            
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.contractor"); ?></td>
        <td>
            <a href="#" data-field='is_contractor' data-model="User" data-type="checklist" data-id='<?php echo e($user->id); ?>' data-placeholder="Required"
               class="editable <?php echo e($user->is_contractor ? 'editable-click' : 'editable-empty'); ?>" data-value="<?php echo e($user->is_contractor); ?>">
                <?php echo e($user->is_contractor ? "Yes" : 'No'); ?></a>
        </td>
    </tr>

    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.department"); ?></td>
        <td>
            <a href="#" data-field='department_id' data-model="UserDepartment" data-type="select"
               data-id='<?php echo e($user->id); ?>' data-foreign_key='user_id'
               data-placeholder="Required"
               data-value='<?php echo e($user->department && isset($user->department[0]) ? $user->department[0]->id : null); ?>'
               class="editable <?php echo $user->department && isset($user->department[0]) ? 'editable-click' : 'editable-empty'; ?>">
                <?php echo $user->department && isset($user->department[0]) ? $user->department[0]->name : 'Empty'; ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.position"); ?></td>
        <td>
            <a href="#" data-field='position_id' data-model="UserDepartment" data-type="select"
               data-id='<?php echo e($user->id); ?>' data-foreign_key='user_id'
               data-placeholder="Required"
               data-value='<?php echo e($user->position && isset($user->position[0]) ? $user->position[0]->id : null); ?>'
               class="editable <?php echo $user->position && isset($user->position[0]) ? 'editable-click' : 'editable-empty'; ?>">
                <?php echo $user->position && isset($user->position[0]) ? $user->position[0]->name : 'Empty'; ?></a>
        </td>
    </tr>

    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.phone"); ?></td>
        <td>
            <a href="#" data-field='phone' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->phone ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->phone ? $user->phone : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.mobile"); ?>(<?php echo app('translator')->get("content.personal"); ?>)</td>
        <td>
            <a href="#" data-field='mobile' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->mobile ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->mobile ? $user->mobile : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.mobile"); ?>(<?php echo app('translator')->get("content.company"); ?>)</td>
        <td>
            <a href="#" data-field='company_mobile' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->company_mobile ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->company_mobile ? $user->company_mobile : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile"><?php echo app('translator')->get("content.company"); ?></td>
        <td>
            <a href="#" data-field='company' data-model="User" data-type="text" data-id='<?php echo e($user->id); ?>'
               data-placeholder="Required"
               class="editable <?php echo e($user->company ? 'editable-click' : 'editable-empty'); ?>"><?php echo e($user->company ? $user->company : 'Empty'); ?></a>
        </td>
    </tr>
    <tr>
        <td class="header_profile color-red"><?php echo app('translator')->get("content.password"); ?>*</td>
        <td>
            <?php echo Form::password('password', ['class' => 'form-control', 'placeholder' => 'Password', "required" => "required"]); ?>

        </td>
    </tr>

    <tr>
        <td class="header_profile color-red"><?php echo app('translator')->get("content.confirm_password"); ?>*</td>
        <td>
            <?php echo Form::password('password_confirmation', ['class' => 'form-control', 'placeholder' => 'Confirm Password', "required" => "required"]); ?>

        </td>
    </tr>

    <tr>
        <td class="header_profile">
            <?php if(isSuperAdmin()): ?>
                <a href="<?php echo e(url("system-log/login-as-user/{$user->id}")); ?>" target="_blank" class="btn btn-success">Login as User</a>
            <?php endif; ?>
        </td>
        <td>
            <?php echo Form::hidden("update_page", 1); ?>

            <?php echo Form::submit(trans("content.reset_password"), ['class'=>'btn btn-primary', "id" => "reset_pswd" ]); ?>

        </td>
    </tr>

    </tbody>

</table>

<?php echo Form::close(); ?>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/staff/layouts/general-info-tab.blade.php ENDPATH**/ ?>