<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-1" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
    <!-- widget options:
    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    data-widget-colorbutton="false"
    data-widget-editbutton="false"
    data-widget-togglebutton="false"
    data-widget-deletebutton="false"
    data-widget-fullscreenbutton="false"
    data-widget-custombutton="false"
    data-widget-collapsed="true"
    data-widget-sortable="false"

    -->
    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>
        <h2>List </h2>

    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="overflow: auto;">

            <table id="mhb" class="table table-striped table-bordered table-hover" width="100%">

                <thead>
                <tr>
                    <th><?php echo app('translator')->get("content.report_date"); ?></th>
                    <th><?php echo app('translator')->get("content.type"); ?></th>
                    <th><?php echo app('translator')->get("content.station"); ?></th>
                    <th><?php echo app('translator')->get("content.carrier"); ?></th>
                    <th>File Ref</th>
                    <th><?php echo app('translator')->get("content.ticket_number"); ?></th>

                    <th><?php echo app('translator')->get("content.title"); ?></th>
                    <th><?php echo app('translator')->get("content.last_name"); ?></th>
                    <th><?php echo app('translator')->get("content.initials"); ?></th>
                    <th><?php echo app('translator')->get("content.passport_no"); ?></th>
                    <th><?php echo app('translator')->get("content.address"); ?></th>
                    <th><?php echo app('translator')->get("content.phone"); ?></th>
                    <th><?php echo app('translator')->get("content.language"); ?></th>

                    <th>Number of Bags</th>
                    <th>Checked Weight</th>
                    <th>Received Weight</th>

                    <th><?php echo app('translator')->get("content.status"); ?></th>
                    <th style="min-width: 200px;"><?php echo app('translator')->get("content.actions"); ?></th>
                </tr>

                </thead>

                <tbody>
                <?php $__currentLoopData = $mhb; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $countBags = count($each->details) ?>
                    <?php $mhb_id = $each->id ?>
                    <?php $status = $each->applicationStatus ? $each->applicationStatus->status : "" ?>

                    <tr data-mhb_id="<?php echo e($mhb_id); ?>">
                        <td><?php echo e($each->report_date != 0 ? baseDateFormat($each->report_date) : ""); ?></td>
                        <td><?php echo e($each->type ? $each->type->type : ""); ?></td>
                        <td><?php echo e($each->airport ? $each->airport->iata : ""); ?></td>
                        <td><?php echo e($each->carrier); ?></td>
                        <td><?php echo e($each->file_reference); ?></td>
                        <td><?php echo e($each->ticket_number); ?></td>

                        <td><?php echo e(strtoupper($each->title)); ?></td>
                        <td><?php echo e($each->last_name); ?></td>
                        <td><?php echo e($each->initials); ?></td>
                        <td><?php echo e($each->passport_number); ?></td>
                        <td><?php echo e($each->permanent_address); ?></td>
                        <td><?php echo e($each->permanent_phone); ?></td>
                        <td><?php echo e($each->language); ?></td>

                        <td><?php echo e($countBags); ?></td>
                        <td><?php echo e($each->checked_baggage_weight); ?></td>
                        <td><?php echo e($each->received_baggage_weight); ?></td>
                        
                        <td>
                            <?php if($status == APPLICATION_STATUS_CANCELLED): ?>
                                <span class="label label-warning">CANCELLED</span>
                            <?php elseif($status == APPLICATION_STATUS_CLOSED): ?>
                                <span class="label label-success">CLOSED</span>
                            <?php else: ?>
                                <span class="label label-primary">OPEN</span>
                            <?php endif; ?>
                        </td>

                        <td style="width: 240px">
                            
                            <?php if(!$status || $status == APPLICATION_STATUS_OPEN): ?>
                                <div class="btn-group">

                                    <a style="float: left;" type="button" target="_blank" class="btn btn-sm btn-primary" href="<?php echo e(url("/mhb/export-pdf/{$each->id}?signature=1")); ?>">Sign</a>
                                    <a style="float: left;" type="button" target="_blank" class="btn btn-sm btn-warning" href="<?php echo e(url("/mhb/export-pdf/{$each->id}")); ?>">View</a>

                                    <div class="btn-group" style="float: left;">
                                        <?php echo Form::open(['method' => 'POST', 'id' => 'formMHBClose', 'class' => 'form-inline', 'url' => url("/mhb/{$mhb_id}") ]); ?>

                                            <?php echo Form::submit('Close', ['class' => "btn btn-sm btn-success"]); ?>

                                        <?php echo Form::close (); ?>

                                    </div>

                                    <div class="btn-group" style="float: left;">
                                        <?php echo Form::open(['method' => 'DELETE', 'id' => 'formMHBDelete', 'class' => 'form-inline', 'url' => url("/mhb/{$mhb_id}") ]); ?>

                                            <?php echo Form::submit('Cancel', ['class' => "btn btn-sm btn-danger"]); ?>

                                        <?php echo Form::close(); ?>

                                    </div>
                                </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>
        <!-- end widget content -->

    </div>
    <!-- end widget div -->

</div>
<!-- end widget --><?php /**PATH /home/avbis/public_html/coastal/resources/views/mhb/index-mhb-list-table.blade.php ENDPATH**/ ?>