<?php $checkbox = isset($checkbox) && $checkbox ?>

<table class="table table-bordered table-hover table-striped ops-table" style="width: 100% !important;" id="<?php echo e(isset($tableId) && $tableId ? $tableId : "ops-table"); ?>">
    <thead>
    <tr class="ops-header">
        <?php if($checkbox): ?>
            <th rowspan="2" data-center class="checkbox-column"><?php echo app('translator')->get("content.select"); ?></th>
        <?php else: ?>
            <th rowspan="2" data-center class="checkbox-column" style="display: none;"><?php echo app('translator')->get("content.select"); ?></th>
        <?php endif; ?>

        <th rowspan="2" data-center><?php echo app('translator')->get("content.FLT"); ?> No.</th>

        <th rowspan="2" data-center>NOTES</th>
        <th rowspan="2" data-center>AC</th>
        <th rowspan="2" data-center>DEP STN</th>
        <th rowspan="2" data-center style="min-width: 40px;">STD</th>
        <th rowspan="2" data-center style="min-width: 60px;">DEP</th>



        <th rowspan="2" data-center>ABN</th>
        <th rowspan="2" data-center>POS</th>
        <th rowspan="2" data-center>GATE</th>
        <th rowspan="2" data-center>CKIN CTRS</th>


        <th data-center colspan="3">PAX</th>
        <th data-center colspan="2">DELAY</th>

        <th rowspan="2" data-center>ARR STN</th>
        <th rowspan="2" data-center style="min-width: 40px;">STA</th>



        <th rowspan="2" data-center style="min-width: 60px;">ARR</th>



        <th rowspan="2" data-center>FLT INFO</th>

    </tr>

    <tr class="ops-header">



        <th data-center>C</th>
        <th data-center>Y</th>
        <th data-center>INF</th>

        <th data-center>CODE</th>
        <th data-center>TIME</th>
    </tr>
    </thead>

    <tbody>

    <?php $airlineICAO = env("ICAO") ?>
    <?php if(isset($flightsOPS) && count($flightsOPS)): ?>

        <?php $__currentLoopData = $flightsOPS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php $flightUrl = isset($flightDetails) ? url("flight-details/{$flight->id}") : url("flight-tracker/{$flight->id}") ?>
            <?php $aircraft = $flight->aircraft ?>
            <?php $aircraftType = $flight->aircraft && $flight->aircraft->type ? $flight->aircraft->type : $flight->aircraftType ?>
            <?php $flightNumber = $flight->flightNumber ?>
            <?php $airline = $flightNumber->airline ?>

            <?php $divertedFlight = $flight->divertedAirport ?>
            <?php $departureAirport = $flight->departureAirport ? $flight->departureAirport : $flightNumber->departureAirport ?>
            <?php $arrivalAirport = $flight->arrivalAirport ? $flight->arrivalAirport : $flightNumber->arrivalAirport ?>

            <?php $depDateTime = getFlightDepartureInitialDate($flight) ?>
            <?php $depDate = date("Y-m-d", strtotime($depDateTime)) ?>

            <?php $arrDateTime = getFlightArrivalInitialDate($flight) ?>
            <?php $arrDate = date("Y-m-d", strtotime($arrDateTime)) ?>
            <?php $picture = $airline && $airline->picture ? asset("storage/airlines/img/{$airline->picture}") : asset("/assets/img/default-airline-picture.png") ?>

            <?php list($capC, $capY) = getFlightCapacity($flight) ?>
            <?php list($actC, $actY, $actInf) = getFlightActualPaxWithInf($flight) ?>
            <?php list($bkdC, $bkdY, $bkdInf) = getFlightBookedPaxWithInf($flight) ?>

            <?php list($delayCodes, $delayTimes) = getFlightDelays($flight, true) ?>

            <?php $ac = getFwTableAC($aircraft, $aircraftType) ?>
            <?php $acData = getFwTableAC($aircraft, $aircraftType, true) ?>

            <tr data-id="<?php echo e($flight->id); ?>" data-ac_id="<?php echo e($aircraft ? $aircraft->id : 0); ?>" data-ac_type_id="<?php echo e($aircraftType ? $aircraftType->id : 0); ?>" data-ac="<?php echo e($acData); ?>" data-line="<?php echo e($flight->line); ?>" class="ops-body <?php echo e(isset($selectedFlightId) && $selectedFlightId == $flight->id ? "selected" : ""); ?>">
                <td class="checkbox-column" style="display: none">
                    <input class="flight-checkbox" type="checkbox" name="" value="" />
                </td>
                <td>
                    <a target="_blank" href="<?php echo e($flightUrl); ?>"><?php echo e(($airline ? ($airline->iata ? $airline->iata : $airline->icao) : "")." ".$flightNumber->flight_number); ?></a>
                </td>

                <td>
                    <?php if($divertedFlight): ?>
                        <span class="color-red">"DIVERTED"</span><br>
                    <?php endif; ?>
                    <?php if($flight->remark): ?>
                        <span class="color-red"><?php echo e($flight->remark); ?></span>
                    <?php endif; ?>
                </td>

                <td><?php echo $ac; ?></td>

                <td data-center>
                    <span class="margin-right-5"><?php echo e($departureAirport ? $departureAirport->iata : "-"); ?></span>
                    <span class="color-green"><?php echo e($departureAirport ? $departureAirport->icao : "-"); ?></span>
                </td>

                <td data-center><?php echo e(baseDateFormat($depDate, false, " ", true, false, "")." ".getFlightTimeComparedToBase($flight, STD, $depDate)); ?></td>

                <?php $depBadge = getFlightDepartureStatus($flight, $depDateTime, true) ?>
                <?php $depType = getFlightDepartureTimeType($flight, true) ?>
                <?php $dep = getFlightDepartureDate($flight, false, true) ?>
                <td class="">
                    <span class='badge <?php echo e($depBadge ? $depBadge : "badge-default"); ?> margin-right-5'><?php echo e($depType); ?></span><?php echo e($dep); ?>

                </td>








                <?php $atd = getFlightTimeComparedToBase($flight, ATD, $depDate) ?>
                <?php $etd = getFlightTimeComparedToBase($flight, ETD, $depDate) ?>


                <?php $flightCom = $flight->flightCom ?>
                <td data-center><?php echo e(getFlightTimeComparedToBase($flight, ABN, $depDate)); ?></td>
                <td data-center><?php echo e($flight->gate_parking); ?></td>
                <td data-center><?php echo e($flight->gate_boarding); ?></td>
                <td data-center><?php echo e($flightCom ? $flightCom->ckin_ctr : ""); ?></td>



                <?php if($actC || $actY): ?>
                    <td class="color-green" data-center><?php echo e($actC); ?></td>
                    <td class="color-green" data-center><?php echo e($actY); ?></td>
                    <td class="color-green" data-center><?php echo e($actInf); ?></td>
                <?php else: ?>
                    <td class="color-red" data-center><?php echo e($bkdC); ?></td>
                    <td class="color-red" data-center><?php echo e($bkdY); ?></td>
                    <td class="color-red" data-center><?php echo e($bkdInf); ?></td>
                <?php endif; ?>

                <td data-center class="color-red"><?php echo e($delayCodes); ?></td>
                <td data-center class="color-red"><?php echo e($delayTimes); ?></td>

                <td data-center>
                    <span class="margin-right-5"><?php echo e($arrivalAirport ? $arrivalAirport->iata : "-"); ?></span>
                    <span class="color-green"><?php echo e($arrivalAirport ? $arrivalAirport->icao : "-"); ?></span>
                </td>

                <td data-center><?php echo e(baseDateFormat($arrDate, false, " ", true, false, "")." ".getFlightTimeComparedToBase($flight, STA, $arrDate)); ?></td>



                <?php $arrBadge = getFlightArrivalStatus($flight, $arrDateTime, true) ?>
                <?php $arrType = getFlightArrivalTimeType($flight, true) ?>
                <?php $arr =  getFlightArrivalDate($flight, false, true) ?>
                <td class="">
                    <span class='badge <?php echo e($arrBadge ? $arrBadge : "badge-default"); ?> margin-right-5'><?php echo e($arrType); ?></span><?php echo e($arr); ?>

                </td>


                <?php $eta = getFlightTimeComparedToBase($flight, ETA, $arrDate) ?>
                <?php $ata = getFlightTimeComparedToBase($flight, ATA, $arrDate) ?>



                <td><span><?php echo e(getFlightStatusMessage($flight, $depDateTime, $eta, $ata, $etd, $atd)); ?></span></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    </tbody>
</table>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-tracker/layouts/flights-list-airline.blade.php ENDPATH**/ ?>