<?php require_once(public_path("smart/inc/init.php")); ?>

<link rel="stylesheet" href="<?php echo e(asset("/assets/js/vendor/select2/select2.css")); ?>">
<link rel="stylesheet" href="<?php echo e(asset("/assets/js/vendor/select2/select2-bootstrap.css")); ?>">

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <?php if($errors->all()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo $error; ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>
            <?php echo Form::open(['method' => 'POST', 'class' => 'form-inline', 'id' => 'formCrewSchedule']); ?>

                <div class="form-group">
                    <label form="from"><?php echo app('translator')->get("content.from"); ?></label>
                    <?php echo Form::text('from', \request("from") ? \request("from") : date('Y-m-d'), ['class'=>'form-control dateFrom', 'placeholder'=>'From Date', 'required', 'id' => 'from']); ?>

                </div>
                <div class="form-group">
                    <label form="to"><?php echo app('translator')->get("content.to"); ?></label>
                    <?php echo Form::text('to',  \request("to") ? \request("to") : date('Y-m-d'), ['class'=>'form-control dateTo', 'placeholder' => 'To Date', 'required', 'id' => 'to']); ?>

                </div>
                <button type="submit" class="btn btn-sm btn-primary margin_right" id="search"><?php echo app('translator')->get("content.submit"); ?></button>
                <?php if(isset($flights) && count($flights)): ?>
                <div class="form-group">
                    <?php echo Form::label('send', trans("content.send_email_to")); ?>

                    <?php echo Form::select('crewType', ['ccm' => 'Cabin Crew', 'fcm' => 'Flight Crew'], null, ['class'=>'form-control input-sm', 'id' => 'crewType']); ?>

                    <button type="button" class="btn btn-sm btn-success" id="btn-send-all-flights-email"><?php echo app('translator')->get("content.send_all_emails"); ?></button>
                </div>
                <?php endif; ?>
            <?php echo Form::close(); ?>

            <hr/>

        </article>

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

        <?php if(isset($from) && isset($to) && $from && $to): ?>

            <ul class="nav nav-tabs" role="tablist">
                <?php $start_time = $from ?>
                <?php while(strtotime($start_time) <= strtotime($to)): ?>
                    <li <?php echo ($start_time == $date) ? 'class="active"' : ''; ?>>
                        <a href="<?php echo e(route("homepage")."#". url("crew-schedule")); ?>?from=<?php echo e($from); ?>&to=<?php echo e($to); ?>&date=<?php echo e($start_time); ?>">
                        <?php echo e(date("Y-m-d", strtotime($start_time))); ?>

                        </a>
                    </li>
                    <?php $start_time = date("Y-m-d", strtotime("+1 day", strtotime($start_time))) ?>
                <?php endwhile; ?>
            </ul>

            <?php if(isset($flights) && count($flights) > 0): ?>
                <div class="tab-content padding-10 background-white">
                    <div class="tab-pane active" id="home" style="padding: 10px">

                    <?php echo Form::open(['id' => 'flights-form', 'class' => 'form-inline']); ?>


                <!--<button type="button" class="btn btn-sm btn-primary" id="btn-save-all-flights">Save All Flights Crew</button>-->

                <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $flightNumber = $flight->flightNumber;
                    $aircraft     = $flight->aircraft;
                    $flightCrew   = $flight->flightCrew;
                    $selectedCaptains = [
                        'general' => [(object)['id' => null]],
                        'standby' => [(object)['id' => null]],
                        'dhc' => [(object)['id' => null]]
                    ];
                    $selectedFirstOfficers = [
                        'general' => [(object)['id' => null]],
                        'standby' => [(object)['id' => null]],
                        'dhc' => [(object)['id' => null]]
                    ];
                    $selectedFlightAttendants = [
                        'general' => [
                            (object)['id' => null], (object)['id' => null], (object)['id' => null], (object)['id' => null]
                        ],
                        'standby' => [
                                (object)['id' => null]
                        ],
                        'dhc' => [
                            (object)['id' => null]
                        ],
                        'sup' => [
                            (object)['id' => null]
                        ]
                    ];

                    if (count($flightCrew)) {
                        if (isset($flightCrew['captains'])) {
                            foreach ($selectedCaptains as $type => $captainsItems) {
                                if (isset($flightCrew['captains'][$type])) {
                                    foreach ($flightCrew['captains'][$type] as $key => $captainItem) {
                                        $captainsItems[$key] = $captainItem;
                                    }
                                    $selectedCaptains[$type] = $captainsItems;
                                }
                            }
                        }
                        if (isset($flightCrew['firstOfficers'])) {
                            foreach ($selectedFirstOfficers as $type => $firstOfficersItems) {
                                if (isset($flightCrew['firstOfficers'][$type])) {
                                    foreach ($flightCrew['firstOfficers'][$type] as $key => $firstOfficerItem) {
                                        $firstOfficersItems[$key] = $firstOfficerItem;
                                    }
                                    $selectedFirstOfficers[$type] = $firstOfficersItems;
                                }
                            }
                        }
                        if (isset($flightCrew['flightAttendants'])) {
                            foreach ($selectedFlightAttendants as $type => $flightAttendantsItems) {
                                if (isset($flightCrew['flightAttendants'][$type])) {
                                    foreach ($flightCrew['flightAttendants'][$type] as $key => $flightAttendantItem) {
                                        $flightAttendantsItems[$key] = $flightAttendantItem;
                                    }
                                    $selectedFlightAttendants[$type] = $flightAttendantsItems;
                                }
                            }
                        }
                    }
                    ?>
                    <br/>
                    <table class="table table-bordered table-striped table-hover"
                           id="flight-<?php echo e($flight->id); ?>" data-child-id="<?php echo e($flight->child_id); ?>">

                        <tr>
                            <td colspan="2" class="text-success">
                                A/C:  <strong class="color-green margin-right-13"><?php echo e($aircraft ? "" . $aircraft->name : "-"); ?></strong>
                                PTD: <strong class="color-black margin-right-13"><?php echo e(baseDateFormat(getFlightDepartureInitialDatePTD($flight), true)); ?></strong>
                                FLT:  <strong class="color-green margin-right-13"><?php echo e($CURRENT_IATA_CODE ." - ". $flightNumber->flight_number); ?> (<?php echo e(getFlightSector($flight)); ?>)</strong>
                                <?php if($flight->child_id): ?>
                                    <strong class="color-green">/ <?php echo e($flightNumber->flight_number + 1); ?></strong>
                                <?php else: ?>
                                    <strong class="text-warning font11">Notice: inbound not found</strong>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div>
                                    <a target="_blank" href="<?php echo e(url("flight-docs/{$flight->id}")); ?>">General Declaration</a>
                                    | <a target="_blank" href="<?php echo e(url("flight-docs/{$flight->id}?type=FLIGHT_ORDER")); ?>">Flight Order</a>
                                    | <a target="_blank" href="<?php echo e(url("flight-docs/{$flight->id}?type=FLIGHT_LOG")); ?>">Flight Log</a>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <th>Captains</th>
                            <th>First Officers</th>
                            <th><?php echo app('translator')->get("content.cancellation_notification"); ?></th>
                        </tr>

                        <tr>
                            
                            <td class="captains">

                                <?php if($selectedCaptains): ?>
                                    <?php $__currentLoopData = $selectedCaptains['general']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group padding-3" data-item-number="<?php echo e($i + 1); ?>">
                                            <label>CAP #<?php echo e($i+1); ?></label>
                                            <?php echo Form::select('captain[]', $captains, $item->id, ['class'=>'form-control input-sm', 'id'=>'captain'.($i+1)]); ?>

                                        </div>
                                        <?php if($i < count($selectedCaptains['general']) - 1): ?>
                                            
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="btn-group" style="float: none; clear: both;">
                                        <button type="button" data-field="captain" data-maxAllowed='3' data-crew_type = ""  class="btn btn-success btn-sm add-crew">+</button>
                                        <button type="button" data-field="captain" data-minAllowed='1' data-crew_type = ""  class="btn btn-danger btn-sm remove-crew">-</button>
                                    </div>

                                    <br />
                                    <br />

                                    <?php $__currentLoopData = $selectedCaptains['dhc']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                            <label>DHC #<?php echo e($i + 1); ?></label>
                                            <?php echo Form::select('captain_dhc[]', $captains, $item->id, ['class'=>'form-control input-sm', 'id'=>'captain_dhc'.($i+1)]); ?>

                                        </div>
                                        <?php if($i < count($selectedCaptains['dhc']) - 1): ?>
                                            <br />
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <div class="btn-group" style="float: none; clear: both;">
                                        <button type="button" data-field="captain_dhc" data-maxAllowed='5' data-crew_type = "DHC"  class="btn btn-success btn-sm add-crew">+</button>
                                        <button type="button" data-field="captain_dhc" data-minAllowed='1' data-crew_type = "DHC"  class="btn btn-danger btn-sm remove-crew">-</button>
                                    </div>
                                    <br />

                                    <?php $__currentLoopData = $selectedCaptains['standby']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                            <label>SBY #<?php echo e($i + 1); ?></label>
                                            <?php echo Form::select('captain_standby[]', $captains, $item->id, ['class'=>'form-control input-sm', 'id'=>'captain_standby'.($i+1)]); ?>

                                        </div>
                                        <?php if($i < count($selectedCaptains['standby']) - 1): ?>
                                            <br />
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="btn-group" style="float: none; clear: both;">
                                        <button type="button" data-field="captain_standby" data-maxAllowed = '2' data-crew_type = "Standby"  class="btn btn-success btn-sm add-crew">+</button>
                                        <button type="button" data-field="captain_standby" data-minAllowed='1' data-crew_type = "Standby"  class="btn btn-danger btn-sm remove-crew">-</button>
                                    </div>
                                    <br />

                                <?php endif; ?>
                            </td>

                            
                            <td class="first_officers">
                                <?php $__currentLoopData = $selectedFirstOfficers['general']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                        <label>#<?php echo e($i + 1); ?></label>
                                        <?php echo Form::select('first_officer[]', $firstOfficers, $item->id, ['class'=>'form-control input-sm', 'id'=>'first_officer'.($i+1)]); ?>

                                    </div>
                                    <?php if($i < count($selectedFirstOfficers['general']) - 1): ?>
                                        <br />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="first_officer" data-maxAllowed = '3' data-crew_type = ""  class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="first_officer" data-minAllowed='1' data-crew_type = ""  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                <?php $__currentLoopData = $selectedFirstOfficers['dhc']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                        <label>DHC #<?php echo e($i + 1); ?></label>
                                        <?php echo Form::select('first_officer_dhc[]', $firstOfficers, $item->id, ['class'=>'form-control input-sm', 'id'=>'first_officer_dhc'.($i+1)]); ?>

                                    </div>
                                    <?php if($i < count($selectedFirstOfficers['dhc']) - 1): ?>
                                        <br />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="first_officer_dhc" data-maxAllowed = '5' data-crew_type = "DHC"  class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="first_officer_dhc" data-minAllowed='1' data-crew_type = "DHC"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                <?php $__currentLoopData = $selectedFirstOfficers['standby']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                        <label>Standby #<?php echo e($i + 1); ?></label>
                                        <?php echo Form::select('first_officer_standby[]', $firstOfficers, $item->id, ['class'=>'form-control input-sm', 'id'=>'first_officer_standby'.($i+1)]); ?>

                                    </div>
                                    <?php if($i < count($selectedFirstOfficers['standby']) - 1): ?>
                                        <br />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="first_officer_standby" data-maxAllowed = '2' data-crew_type = "Standby"  class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="first_officer_standby" data-minAllowed='1' data-crew_type = "Standby"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />
                            </td>

                            
                            <td class="notification_of_cancellation">
                                <div class="form-group">
                                    <label>Captains</label>
                                    <?php echo Form::select('captains_cancelled[]', $captains, null, ['class' => 'form-control input-sm select2', 'id'=>'captains_cancelled', 'style'=>'width:260px', 'multiple'=>'multiple']); ?>

                                </div><br/>
                                <div class="form-group">
                                    <label>First Officers</label>
                                    <?php echo Form::select('first_officers_cancelled[]', $firstOfficers, null, ['class' => 'form-control input-sm select2', 'id'=>'first_officers_cancelled', 'style'=>'width:260px', 'multiple'=>'multiple']); ?>

                                </div><br/>
                                <div class="form-group">
                                    <label>Cabin Crew</label>
                                    <?php echo Form::select('cabin_crew_cancelled[]', $cabinCrew, null, ['class' => 'form-control input-sm select2', 'id'=>'cabin_crew_cancelled', 'style'=>'width:260px', 'multiple'=>'multiple']); ?>

                                </div><br/>
                                <button type="button" class="btn btn-primary btn-sm btn-send-cancel-notifications"><?php echo app('translator')->get("content.send_notification"); ?></button>
                            </td>
                        </tr>

                        <tr>
                            <th>Cabin Crew</th>
                            <th>Cabin Crew DHC, Standby | SNY</th>
                            <th><?php echo app('translator')->get("content.actions"); ?></th>
                        </tr>

                        <tr>
                            
                            <td class="cabin_crew">
                                <?php $__currentLoopData = $selectedFlightAttendants['general']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                        <label>#<?php echo e($i + 1); ?></label>
                                        <?php echo Form::select('cabin_crew[]', $cabinCrew, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew'.($i+1)]); ?>

                                    </div>
                                    <?php if($i < count($selectedFlightAttendants['general']) - 1): ?>
                                        <br />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="cabin_crew" data-maxAllowed = '8' data-crew_type = "" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew" data-minAllowed='3' data-crew_type = ""  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                            </td>

                            
                            <td class="cabin_crew_dhc_standby">
                                <?php $__currentLoopData = $selectedFlightAttendants['dhc']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                        <label>DHC #<?php echo e($i + 1); ?></label>
                                        <?php echo Form::select('cabin_crew_dhc[]', $cabinCrew, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew_dhc'.($i+1)]); ?>

                                    </div>
                                    <?php if($i < count($selectedFlightAttendants['dhc']) - 1): ?>
                                        <br />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="btn-group" style="float: none; clear: both;">
                                    <button type="button" data-field="cabin_crew_dhc" data-maxAllowed = '10' data-crew_type = "DHC" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew_dhc" data-minAllowed='1' data-crew_type = "DHC"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                <?php $__currentLoopData = $selectedFlightAttendants['standby']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                        <label>Standby #<?php echo e($i + 1); ?></label>
                                        <?php echo Form::select('cabin_crew_standby[]', $cabinCrew, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew_standby'.($i+1)]); ?>

                                    </div>
                                    <?php if($i < count($selectedFlightAttendants['standby']) - 1): ?>
                                        <br />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="btn-group" style="">
                                    <button type="button" data-field="cabin_crew_standby" data-maxAllowed = '3'  data-crew_type = "Standby" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew_standby" data-minAllowed='1' data-crew_type = "Standby"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>
                                <br />

                                <?php $__currentLoopData = $selectedFlightAttendants['sup']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group" data-item-number="<?php echo e($i + 1); ?>">
                                        <label>SNY #<?php echo e($i + 1); ?></label>
                                        <?php echo Form::select('cabin_crew_sup[]', $staff, $item->id, ['class'=>'form-control input-sm', 'id'=>'cabin_crew_sup'.($i+1)]); ?>

                                    </div>
                                    <?php if($i < count($selectedFlightAttendants['sup']) - 1): ?>
                                        <br />
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="btn-group" style="">
                                    <button type="button" data-field="cabin_crew_sup" data-maxAllowed = '3'  data-crew_type = "SUP" class="btn btn-success btn-sm add-crew">+</button>
                                    <button type="button" data-field="cabin_crew_sup" data-minAllowed='1' data-crew_type = "SUP"  class="btn btn-danger btn-sm remove-crew">-</button>
                                </div>

                            </td>

                            
                            <td>
                                <div style="margin: 0 0 10px 0">
                                    <?php echo Form::label('crewLabel', trans("content.send_email_to")); ?>

                                    <?php echo Form::select('crewType', ['ccm' => 'Cabin Crew', 'fcm' => 'Flight Crew'], null, ['class'=>'form-control input-sm individualCrewType']); ?>

                                </div>
                                <div class="btn-group">
                                    <button type="button" class="save-flight-crew btn btn-primary btn-sm"><?php echo app('translator')->get("content.save_changes"); ?></button>
                                    <button type="button" class="send-email-to-flight-crew btn btn-success btn-sm"><?php echo app('translator')->get("content.send_email_to"); ?></button>
                                </div>
                            </td>
                        </tr>

                    </table>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php echo Form::close(); ?>

                    </div>
                </div>
            <?php else: ?>
                <br/>
                <div class="alert alert-warning" style="width: 50%">
                    <h4><?php echo app('translator')->get("content.found"); ?> 0 <?php echo app('translator')->get("content.flights"); ?></h4>
                </div>
            <?php endif; ?>

        <?php endif; ?>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var exceptionInputs = ['#from', '#to', '#search'];


    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        
    };

    loadScript("<?php echo e(asset("/assets/js/vendor/select2/select2.min.js")); ?>",
        loadScript("<?php echo e(asset("/assets/js/views/crew-schedule/index.js?2")); ?>",pagefunction)
    );

</script>


<?php /**PATH /home/avbis/public_html/coastal/resources/views/crew-schedule/index.blade.php ENDPATH**/ ?>