<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div>
                <?php echo Form::open(['method' => 'POST', 'class' => 'form-inline', 'id' => 'formSearch']); ?>

                    <div class="form-group marginBottomRight">
                        <label for="first_name"><?php echo app('translator')->get("content.first_name"); ?></label>
                        <?php echo Form::text('first_name', \request("first_name"), ['class'=>'form-control input-sm', 'placeholder'=>'First Name', 'id'=>'first_name']); ?>

                    </div>
                    <div class="form-group marginBottomRight">
                        <label for="last_name"><?php echo app('translator')->get("content.last_name"); ?></label>
                        <?php echo Form::text('last_name', \request("last_name"), ['class'=>'form-control input-sm', 'id'=>'last_name', 'placeholder' => 'Last Name']); ?>

                    </div>

                    <div class="form-group marginBottomRight">
                        <label for="in"><?php echo app('translator')->get("content.in"); ?></label>
                        <?php echo Form::select('crew_type', $crewTypes, $crewType, ['id' => 'in', 'class' => 'singleselect']); ?>

                    </div>

                    <div class="form-group marginBottomRight">
                        <label for="location"><?php echo app('translator')->get("content.location"); ?></label>
                        <?php echo Form::select('location', $locations, \request("location"), ['class' => 'singleselect', 'id' => 'location']); ?>

                    </div>

                    <div class="form-group marginBottomRight">
                        <?php echo Form::submit("Submit", ['name' => 'submit', 'value' => "Submit", 'class' => 'btn-sm btn btn-primary']); ?>

                    </div>

                    <div id="additional_fields" style="<?php echo (\request("in") == 2) ? "display:none" : ""; ?>">

                        <div class="form-group marginBottomRight">
                            <label><?php echo app('translator')->get("content.employee"); ?></label>

                            <div class="btn-group margin_right">
                                <?php echo Form::select('user_type[]', $userTypes, \request("user_type"), [ "multiple" => "multiple", "class" => "multiselect", "style" => "width: 168px !important" ] ); ?>

                            </div>
                        </div>

                        <div class="form-group marginBottomRight" id="ccm_type">
                            <label><?php echo app('translator')->get("content.cabin_crew_type"); ?></label>

                            <div class="btn-group margin_right">
                                <?php echo Form::select('ccm_type', $ccmTypes, \request("ccm_type"), [ "class" => "singleselect"] ); ?>

                            </div>
                        </div>

                        <div class="form-group marginBottomRight" id="english_level_block">
                            <label><?php echo app('translator')->get("content.english_level"); ?></label>

                            <div class="btn-group margin_right">
                                <?php echo Form::select('english_level[]', ['1' => 1, '2' => 2, '3' => 3, '4' => 4, '5' => 5, '6' => 6], \request("english_level"), [ "multiple" => "multiple", "class" => "multiselect", 'id' => 'english_level']); ?>

                            </div>
                        </div>

                        <div class="form-group marginBottomRight">
                            <label><?php echo app('translator')->get("content.languages"); ?></label>

                            <div class="btn-group margin_right">
                                <?php echo Form::select('lang[]', $languages, \request("lang"), [ "multiple" => "multiple", "class" => "multiselect"] ); ?>

                            </div>
                        </div>

                        <div class="form-group marginBottomRight">
                            <label><?php echo app('translator')->get("content.condition"); ?></label>

                            <div class="btn-group">
                                <?php echo Form::select('condition[]', $conditions, \request("condition"), [ "multiple" => "multiple", "class" => "multiselect", 'id' => 'condition'] ); ?>

                            </div>
                        </div>

                        <div class="form-group marginBottomRight" id="date_range" style="<?php echo (\request("condition")) ? "" : "display:none"; ?>">
                            <div class="form-group">
                                <label for="from"><?php echo app('translator')->get("content.from"); ?></label>
                                <?php echo Form::text('from', \request("from") ? \request("from") : date('Y-m-d'), ['class' => 'form-control datepicker', 'id' => 'from']); ?>

                            </div>
                            <div class="form-group">
                                <label for="to"><?php echo app('translator')->get("content.to"); ?></label>
                                <?php echo Form::text('to', \request("to") ? \request("to") : date('Y-m-d'), ['class' => 'form-control', 'id' => 'to']); ?>

                            </div>
                        </div>

                    </div>

                <?php echo Form::close(); ?>

            </div>

            <?php if(isset($users) && count($users)): ?>

                <div class="alert alert-success">
                    <?php echo app('translator')->get("content.found"); ?>: <?php echo count($users); ?> <?php echo app('translator')->get("content.records"); ?>.
                </div>

                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                    <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                    -->
                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                        <h2><?php echo app('translator')->get("content.list"); ?> </h2>

                    </header>

                    <!-- widget div-->
                    <div>

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding">

                            <table class="table table-bordered table-striped table-hover">
                                <thead>
                                <tr>
                                    <th rowspan="2">No</th>
                                    <th rowspan="2" style="width: 36px !important;"></th>
                                    <th rowspan="2"><?php echo app('translator')->get("content.first_name"); ?></th>
                                    <th rowspan="2"><?php echo app('translator')->get("content.last_name"); ?></th>
                                    <th rowspan="2"><?php echo app('translator')->get("content.position"); ?></th>
                                    <?php if(\request("crew_type") == FCM_CREW): ?>
                                        <th rowspan="2"><?php echo app('translator')->get("content.english_level"); ?></th>
                                    <?php else: ?>
                                        <th rowspan="2"><?php echo app('translator')->get("content.business_class_crew"); ?></th>
                                    <?php endif; ?>
                                    <th rowspan="2">SMS</th>
                                    <th rowspan="2"><?php echo app('translator')->get("content.location"); ?></th>
                                    <th colspan="3"><?php echo app('translator')->get("content.flight_hours"); ?></th>
                                    <th colspan="3"><?php echo app('translator')->get("content.not_available"); ?></th>
                                </tr>
                                <tr>
                                    <th><?php echo app('translator')->get("content.last_7_days"); ?></th>
                                    <th><?php echo app('translator')->get("content.current_month"); ?></th>
                                    <th><?php echo app('translator')->get("content.year_to_date"); ?></th>
                                    <th><?php echo app('translator')->get("content.from"); ?></th>
                                    <th><?php echo app('translator')->get("content.to"); ?></th>
                                    <th><?php echo app('translator')->get("content.reason"); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $i = 0 ?>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $picture = $user->thumb ? 'users/' . $user->thumb : 'default-user-picture.png' ?>
                                    <tr class="<?php echo $user->is_contractor ? 'contractorCrew' : ''; ?>">
                                        <td><?php echo e(++$i); ?></td>
                                        <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$user->user_id}")); ?>" target="_blank">
                                                <img src="<?php echo e(asset("assets/img/{$picture}")); ?>" class="img-thumbnail"  style="padding: 0;"/></a>
                                        </td>
                                        <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$user->user_id}")); ?>"target="_blank"><?php echo e($user->first_name); ?></a></td>
                                        <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$user->user_id}")); ?>"target="_blank"><?php echo e($user->last_name); ?></a></td>
                                        <td><?php echo e($user->position); ?></td>
                                        <?php if(\request("crew_type") == FCM_CREW): ?>
                                            <td><?php echo e($user->english_level); ?></td>
                                        <?php else: ?>
                                            <td><?php echo $user->is_business_crew ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>"; ?></td>
                                        <?php endif; ?>
                                        <td><?php echo ($user->cmc_to && strtotime($user->cmc_to) > time()) ? "<span class='glyphicon glyphicon-ok'></span>" : "<span class='glyphicon glyphicon-remove'></span>"; ?></td>
                                        <td><?php echo e($user->location && $user->location->airport ? $user->location->airport->iata : ''); ?></td>
                                        <td><?php echo e(isset($crewHours[$user->user_id]['last7days']) ? round($crewHours[$user->user_id]['last7days'], 2) : 0); ?></td>
                                        <td><?php echo e(isset($crewHours[$user->user_id]['monthToDate']) ? round($crewHours[$user->user_id]['monthToDate'], 2) : 0); ?></td>
                                        <td><?php echo e(isset($crewHours[$user->user_id]['yearToDate']) ? round($crewHours[$user->user_id]['yearToDate'], 2) : 0); ?></td>
                                        <?php $from = '' ?>
                                        <?php $to = '' ?>
                                        <?php $reason = '' ?>
                                        <?php $__empty_1 = true; $__currentLoopData = $user->userHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <?php if(\request("from")): ?>
                                                <?php if(strtotime(\request("from")) <= strtotime($history->to)): ?>
                                                    <?php $from .= $history->from.'<br/>' ?>
                                                    <?php $to .= $history->to.'<br/>' ?>
                                                    <?php $reason .= $conditions[$history->condition_id].'<br/>' ?>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <?php if(strtotime(date('Y-m-d')) <= strtotime($history->to)): ?>
                                                    <?php $from .= $history->from.'<br/>' ?>
                                                    <?php $to .= $history->to.'<br/>' ?>
                                                    <?php $reason .= $conditions[$history->condition_id].'<br/>' ?>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <?php endif; ?>
                                        <td><?php echo e($from); ?></td>
                                        <td><?php echo e($to); ?></td>
                                        <td><?php echo e($reason); ?></td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                        </div>

                    </div>

                </div>

            <?php elseif(\request("in")): ?>
                <div class="alert alert-info">
                    <button type="button" class="close" data-dismiss="alert"><span
                                aria-hidden="true">&times;</span><span
                                class="sr-only">Close</span></button>
                    <h4>No Result!</h4>

                    <p>Not found any user for given params</p>
                </div>
            <?php endif; ?>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");
    };

    loadScript("<?php echo e(asset("/assets/js/views/crew-query/index.js")); ?>", pagefunction);
</script><?php /**PATH /home/avbis/public_html/coastal/resources/views/crew-query/index.blade.php ENDPATH**/ ?>