<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a class="btn-sm btn btn-primary" href="<?php echo e(route("homepage")."#".url("module/create?s=".rand(100, 999))); ?>"><?php echo app('translator')->get("content.add_new_module"); ?></a>
                <?php if(isset($modules) && count($modules)): ?>
                    <a class="btn-sm btn btn-info" href="<?php echo e(route("homepage")."#".url("module/map")); ?>"><?php echo app('translator')->get("content.module_map"); ?></a>
                <?php endif; ?>
            </div>

            <div class="clearfix"></div>

            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>

                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2><?php echo app('translator')->get("content.list"); ?></h2>


                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        <div class="table-responsive">

                            <?php if(isset($modules) && count($modules)): ?>
                            <table class="table table-bordered table-hover" id="module-table">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th><?php echo app('translator')->get("content.name"); ?></th>
                                        <th><?php echo app('translator')->get("content.hidden"); ?></th>
                                        <th><?php echo app('translator')->get("content.link"); ?></th>
                                        <?php if(env(CARRIER) == HANDLING): ?>
                                            <th><?php echo app('translator')->get("content.category"); ?></th>
                                        <?php else: ?>
                                            <th><?php echo app('translator')->get("content.department"); ?></th>
                                        <?php endif; ?>

                                        <th><?php echo app('translator')->get("content.permissions"); ?></th>
                                        <th style="width: 300px"><?php echo app('translator')->get("content.actions"); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $permissions = [] ?>
                                    <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($module->name); ?></td>
                                        <td><?php echo $module->hidden_module ? '<i class="fa fa-check"></i>' : ""; ?></td>

                                        <td><a href="<?php echo e(route("homepage")."#".url($module->link)); ?>" target="_blank"><?php echo e($module->link); ?></a></td>

                                        <?php if(env(CARRIER) == HANDLING): ?>
                                            <th><?php echo e($module->category); ?></th>
                                        <?php else: ?>
                                            <td><?php echo e(($module->department_id == 0) ? "Home" : (($module->department_id == -1) ? "Admin Menu" : ($module->department ? $module->department->name : "-") )); ?></td>
                                        <?php endif; ?>

                                        <td>
                                        <?php if(count($module->permission)): ?>
                                            <?php $__currentLoopData = $module->permission; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!$each->deleted_at): ?>
                                                    <?php $permissions[] = $each->name ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php echo e(implode(' | ', array_slice($permissions, 0, 5))); ?>

                                            <?php echo e(count($permissions) > 5 ? '...' : ''); ?>

                                        <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a target="_blank" class="btn btn-sm btn-primary" href="<?php echo e(route("homepage")."#".url("module/{$module->id}/edit?s=".rand(100, 999))); ?>"><?php echo app('translator')->get("content.edit"); ?></a>
                                                <a class="btn btn-sm btn-danger confirm" data-confirm-text="Are you sure you want to remove this module?"
                                                   href="<?php echo e(route("homepage")."#".url("module/delete/{$module->id}")); ?>"><?php echo app('translator')->get("content.delete"); ?></a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                  </tbody>
                            </table>
                            <?php endif; ?>

                        </div>

                    </div>

                </div>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#module-table");
    };

    pagefunction();

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/module/index.blade.php ENDPATH**/ ?>