<div class="tab-pane tab_holder <?php echo !is_null($reportType) && $reportType =='Route' ? 'active' : ''; ?>" id="route"
     style="padding: 10px 0;">
    <div class="col-lg-12" style="margin-bottom: 10px;">
        <?php echo Form::open(['method' => 'GET',  'url' => url("crew/report?reportType=Route"),'class'=>"form-inline", 'id' => 'formRoute' ]); ?>

        <div class="form-group margin_right">
            <label class="control-label"><?php echo app('translator')->get("content.crew"); ?></label>
            <?php echo Form::select('crew', ['fcm'=>'Flight Crew','ccm'=>'Cabin Crew'], $crewType, ['class'=>'form-control input_roster crew']); ?>

        </div>
        <div class="form-group margin_right">
            <label class="control-label"><?php echo app('translator')->get("content.designation"); ?></label>
            <?php echo Form::select('designation', $designationList , \request("destination"), ['class'=>'form-control input_roster crew_designation']); ?>

        </div>

        <div class="form-group margin_right">
            <label class="control-label"><?php echo app('translator')->get("content.report_date"); ?></label>
            <?php echo Form::input('text', 'routesReportDate', $date, ['class'=>'dateFrom form-control', 'id' => 'routesReportDate']); ?>

        </div>

        <div class="form-group">
            
            <?php echo Form::input('submit', 'submit','Submit',[ 'class' => "btn btn-primary"]); ?>

        </div>
        <?php echo Form::close(); ?>

    </div>

    <div class="col-lg-12" style="margin-bottom: 50px; padding: 0">

        <?php $sectors_dyu = ['DYU-FRA', 'DYU-IST', 'DYU-DXB', 'DYU-URC', 'DYU-ALA', 'DYU-DME', 'DYU-LED','DYU-IKT','DYU-KRR', 'DYU-KJA','DYU-LBD', 'DYU-SVX', 'DYU-KZN', 'DYU-REN'] ?>
        <?php $sectors_dyu_stations = ['FRA', 'IST', 'DXB', 'URC', 'ALA', 'DME', 'LED','IKT', 'KRR', 'KJA','LBD','SVX', 'KZN', 'REN'] ?>
        <?php $sectors_lbd = ['LBD-DME', 'LBD-LED', 'LBD-KRR', 'LBD-KJA', 'LBD-REN', 'LBD-KZN','LBD-AER', 'LBD-HMA','LBD-NJC', 'LBD-TJM'] ?>
        <?php $sectors_lbd_stations = ['DME', 'LED', 'KRR', 'KJA', 'REN', 'KZN','AER', 'HMA', 'NJC', 'TJM'] ?>
        <?php $reportName = ['Crew Hours Report'] ?>
        <?php $columnNames[0] = ['No', 'Last Name', 'First Name', 'Designation', ['Counter' => 2], ['DYU Routes' => 14], ['LBD Routes' => 10] ] ?>
        <?php $columnNames[1] = ['', '', '', '', 'Stand-by', 'DHC'] ?>
        <?php $exportArray = [] ?>

        <?php if(count($crew)): ?>
            <div class="clearfix"></div>
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                    <h2><?php echo app('translator')->get("content.year_to_date"); ?></h2>

                </header>

                <!-- widget div-->
                <div style="width: 100%;overflow: auto;">

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">
                        <table class="table table-bordered table-striped table-hover" id="routesTable" style="">
                            <thead>
                            <tr>
                                <th>No</th>
                                <th></th>
                                <th><?php echo app('translator')->get("content.first_name"); ?></th>
                                <th><?php echo app('translator')->get("content.last_name"); ?></th>
                                <th><?php echo app('translator')->get("content.base"); ?></th>
                                <th><?php echo app('translator')->get("content.designation"); ?></th>
                                <th>SB</th>
                                <th>DHC</th>
                                <?php $aRoutes = [] ?>
                                <?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $__currentLoopData = $crew; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(isset($crewHours[$id]['flight_history'][$route->route_from]) || isset($crewHours[$id]['flight_history'][$route->route_to])): ?>
                                            <th data-center><?php echo e($route->route_from); ?></th>
                                            <?php $aRoutes[] = $route ?>
                                            <?php break; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $i = 0; ?>
                            <?php $__currentLoopData = $crew; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $picture = $each->thumb ? '/storage/users/'.$each->thumb : '/assets/img/default-user-picture.png'; ?>
                                <tr class="<?php echo e($each->is_contractor ? 'contractorCrew' : ''); ?> ">
                                    <td><?php echo e($i + 1); ?> </td>
                                    <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$each->id}")); ?>" target="_blank">
                                            <img src="<?php echo e($picture); ?>" class="img-thumbnail thumb_report_prev"/>
                                        </a>
                                    </td>
                                    <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$each->id}")); ?>" target="_blank"><?php echo e($each->first_name); ?></a></td>
                                    <td><a href="<?php echo e(route("homepage")."#". url("crew/profile?id={$each->id}")); ?>" target="_blank"><?php echo e($each->last_name); ?></a></td>
                                    <?php $crewDesignation = Crew_Designation($crewType, $each) ?>
                                    <?php $standbyCounter = isset($crewHours[$id]['is_standby']) ? $crewHours[$id]['is_standby'] : 0 ?>
                                    <?php $dhcCounter = isset($crewHours[$id]['is_dhc']) ? $crewHours[$id]['is_dhc'] : 0 ?>
                                    <td><?php echo e($each->location ? $each->location->airport->iata : ''); ?></td>
                                    <td><?php echo e($crewDesignation); ?></td>
                                    <td data-center><?php echo e($standbyCounter); ?> </td>
                                    <td data-center><?php echo e($dhcCounter); ?> </td>

                                    <?php $__currentLoopData = $aRoutes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <td data-center><?php echo e(isset($crewHours[$id]['flight_history'][$route->route_from]) ? $crewHours[$id]['flight_history'][$route->route_from] :
                                         (isset($crewHours[$id]['flight_history'][$route->route_to]) ? $crewHours[$id]['flight_history'][$route->route_to] : 0)); ?> </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/crew/report-route-tab.blade.php ENDPATH**/ ?>