<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a href="<?php echo e(route("homepage")."#". url("staff/create?s=".rand(100, 999))); ?>" class="btn btn-primary"><?php echo app('translator')->get("content.add_new_staff"); ?></a>
                <a href="<?php echo e(route("homepage")."#". url("staff-upload")); ?>" class="btn btn-success mr-5"><?php echo app('translator')->get("content.upload_staff"); ?></a>
            </div>

            <div class="clearfix"></div>

            <ul class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#staff-by-stations" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.all_current_staff"); ?></a>
                </li>
                <li class="">
                    <a href="<?php echo e(route("homepage")."#staff/by-station"); ?>"><?php echo app('translator')->get("content.by_station"); ?></a>
                </li>

                <?php if($terminatedPermission || $sprAdm): ?>
                    <li class="">
                        <a href="<?php echo e(route("homepage")."#staff/terminated-deleted"); ?>"><?php echo app('translator')->get("content.terminated_staff"); ?></a>
                    </li>
                    <li class="">
                        <a href="<?php echo e(route("homepage")."#staff/terminated-deleted"); ?>"><?php echo app('translator')->get("content.deleted_staff"); ?></a>
                    </li>
                <?php endif; ?>
            </ul>

            <div class="tab-content padding-10 background-white">
                <div class="tab-pane active" id="staff-by-stations">
                    <?php echo $__env->make("staff.layouts.staff-list", ["i" => 0, "id" => "current", "airport" => ALL, "staffList" => $staffList], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#staff-table-current-0");
    }

    pagefunction();

</script><?php /**PATH /home/avbis/public_html/coastal/resources/views/staff/index.blade.php ENDPATH**/ ?>