<div class="tab-pane tab_holder <?php echo $reportType && $reportType == 'FDP' ? 'active' : ''; ?>" id="fdp-calculator" style="padding: 10px 0;">

    <div class="col-lg-12" style="margin-bottom: 10px">
        <div class="col-lg-6">
            <?php echo Form::open(['method' => 'GET', 'url' => url("crew/report?reportType=FDP"), 'class'=>"form-inline", 'id' => 'formFDP' ]); ?>


            <?php echo Form::label('dateFrom', trans("content.from")); ?>

            <?php echo Form::text('dateFrom', \request("dateFrom") ? \request("dateFrom") : date('Y-m-d'), ['class' => 'form-control dateFrom inputDateSmall', 'required' => true]); ?>

            <?php echo Form::label('dateFrom', trans("content.to")); ?>

            <?php echo Form::text('dateTo', \request("dateTo") ? \request("dateTo") : date('Y-m-d'), ['class' => 'form-control dateTo inputDateSmall', 'required' => true]); ?>

            <?php echo Form::label('perPage', trans("content.per_page")); ?>

            <?php echo Form::select('perPage', [10 => 10, 20 => 20, 50 => 50, '' => 'All'], \request("perPage") ? \request("perPage") : 20, ['class' => 'form-control']); ?>

            <?php echo Form::submit('Submit', ['class' => 'btn btn-primary']); ?>

            <?php echo Form::close(); ?>

        </div>
        <div class="col-lg-6 text-right filters">
            <div style="display: inline-block">
                <div style="margin: 10px; float: left;">
                    <span class="label label-success valid filter_status" data-apply = 1><?php echo app('translator')->get("content.within_limits"); ?></span>
                    <span class="label label-danger crossed filter_status" data-apply = 1><?php echo app('translator')->get("content.above_limits"); ?></span>
                    
                </div>
                <div style="float: left" class="round-button">
                    <div class="round-button-circle">
                        <a href="#" class="round-button" id="applyFilter"><?php echo app('translator')->get("content.apply"); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12" id="message-block"></div>
    <?php if(count($flights)): ?>
        <div class="col-lg-12">
        <?php if( isset($pagination ) && isset($pagination['pagination'])): ?>
                <div class="clearfix"></div>
                <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-10" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                    <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                    -->
                    <header>
                        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

                        <h2><?php echo app('translator')->get("content.list"); ?> </h2>

                    </header>

                    <!-- widget div-->
                    <div style="width: 100%;overflow: auto;">

                        <!-- widget edit box -->
                        <div class="jarviswidget-editbox">
                            <!-- This area used as dropdown edit box -->

                        </div>
                        <!-- end widget edit box -->

                        <!-- widget content -->
                        <div class="widget-body no-padding">
                            <table class="table table-bordered table-striped table-hover" id="fdpReport" style="margin-bottom: 10px">
                                <thead>
                                <tr>
                                    <th rowspan="2">No</th>
                                    <th rowspan="2" style="min-width: 60px;"><?php echo app('translator')->get("content.dept"); ?></th>
                                    <th rowspan="2" style="min-width: 50px;"><?php echo app('translator')->get("content.ac"); ?></th>
                                    <th rowspan="2"><?php echo app('translator')->get("content.flight_number"); ?></th>
                                    <th rowspan="2" style="min-width: 60px;"><?php echo app('translator')->get("content.route"); ?></th>
                                    <th colspan="2"><?php echo app('translator')->get("content.departure"); ?></th>
                                    <th rowspan="2" style="min-width: 130px;"><?php echo app('translator')->get("content.departure"); ?></th>
                                    <th rowspan="2" style="min-width: 130px;"><?php echo app('translator')->get("content.arrival"); ?></th>
                                    <th colspan="5" class="text-center">FDP</th>
                                    <th colspan="3" class="text-center"><?php echo app('translator')->get("content.flight_crew"); ?></th>
                                    <th colspan="3" class="text-center"><?php echo app('translator')->get("content.cabin_crew"); ?></th>
                                    
                                    
                                </tr>
                                <tr>
                                    <th><?php echo app('translator')->get("content.user_defined"); ?></th>
                                    <th style="min-width: 100px;">STD</th>

                                    <th style="min-width: 100px;"><?php echo app('translator')->get("content.start"); ?></th>
                                    <th><?php echo app('translator')->get("content.plan"); ?></th>
                                    <th><?php echo app('translator')->get("content.est"); ?></th>
                                    <th><?php echo app('translator')->get("content.act"); ?></th>
                                    <th><?php echo app('translator')->get("content.calc"); ?></th>

                                    <th><?php echo app('translator')->get("content.min"); ?></th>
                                    <th><?php echo app('translator')->get("content.act"); ?></th>
                                    <th>FDP</th>

                                    <th><?php echo app('translator')->get("content.min"); ?></th>
                                    <th><?php echo app('translator')->get("content.act"); ?></th>
                                    <th>FDP</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $currentPage = \request("page") ? \request("page") - 1 : 0 ?>
                                <?php $perPage = \request("perPage") ? \request("perPage") : count($flights) ?>
                                <?php $j = 0 ?>
                                    <?php $__currentLoopData = $pagination['pagination']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($i >= $currentPage * $perPage && $i < $currentPage * $perPage + $perPage): ?>

                                            <?php $dep = getFlightDepartureInitialDate($flight) ?>
                                            <tr>
                                                <td><?php echo e($j + 1); ?></td>
                                                <td><?php echo e(date('d M y', strtotime($dep))); ?></td>
                                                <td><?php echo e($flight->aircraft ? $flight->aircraft->name : ""); ?></td>
                                                <td><a target="_blank" href="<?php echo e(url("flight-tracker/{$flight->id}")); ?>"><?php echo e($fltNo = $CURRENT_IATA_CODE.' '.$flight->flightNumber->flight_number); ?></a>
                                                    <?php if($flight->flightChild): ?>
                                                        <?php $childFltNo = $flight->flightChild->flightNumber->flight_number ?>
                                                        <a target="_blank" href="<?php echo e(url("flight-tracker/{$flight->flightChild->id}")); ?>"><?php echo e('/ '.$childFltNo); ?></a>
                                                        <?php $fltNo .= '/ '.$childFltNo ?>
                                                    <?php endif; ?>
                                                    <?php $fltNo ?>
                                                </td>

                                                <td><?php echo e($sector = getSector($flight->flightNumber)); ?>

                                                    <?php if($flight->flightChild): ?>
                                                        <?php $sectorChild = getSector($flight->flightChild->flightNumber) ?>
                                                        <?php echo e('-'.$routeChild); ?>

                                                        <?php $route .= "-".$routeChild ?>
                                                    <?php endif; ?>
                                                </td>
                                                
                                                <?php if($flight->arrivalType == ATA): ?>
                                                    <td align="center"><span class="label label-warning departureArrivalType"><?php echo e('LANDED'); ?></span></td>
                                                <?php else: ?>
                                                    <td><p class="editable_values" data-date_format='d M y, H:i'><?php echo e(""); ?></p></td>
                                                <?php endif; ?>


                                                <td><p class="std"><?php echo e(date('d M y, H:i', strtotime($dep))); ?></p></td>

                                                <td><p class="departure" style="float: left; "><?php echo e(date('d M y, H:i', strtotime($flight->departure))); ?></p><?php echo departureArrivalTypeSpan($flight->departureType); ?></td>
                                                <td><p class="arrival" style="float: left; "><?php echo e(date('d M y, H:i', strtotime($flight->arrival))); ?></p><?php echo departureArrivalTypeSpan($flight->arrivalType); ?></td>

                                                <?php $estimateCrossed = $flight->fdpEstimate && $flight->fdpEstimate > $flight->fdpMaxFlightCrew ? "color-red" : "" ?>
                                                <?php $actualCrossed = $flight->fdpActual && $flight->fdpActual > $flight->fdpMaxFlightCrew ? "color-red" : "" ?>

                                                <td><p class="fdpStart"><?php echo e(date('d M y, H:i', strtotime($flight->fdpStart))); ?></p></td>
                                                <td class="fdp"><p class="fdpPlanned"><?php echo e($flight->fdpPlanned ? hoursToTime($flight->fdpPlanned, true) : ""); ?></p></td>
                                                <td class="fdp"><p class="fdpEstimate <?php echo e($estimateCrossed); ?>"><?php echo e($flight->fdpEstimate ? hoursToTime($flight->fdpEstimate, true) : ""); ?></p></td>
                                                <td class="fdp"><p class="fdpActual <?php echo e($actualCrossed); ?>"><?php echo e($flight->fdpActual ? hoursToTime($flight->fdpActual, true) : ""); ?></p></td>
                                                <td class="fdp"><p class="fdpCalculated"></p></td>


                                                <td><p class="minFcm"><?php echo e(getMinFCM($flight)); ?></p></td>
                                                <td><p class="currentFcm"><?php echo e($flight->flightCrewCounter); ?></p></td>
                                                <td class="<?php echo e($flight->fdpFlightCrewViolate ? 'red' : 'green'); ?>"><p class="fdpMaxFcm"><?php echo e(hoursToTime($flight->fdpMaxFlightCrew, true)); ?></p></td>

                                                <td><p class="minCcm"><?php echo e(getMinCCM($flight)); ?></p></td>
                                                <td><p class="currentCcm"><?php echo e($flight->cabinCrewCounter); ?></p></td>
                                                <td class="<?php echo e($flight->fdpCabinCrewViolate ? 'red' : 'green'); ?>"><p class="fdpMaxCcm"><?php echo e(hoursToTime($flight->fdpMaxCabinCrew, true)); ?></p></td>
                                            </tr>

                                            <?php $j++ ?>
                                            <?php if(isset($flight->flightWithRest) && $flight->flightWithRest): ?>
                                                <?php $flightWithRest = $flight->flightWithRest ?>
                                                <?php $restDep = getFlightDepartureInitialDate($flightWithRest) ?>
                                                <tr>
                                                    <td><?php echo e($j +1); ?></td>
                                                    <td><?php echo e(date('d M y', strtotime($restDep))); ?></td>
                                                    <td><?php echo e($flightWithRest->aircraft ? $flightWithRest->aircraft->name : ""); ?></td>
                                                    <td><a target="_blank" href="<?php echo e(url("flight-tracker/{$flightWithRest->id}")); ?>"><?php echo e($fltNo = $CURRENT_IATA_CODE.' '.$flightWithRest->flightNumber->flight_number); ?></a>
                                                        <?php if($flightWithRest->flightChild): ?>
                                                            <?php $childFltNo = $flightWithRest->flightChild->flightNumber ? $flightWithRest->flightChild->flightNumber->flight_number : "" ?>
                                                            <a target="_blank" href="<?php echo e(url("flight-tracker/{$flightWithRest->flightChild->id}")); ?>"><?php echo e('/ '.$childFltNo); ?></a>
                                                            <?php $fltNo .= '/ '.$childFltNo ?>
                                                        <?php endif; ?>
                                                        <?php $fltNo ?>
                                                    </td>
                                                    <td><?php echo e($route = getSector($flightWithRest->flightNumber)); ?>

                                                        <?php if($flightWithRest->flightChild): ?>
                                                            <?php $routeChild = $flightWithRest->flightChild->flightNumber->arrival_airport ?>
                                                            <?php echo e('-'.$routeChild); ?>

                                                            <?php $route .= '-'.$routeChild ?>
                                                        <?php endif; ?>
                                                        <?php $route ?>
                                                    </td>
                                                    
                                                    <?php if($flightWithRest->arrivalType == ATA): ?>
                                                        <td align="center"><span class="label label-warning departureArrivalType"><?php echo e('LANDED'); ?></span></td>
                                                    <?php else: ?>
                                                        <td><p class="editable_values" data-date_format='d M y, H:i'><?php echo e(""); ?></p></td>
                                                    <?php endif; ?>

                                                    <td><p class="std"><?php echo e(date('d M y, H:i', strtotime($restDep))); ?></p></td>

                                                    <td><p class="departure" style="float: left; "><?php echo e(date('d M y, H:i', strtotime($flightWithRest->departure))); ?></p><?php echo departureArrivalTypeSpan($flightWithRest->departureType); ?></td>
                                                    <td><p class="arrival" style="float: left; "><?php echo e(date('d M y, H:i', strtotime($flightWithRest->arrival))); ?></p><?php echo departureArrivalTypeSpan($flightWithRest->arrivalType); ?></td>

                                                    <?php $estimateCrossed = $flightWithRest->fdpEstimate && $flightWithRest->fdpEstimate > $flightWithRest->fdpMaxFlightCrew ? "color-red" : "" ?>
                                                    <?php $actualCrossed = $flightWithRest->fdpActual && $flightWithRest->fdpActual > $flightWithRest->fdpMaxFlightCrew ? "color-red" : "" ?>

                                                    <td><p class="fdpStart"><?php echo e(date('d M y, H:i', strtotime($flightWithRest->fdpStart))); ?></p></td>
                                                    <td class="fdp"><p class="fdpPlanned"><?php echo e($flightWithRest->fdpPlanned ? hoursToTime($flightWithRest->fdpPlanned, true) : ""); ?></p></td>
                                                    <td class="fdp"><p class="fdpEstimate <?php echo e($estimateCrossed); ?>"><?php echo e($flightWithRest->fdpEstimate ? hoursToTime($flightWithRest->fdpEstimate, true) : ""); ?></p></td>
                                                    <td class="fdp"><p class="fdpActual <?php echo e($actualCrossed); ?>"><?php echo e($flightWithRest->fdpActual ? hoursToTime($flightWithRest->fdpActual, true) : ""); ?></p></td>
                                                    <td class="fdp"><p class="fdpCalculated"></p></td>

                                                    <td><p class="minFcm"><?php echo e(getMinFCM($flightWithRest)); ?></p></td>
                                                    <td><p class="currentFcm"><?php echo e($flightWithRest->flightCrewCounter); ?></p></td>
                                                    <td class="<?php echo e($flightWithRest->fdpFlightCrewViolate ? 'red' : 'green'); ?>"><p class="fdpMaxFcm"><?php echo e(hoursToTime($flightWithRest->fdpMaxFlightCrew, true)); ?></p></td>

                                                    <td><p class="minCcm"><?php echo e(getMinCCM($flightWithRest)); ?></p></td>
                                                    <td><p class="currentCcm"><?php echo e($flightWithRest->cabinCrewCounter); ?></p></td>
                                                    <td class="<?php echo e($flightWithRest->fdpCabinCrewViolate ? 'red' : 'green'); ?>"><p class="fdpMaxCcm"><?php echo e(hoursToTime($flightWithRest->fdpMaxCabinCrew, true)); ?></p></td>
                                                </tr>
                                                <?php $j++ ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php echo $pagination['pagination']->appends(request()->all())->render(); ?>

        <?php endif; ?>
    </div>
    <?php endif; ?>
</div><?php /**PATH /home/avbis/public_html/coastal/resources/views/crew/report-fdp-tab.blade.php ENDPATH**/ ?>