<script>
    $(document).on("click", '.view_btn', function() {
        var _this = $(this);
        _this.parents("tr").find(".read_and_sign").removeAttr("disabled");
        // $('#read_and_sign').val(this.checked);
    });

    $(document).on("change", '.read_and_sign', function() {
        if(this.checked) {
            $(this).parent().next().removeAttr("disabled");
        }
        else {
            $(this).parent().next().attr("disabled", true);
        }
        // $('#read_and_sign').val(this.checked);
    });
</script>

<?php if(!count($libraryViews)): ?>
    <div class="alert alert-danger">
        You currently have no new notifications
    </div>
<?php else: ?>
<div class="jarviswidget jarviswidget-color-blueDark" id="email-recipient-list" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2><?php echo app('translator')->get("content.list"); ?></h2>
    </header>

    <!-- widget div-->
    <div>

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover apply_filter" id="notificationsTable">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th><?php echo app('translator')->get("content.name"); ?></th>
                        <th><?php echo app('translator')->get("content.airline"); ?></th>
                        <th><?php echo app('translator')->get("content.created"); ?></th>
                        <th><?php echo app('translator')->get("content.last_viewed"); ?></th>
                        <?php if($user->id == $authUser->id): ?>
                            <th><?php echo app('translator')->get("content.actions"); ?></th>
                            <th><?php echo app('translator')->get("content.viewed_and_signed"); ?></th>
                            <th></th>
                        <?php else: ?>
                            <th><?php echo app('translator')->get("content.viewed_and_signed"); ?></th>
                        <?php endif; ?>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $libraryViews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($each->airlineLibrary): ?>
                            <?php $column = "airline-library" ?>
                            <?php $library = $each->airlineLibrary ?>
                        <?php else: ?>
                            <?php $column = "library" ?>
                            <?php $library = $each->library ?>
                        <?php endif; ?>

                        <?php if($library->deleted_at): ?>
                            <?php continue; ?>
                        <?php endif; ?>

                        <tr class="<?php echo e(!$each->viewed_at ? "unread" : (!$each->signed_at ? "unsigned" : "")); ?>">
                            <td><?php echo e($i + 1); ?></td>
                            <td>
                                <a target="_blank" href="<?php echo e(url("{$column}/file/{$library->id}")); ?>?view=1" class="view_btn">
                                    <?php echo e($library->name); ?>

                                </a>
                            </td>
                            <td><?php echo e($library->airline ? $library->airline->airline : ""); ?></td>
                            <td><?php echo e($each->created_at); ?></td>
                            <td>
                                <?php if($each->viewed_at): ?>
                                    <p class="color-green"><i class="fa fa-check font-md margin-right-5"></i> <?php echo e($each->viewed_at); ?></p>
                                <?php else: ?>
                                    <div class="text-center"><i class="fa fa-remove color-red font-md"></i></div>
                                <?php endif; ?>
                            </td>

                            <?php if($user->id == $authUser->id): ?>
                                <?php if($library->attachment_file): ?>
                                    <td style="min-width: 150px">
                                        <div class="btn-group">
                                            <a target="_blank" href="<?php echo e(url("{$column}/file/{$library->id}")); ?>?view=1" class="btn btn-warning view_btn"><?php echo app('translator')->get("content.view"); ?></a>
                                            <a href="<?php echo e(url("{$column}/file/{$library->id}")); ?>?download=1" class="btn btn-primary view_btn"><?php echo app('translator')->get("content.download"); ?></a>
                                        </div>
                                    </td>
                                <?php else: ?>
                                    <td class="color-red">Attachment document has not been uploaded yet.</td>
                                <?php endif; ?>

                                <td>
                                    <?php if($each->signed_at): ?>
                                        <p class="color-green"><i class="fa fa-check font-md margin-right-5"></i> <?php echo e($each->signed_at); ?></p>
                                    <?php else: ?>
                                        <div class="text-center"><i class="fa fa-remove color-red font-md"></i></div>
                                    <?php endif; ?>
                                </td>

                                <td>
                                    <?php if($library->attachment_file): ?>
                                        <?php if($each->signed_at): ?>
                                            <p class="color-green">
                                                <i class="fa fa-check font-md margin-right-5"></i>
                                                You have read and signed the document.
                                            </p>
                                        <?php else: ?>
                                            <?php $viewed = $each->viewed_at || $each->downloaded_at ?>
                                            <?php $disabled = !$viewed ? "disabled" : "" ?>
                                            <?php if(!$viewed): ?>
                                                <p class="color-red">Please view or download the document and then sign it.</p>
                                            <?php endif; ?>

                                            <div class="form-inline">
                                                <?php echo Form::open(["url" => url("library-view/save/{$each->id}")]); ?>

                                                    <label class="margin-right-10">
                                                        <?php echo Form::checkbox("read_and_sign", 1, false, ["class" => "form-control margin-right-5 read_and_sign", $disabled]); ?>

                                                        Check here to indicate that you have read and signed the document
                                                    </label>
                                                    <?php echo Form::submit("Confirm", ["class" => "btn btn-success", "disabled"] ); ?>

                                                <?php echo Form::close(); ?>

                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            <?php else: ?>
                                <td>
                                    <?php if($each->signed_at): ?>
                                        <p class="color-green"><i class="fa fa-check font-md margin-right-5"></i> <?php echo e($each->signed_at); ?></p>
                                    <?php else: ?>
                                        <div class="text-center"><i class="fa fa-remove color-red font-md"></i></div>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>

        </div>

    </div>

</div>
<?php endif; ?><?php /**PATH /home/avbis/public_html/coastal/resources/views/user-notifications/layouts/index-list.blade.php ENDPATH**/ ?>