<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            <?php echo $__env->make('report.form', ['enablePeriod' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </article>

        <!-- NEW WIDGET START -->
        <article class="col-sm-12 col-md-12 col-lg-12">

            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-2" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">
                <!-- widget options:
                usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                data-widget-colorbutton="false"
                data-widget-editbutton="false"
                data-widget-togglebutton="false"
                data-widget-deletebutton="false"
                data-widget-fullscreenbutton="false"
                data-widget-custombutton="false"
                data-widget-collapsed="true"
                data-widget-sortable="false"

                -->
                <header>
                    <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                    <h2><?php echo app('translator')->get("content.seat_factors"); ?></h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->

                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body no-padding">

                        <div class="table-responsive">

                            <table class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th><?php echo app('translator')->get("content.period"); ?></th>
                                    <th><?php echo app('translator')->get("content.flight"); ?></th>
                                    <th colspan='2' class="text-center"><?php echo app('translator')->get("content.capacity"); ?></th>
                                    <th colspan='2' class="text-center">PAX</th>
                                    <th rowspan="2"><?php echo app('translator')->get("content.total"); ?></th>
                                </tr>

                                <tr>
                                    <th>(<?php echo app('translator')->get("content.or"); ?> <?php echo app('translator')->get("content.flight_number"); ?>)</th>
                                    <th><?php echo app('translator')->get("content.total"); ?></th>
                                    <th><?php echo app('translator')->get("content.business"); ?></th>
                                    <th><?php echo app('translator')->get("content.economy"); ?></th>

                                    <th><?php echo app('translator')->get("content.business"); ?></th>
                                    <th><?php echo app('translator')->get("content.economy"); ?></th>
                                </tr>

                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $seatFactors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $error = $each->sf > 100 ?>
                                    <tr>
                                        <td><?php echo $date; ?></td>
                                        <td><?php echo $each->pax_flight_count; ?></td>
                                        <td><?php echo $each->config_c; ?></td>
                                        <td><?php echo $each->config_y; ?></td>
                                        <td><?php echo $each->pax_c; ?></td>
                                        <td><?php echo $each->pax_y; ?></td>
                                        <td class="<?php echo e($error ? 'color-red' : ""); ?>"><?php echo e(round($each->sf)); ?>%</td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
            <!-- end widget -->

        </article>
        <!-- WIDGET END -->

        <?php $height = $seatFactors && count($seatFactors) > 5 ? count($seatFactors) * 17 : 120 ?>

        <article class="col-xs-12 col-sm-6 col-md-6 col-lg-6">

            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false"
                 data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                 data-widget-sortable="false">
                <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                -->
                <header>

                    <h2><?php echo app('translator')->get("content.capacity"); ?> <?php echo app('translator')->get("content.and"); ?> PAX</h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->
                        <input class="form-control" type="text">
                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">

                        <!-- this is what the user will see -->
                        <canvas id="barChart" height="<?php echo e($height); ?>"></canvas>

                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
        </article>

        <article class="col-xs-12 col-sm-6 col-md-6 col-lg-6">

            <!-- Widget ID (each widget will need unique ID)-->
            <div class="jarviswidget" id="wid-id-2" data-widget-colorbutton="false"
                 data-widget-fullscreenbutton="false" data-widget-editbutton="false"
                 data-widget-sortable="false">
                <!-- widget options:
                    usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

                    data-widget-colorbutton="false"
                    data-widget-editbutton="false"
                    data-widget-togglebutton="false"
                    data-widget-deletebutton="false"
                    data-widget-fullscreenbutton="false"
                    data-widget-custombutton="false"
                    data-widget-collapsed="true"
                    data-widget-sortable="false"

                -->
                <header>

                    <h2><?php echo app('translator')->get("content.seat_factors"); ?></h2>

                </header>

                <!-- widget div-->
                <div>

                    <!-- widget edit box -->
                    <div class="jarviswidget-editbox">
                        <!-- This area used as dropdown edit box -->
                        <input class="form-control" type="text">
                    </div>
                    <!-- end widget edit box -->

                    <!-- widget content -->
                    <div class="widget-body">

                        <!-- this is what the user will see -->
                        <canvas id="chartSF" height="<?php echo e($height); ?>"></canvas>

                    </div>
                    <!-- end widget content -->

                </div>
                <!-- end widget div -->

            </div>
        </article>
    </div>
</section>

<script type="text/javascript">

    pageSetUp();

    // PAGE RELATED SCRIPTS

    var pagefunction = function () {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        // CAPACITY CHART

        var barOptions = GetChartJsBarOptions();

        var barData = {
            labels: <?php echo json_encode($chartCapPax["date"]); ?>,
            datasets: [
                {
                    label: "Capacity",
                    backgroundColor: "rgba(56, 113, 207, 0.5)",
                    hoverBackgroundColor: "rgba(56, 113, 207,0.8)",
                    borderColor: "rgba(56, 113, 207,1)",
                    borderWidth: 1,
                    data: <?php echo json_encode($chartCapPax["cap"]); ?>

                },
                {
                    label: "PAX",
                    backgroundColor: "rgba(151,187,205,0.5)",
                    hoverBackgroundColor: "rgba(151,187,205,0.8)",
                    borderColor: "rgba(151,187,205,1)",
                    borderWidth: 1,
                    data: <?php echo json_encode($chartCapPax["pax"]); ?>

                }
            ]
        };

        // render chart
        var ctx = document.getElementById("barChart").getContext("2d");
        myNewChart_1 = new Chart(ctx, {
            type: 'horizontalBar',
            data: barData,
            options: barOptions
        });
        // END CAPACITY CHART


        // SEAT FACTORS CHART
        var chartSFData = {
            labels: <?php echo json_encode($chartSF["date"]); ?>,
            datasets: [
                {
                    label: "Capacity",
                    backgroundColor: "rgba(50, 147, 50, 0.5)",
                    hoverBackgroundColor: "rgba(50, 147, 50, 0.8)",
                    borderColor: "rgba(50, 147, 50, 1)",
                    borderWidth: 1,
                    data: <?php echo json_encode($chartSF["sf"]); ?>

                },
            ]
        };

        var ctxSF = document.getElementById("chartSF").getContext("2d");
        myNewChart_2 = new Chart(ctxSF, {
            type: 'horizontalBar',
            data: chartSFData,
            options: barOptions
        });
    };

    var pagedestroy = function(){
        myNewChart_1.destroy();
        myNewChart_1=null;

        myNewChart_2.destroy();
        myNewChart_2=null;
    };

    loadScript("<?php echo e(asset("/assets/js/views/report/punctuality.js")); ?>", function () {
        loadScript("<?php echo ASSETS_URL; ?>/js/plugin/chartjs/chart.min.js", pagefunction)
    });


</script>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/report/seatfactors.blade.php ENDPATH**/ ?>