<div>
<?php echo Form::open(['class' => 'form-inline', 'method' => 'GET', 'id' => 'formOPS']); ?>

    <?php if(isset($enableRevenue) && $enableRevenue): ?>
        <div class="form-group marginBottomRight">
            <label class="control-label"><?php echo app('translator')->get("content.report_type"); ?></label>
            <?php echo Form::select('reportType', $reportTypes, \request("reportType"), ['class'=>'singleselect', 'id'=>'report_type']); ?>

        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label"><?php echo app('translator')->get("content.country"); ?></label>
            <?php echo Form::select('country[]', $countries, \request("country"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'country']); ?>


        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label"><?php echo app('translator')->get("content.city"); ?></label>
            <?php echo Form::select('city[]', $cities, \request("city"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'city']); ?>

        </div>
        <div class="form-group marginBottomRight">
            <label class="control-label"><?php echo app('translator')->get("content.agency"); ?></label>
            <?php echo Form::select('agency[]', $agencies, \request("agency"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'agency']); ?>

        </div>
    <?php endif; ?>

    <?php if(env(MULTIPLE_AIRLINE) && ghaModule() && isset($enableAirline) && $enableAirline): ?>
        <div class="form-group marginBottomRight">
            <label><?php echo app('translator')->get("content.airline"); ?></label>
            <div class="btn-group">
                <?php echo Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']); ?>

            </div>
        </div>
    <?php endif; ?>

    <?php if(isset($enableAirport) && $enableAirport): ?>
        <div class="form-group marginBottomRight">
            <label><?php echo app('translator')->get("content.airport"); ?></label>
            <div class="btn-group">
                <?php echo Form::select('airport[]', $airports, \request("airport"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airport']); ?>

            </div>
        </div>

        <div class="form-group marginBottomRight">
            <label><?php echo app('translator')->get("content.type"); ?></label>
            <div class="btn-group">
                <?php echo Form::select('type', isset($types) ? $types : [ DEPARTURE => DEPARTURE, ARRIVAL => ARRIVAL, ALL => ALL ], \request("type"), [ 'class'=>'multiselect', 'id'=> 'type' ]); ?>

            </div>
        </div>
    <?php endif; ?>

    <div class="form-group marginBottomRight">
        <?php echo Form::hidden('activeTab', 'Analysis'); ?>

        <label><?php echo Form::radio('flightSearch','flightNumber', !\request("flightSearch") || \request("flightSearch") == 'flightNumber'); ?> <?php echo app('translator')->get("content.flight_number"); ?></label>
        <div class="btn-group">
            <?php if(is_array($flightNumbers)): ?>
                <?php echo Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']); ?>

            <?php else: ?>
                <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                    <?php $__currentLoopData = $flightNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($each->id); ?>" <?php echo \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : ""; ?>><?php echo e($each->sector); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            <?php endif; ?>
        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label><?php echo Form::radio('flightSearch','sector', \request("flightSearch") == 'sector'); ?> <?php echo app('translator')->get("content.sector"); ?></label>
        <div class="btn-group">
            <?php echo Form::select('sector[]', $sectors, \request("sector"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'sector']); ?>

        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label><?php echo Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo'); ?> <?php echo app('translator')->get("content.from"); ?></label>
        <?php echo Form::text('dateFrom', !\request("dateSearch") ? $dateYesterday : \request("dateFrom"), ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']); ?>

        <label form="dateTo"><?php echo app('translator')->get("content.to"); ?></label>
        <?php echo Form::text('dateTo', !\request("dateSearch") ? $dateYesterday : \request("dateTo"), ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']); ?>

    </div>

    <div class="form-group marginBottomRight">
        <label><?php echo Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear'); ?> <?php echo app('translator')->get("content.month"); ?></label>
        <div class="btn-group">
            <?php echo Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'month']); ?>

        </div>
    </div>

    <div class="form-group marginBottomRight">
        <label for="year" class="control-label"><?php echo app('translator')->get("content.year"); ?></label>
        <div class="btn-group">
            <?php echo Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect', 'id'=>'period']); ?>

        </div>
    </div>

    <?php if(isset($enablePeriod) && $enablePeriod): ?>
        <div class="form-group marginBottomRight">
            <label for="period" class="control-label"><?php echo app('translator')->get("content.period"); ?></label>
            <div class="btn-group">
                <?php echo Form::select('period', $periods, \request("period"), ['class'=>'multiselect_search']); ?>

            </div>
        </div>
    <?php endif; ?>

    <div class="form-group marginBottomRight">
        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get("content.submit"); ?></button>
    </div>
<?php echo Form::close(); ?>

</div><?php /**PATH /home/avbis/public_html/coastal/resources/views/report/ops-form.blade.php ENDPATH**/ ?>