<?php require_once(public_path("smart/inc/init.php")); ?>
        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-sm-12 col-md-12 col-lg-12">
            <?php echo $__env->make('aircraft-utilization.layouts.index-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </article>

        <article class="col-sm-12 col-md-12 col-lg-12">

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#flights" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.flight_data"); ?></a>
                </li>
                <li class="">
                    <a href="#ac_types" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.ac_types"); ?></a>
                </li>
                <li class="">
                    <a href="#ac" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.ac_registration"); ?></a>
                </li>
                <li class="">
                    <a href="#sectors" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.sectors"); ?></a>
                </li>
                <li class="">
                    <a href="#flight_numbers" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.flight_numbers"); ?></a>
                </li>
            </ul>

            <?php $active = 0 ?>
            <div id="tabContent" class="tab-content padding-10 background-white">

                <div class="tab-pane active" id="flights">
                    <?php echo $__env->make("aircraft-utilization.layouts.index-flights-tab", ["index" => "flights"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="tab-pane" id="ac_types">
                    <?php echo $__env->make("aircraft-utilization.layouts.index-ac-type-tab", ["index" => "acTypes"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="tab-pane " id="ac">
                    <?php echo $__env->make("aircraft-utilization.layouts.index-ac-tab", ["index" => "aircraft"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="tab-pane " id="sectors">
                    <?php echo $__env->make("aircraft-utilization.layouts.index-sectors-tab", ["index" => "sectors"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="tab-pane" id="flight_numbers">
                    <?php echo $__env->make("aircraft-utilization.layouts.index-flight-numbers-tab", ["index" => "flightNumbers"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>


            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyValidationDateFormats();

        Apply_Multiselect();

        <?php if(ghaModule()): ?>
            ApplyOperationsFormFilter(<?php echo json_encode($flightNumbers); ?>, <?php echo json_encode(\request("flightNumber")); ?>, <?php echo json_encode($sectors); ?>, <?php echo json_encode($sectorsByAirlines); ?>, <?php echo json_encode(\request("sector")); ?>);
        <?php endif; ?>

        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            ApplyTableFilter("#table-<?php echo e($index); ?>");
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    };

    pagefunction();

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/aircraft-utilization/index.blade.php ENDPATH**/ ?>