<?php require_once(public_path("smart/inc/init.php")); ?>

<?php $envAirline = env(AIRLINE) ?>

        <!-- widget grid -->
<section id="widget-grid" class="bg-color-white">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <img src="<?php echo e($picture); ?>" style="max-height: 80px; padding: 10px;" />

            <div class="col-md-12">

                <ul id="tabStations" class="nav nav-tabs bordered">
                    <li class="<?php echo e(!\request("current_tab") ? "active" : ""); ?>">
                        <a href="#general" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.general"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "sla" ? "active" : ""); ?>">
                        <a href="#sla" role="tab" data-toggle="tab">SLA</a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "flights" ? "active" : ""); ?>">
                        <a href="#flights" role="tab" data-toggle="tab">FHR</a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "licenses" ? "active" : ""); ?>">
                        <a href="#licenses" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.licenses_approvals"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "approved_staff" ? "active" : ""); ?>">
                        <a href="#approved_staff" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.approved_staff"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "actypes" ? "active" : ""); ?>">
                        <a href="#actypes" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.subfleet"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "ac" ? "active" : ""); ?>">
                        <a href="#ac" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.aircraft"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "dl" ? "active" : ""); ?>">
                        <a href="#dl" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.delay_codes"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "fltno" ? "active" : ""); ?>">
                        <a href="#fltno" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.flight_numbers"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "sch" ? "active" : ""); ?>">
                        <a href="#sch" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.schedule"); ?></a>
                    </li>

                    <li class="<?php echo e(\request("current_tab") == "lbr" ? "active" : ""); ?>">
                        <a href="#lbr" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.library"); ?></a>
                    </li>

                    <?php if($envAirline == CAA): ?>
                        <li class="<?php echo e(\request("current_tab") == "flm" ? "active" : ""); ?>">
                            <a href="#flm" role="tab" data-toggle="tab"><?php echo app('translator')->get("modules.fleet_management"); ?></a>
                        </li>
                        <li class="<?php echo e(\request("current_tab") == "acm" ? "active" : ""); ?>">
                            <a href="#acm" role="tab" data-toggle="tab"><?php echo app('translator')->get("modules.ac_maintenance"); ?></a>
                        </li>
                    <?php endif; ?>

                </ul>

                <div id="tabContent" class="tab-content padding-10 background-white">

                    <?php $currentAirlineId = $airline->id ?>

                    <div class="tab-pane <?php echo e(!\request("current_tab") ? "active" : ""); ?>" id="general" style="min-height: 300px;">
                        <?php echo $__env->make("airline.layouts.show-general-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "sla" ? "active" : ""); ?>" id="sla" style="min-height: 300px;">
                        <?php echo $__env->make("airline-service.sla-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "flights" ? "active" : ""); ?>" id="flights" style="min-height: 300px;">
                        <?php echo $__env->make("airline.layouts.flights-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "licenses" ? "active" : ""); ?>" id="licenses" style="min-height: 300px;">
                        <?php echo $__env->make("airline-license.licenses-list", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "approved_staff" ? "active" : ""); ?>" id="approved_staff" style="min-height: 300px;">
                        <?php echo $__env->make("airline.layouts.staff-services-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "actypes" ? "active" : ""); ?>" id="actypes" style="min-height: 300px;">
                        <?php echo $__env->make("aircraft.list-aircraft-types", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "ac" ? "active" : ""); ?>" id="ac" style="min-height: 300px;">
                        <?php echo $__env->make("aircraft.list-aircraft", ["airlineID" => $airline->id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "dl" ? "active" : ""); ?>" id="dl" style="min-height: 300px;">
                        <?php echo $__env->make("delay-code.layouts.index-list-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "fltno" ? "active" : ""); ?>" id="fltno" style="min-height: 300px;">
                        <?php echo $__env->make("flight-number.flight-number-list", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "sch" ? "active" : ""); ?>" id="sch" style="min-height: 300px;">
                        <?php echo $__env->make("handling-flight-schedule.schedule-list", ["list" => $schedules], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane <?php echo e(\request("current_tab") == "lbr" ? "active" : ""); ?>" id="lbr" style="min-height: 300px;">
                        <?php echo $__env->make("airline.layouts.library-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <?php if($envAirline == CAA): ?>
                        <div class="tab-pane <?php echo e(\request("current_tab") == "flm" ? "active" : ""); ?>" id="flm" style="min-height: 300px;">
                            <?php echo $__env->make("fleet-management.layouts.list-aircraft", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="tab-pane <?php echo e(\request("current_tab") == "acm" ? "active" : ""); ?>" id="acm" style="min-height: 300px;">
                            <?php echo $__env->make("aircraft.layouts.maintenance-list", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    <?php endif; ?>


                </div>

            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

//    ApplyMultipleFormSubmit();

    var pagefunction = function() {

//        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#fhr-table", undefined, [[ 0, "asc" ], [ 4, "asc" ], ]);
        ApplyTableFilter("#table-services");
        ApplyTableFilter("#staff-services-table");
        ApplyTableFilter("#aircraft-type-table");
        ApplyTableFilter("#aircraft-table");
        ApplyTableFilter("#delays");
        ApplyTableFilter("#table-flight-numbers");
        ApplyTableFilter("#flight-schedule-table");

        ApplyTableFilter("#table-flights");

        ApplyFormSubmit();
    }

    pagefunction();

</script><?php /**PATH /home/avbis/public_html/coastal/resources/views/airline/show.blade.php ENDPATH**/ ?>