<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <?php echo $__env->make('general.tab-header', ['departmentName' => trans("content.staff"), 'moduleName' => \App\Models\User::getStation($user) . " | " . $user->first_name." ".$user->last_name], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="col-md-12">

                
                <ul class="nav nav-tabs" id="myTab">

                    <li class="<?php echo e(!\request("tab") || \request("tab") == "general" ? "active" : ""); ?>">
                        <a href="#general" data-toggle="tab">
                            <span class="tabText"><?php echo app('translator')->get("content.general"); ?></span>
                        </a>
                    </li>

                    <?php if($readAndSignPermission || $user->id == $authUser->id): ?>
                        <li class="<?php echo e(\request("tab") == "notifications" ? "active" : ""); ?>">
                            <a href="#notifications" data-toggle="tab">
                                <span class="tabText"><?php echo app('translator')->get("content.read_and_sign"); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if(ghaModule()): ?>
                        <li class="<?php echo e(\request("tab") == "services" ? "active" : ""); ?>">
                            <a href="#services" data-toggle="tab">
                                <span class="tabText"><?php echo app('translator')->get("content.services"); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="<?php echo e(\request("tab") == "licenses" ? "active" : ""); ?>">
                        <a href="#licenses" data-toggle="tab">
                            <span class="tabText"><?php echo app('translator')->get("content.licenses_approvals"); ?></span>
                        </a>
                    </li>

                    <li class="<?php echo e(\request("tab") == "modules" ? "active" : ""); ?>">
                        <a href="#modules" data-toggle="tab">
                            <span class="tabText"><?php echo app('translator')->get("content.modules_permissions"); ?></span>
                        </a>
                    </li>







                    <li class="<?php echo e(\request("tab") == "hours" ? "active" : ""); ?>">
                        <a href="#hours" data-toggle="tab">
                            <span class="tabText"><?php echo app('translator')->get("content.roster"); ?> / <?php echo app('translator')->get("content.hours"); ?></span>
                        </a>
                    </li>

                    
                    <li class="<?php echo e(\request("tab") == "leaves" ? "active" : ""); ?>">
                        <a href="#leaves" data-toggle="tab" title="welcome">
                            <span class="tabText"><?php echo app('translator')->get("content.office_duties"); ?> / <?php echo app('translator')->get("content.training"); ?></span>
                        </a>
                    </li>

                    <li class="<?php echo e(\request("tab") == "requests" ? "active" : ""); ?>">
                        <a href="#requests" data-toggle="tab" title="welcome">
                            <span class="tabText"><?php echo app('translator')->get("content.my_requests"); ?></span>
                        </a>
                    </li>

                    <li class="<?php echo e(\request("tab") == "leave_request" ? "active" : ""); ?>">
                        <a href="#leave_request" data-toggle="tab" title="welcome">
                            <span class="tabText"><?php echo app('translator')->get("content.leave_request"); ?></span>
                        </a>
                    </li>

                    
                        
                            
                            
                        
                    

                    <?php if($hasEmployees): ?>
                        <li class="<?php echo e(\request("tab") == "employees_requests" ? "active" : ""); ?>">
                            <a href="#employees_requests" data-toggle="tab" title="welcome">
                                <span class="tabText"><?php echo app('translator')->get("content.employees_requests"); ?></span>
                            </a>
                        </li>
                    <?php endif; ?>

                    <li class="<?php echo e(\request("tab") == "leave_entitlements" ? "active" : ""); ?>">
                        <a href="#leave_entitlements" data-toggle="tab" title="welcome">
                            <span class="tabText"><?php echo app('translator')->get("content.leave_entitlements"); ?></span>
                        </a>
                    </li>

                    <?php if(isSprAdm()): ?>
                        <li class="">
                            <a href="<?php echo e(route("homepage")."#system-log/user/{$user->id}"); ?>" target="_blank" class="bg-primary color-white">
                                History
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>

                
                <div class="tab-content">

                    
                    <div class="tab-pane bg-color-white <?php echo e(!\request("tab") || \request("tab") == "general" ? "active" : ""); ?>" id="general" style="padding: 15px !important; width: 100%; overflow: auto; ">

                        <div class="col-md-3 col-sm-5">
                            <!-- Current avatar -->
                            <?php echo $__env->make('forms/general/upload-picture', ['postUrl' => url("user/upload/{$userId}")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        </div>

                        <div class="col-md-9 col-sm-7">
                            <ul class="nav nav-pills" id="generalSubItems">
                                <li class="active">
                                    <a href="#general-tab-info" data-toggle="tab"><?php echo app('translator')->get("content.info"); ?></a>
                                </li>
                                <li class="">
                                    <a href="#general-tab-details" data-toggle="tab"><?php echo app('translator')->get("content.details"); ?></a>
                                </li>



                            </ul>

                            <div class="tab-content" style="background: #e3e3e3; margin-top: 10px;">
                                
                                <div class="tab-pane active bg-color-white editable_div" id="general-tab-info" style="">

                                    <?php echo $__env->make('staff.layouts.general-info-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                </div>

                                <div class="tab-pane bg-color-white editable_div" id="general-tab-details" style="">

                                    <?php echo $__env->make('staff.layouts.general-details-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                </div>





                            </div>
                        </div>
                    </div>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "notifications" ? "active" : ""); ?>" id="notifications" style="padding: 15px !important; width: 100%; overflow: auto;">
                        <?php echo $__env->make("user-notifications.layouts.index-list", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "services" ? "active" : ""); ?>" id="services" style="padding: 15px !important; width: 100%; overflow: auto;">
                        <?php echo $__env->make("staff.layouts.services-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "licenses" ? "active" : ""); ?>" id="licenses" style="padding: 15px !important; width: 100%; ">
                        <?php echo $__env->make("staff.layouts.licenses-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "modules" ? "active" : ""); ?>" id="modules" style="padding: 15px !important; width: 100%; ">
                        <?php echo $__env->make("staff.layouts.modules-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>





                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "hours" ? "active" : ""); ?>" id="hours" style="padding: 15px !important; width: 100%; ">
                        <?php echo $__env->make("staff.layouts.edit-hours-tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    
                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "leaves" ? "active" : ""); ?>" id="leaves" style="padding: 15px !important; width: 100%; overflow: auto;">
                        <ul class="nav nav-pills" id="officeDutiesTab">
                            <li class="active">
                                <a href="#leaves_edit_tab" data-toggle="tab"><?php echo app('translator')->get("content.export"); ?></a>
                            </li>
                            <li class="">
                                <a href="#leaves_show_tab" data-toggle="tab"><?php echo app('translator')->get("content.edit"); ?></a>
                            </li>
                        </ul>

                        <div class="tab-content" style="background: #e3e3e3; margin-top: 10px;">
                            
                            <div class="tab-pane active bg-color-white" id="leaves_edit_tab" style="">
                                <?php echo $__env->make('user.show-leaves-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="tab-pane bg-color-white" id="leaves_show_tab" style="">
                                <?php echo $__env->make('user.edit-leaves-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "requests" ? "active" : ""); ?>" id="requests" style="padding: 15px !important; width: 100%; overflow: auto;">
                        <?php echo $__env->make('user.show-my-requests-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "leave_request" ? "active" : ""); ?>" id="leave_request" style="padding: 15px !important; width: 100%; overflow: auto;">
                        <?php echo $__env->make('user.request-leave-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "duty_travel_request" ? "active" : ""); ?>" id="duty_travel_request" style="padding: 15px !important; width: 100%; overflow: auto;">
                        <?php echo $__env->make('user.show-duty-travel-request-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>

                    <?php if($hasEmployees): ?>
                        <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "employees_requests" ? "active" : ""); ?>" id="employees_requests" style="padding: 15px !important; width: 100%; overflow: auto;">
                            <?php echo $__env->make('user.show-employees-requests-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    <?php endif; ?>

                    <div class="tab-pane bg-color-white <?php echo e(\request("tab") == "leave_entitlements" ? "active" : ""); ?>" id="leave_entitlements" style="padding: 15px !important; width: 100%; overflow: auto;">
                        <?php echo $__env->make('user.show-leave-entitlements', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>

            </div>
        </article>

    </div>

    <div id="details_modal" class="modal fade" role="dialog">
        <div class="modal-dialog" style="width: 80%;">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title" id="modal_title">Details</h4>
                </div>
                <div class="modal-body">
                </div>
            </div>
        </div>
    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var EDIT = "Edit", SAVE = "Save";

    Initialize_DateRangePicker();

    var pagefunction = function () {

        ApplyMultipleFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        // ApplyTableFilter(".table-filter");
        ApplyTableFilter(".roster_table", undefined, [[ 5, "asc" ]]);

        // ApplySpecificFormSubmit($(".application-forms"));
        // ApplyFormSubmit();

        // ApplyTableFilter(".export_table");
        // ApplyTableFilter(".apply_filter");
        ApplyTableFilter("#notificationsTable");
        ApplyTableFilter("#rosterTable");
        ApplyTableFilter("#officeDutiesTable");
        ApplyTableFilter("#totalHoursTable");
        ApplyTableFilter("#dailyHoursTable");
        ApplyTableFilter("#monthlyHoursTable");
        ApplyTableFilter("#yearlyHoursTable");
        ApplyTableFilter("#entitlementTable");
        ApplyTableFilter("#showEntitlementTable");
    };

    $(document).ready(function () {
        $(document).on('click', 'form button.edit', function () {
            var _this = $(this), form = _this.closest("form"), state = form.attr("data-state"), labels = form.find("label.checkbox"),
                tr = form.find("tr"), inputs = form.find("input[type=checkbox]"),
                cancelBtn = form.find("button.cancel"), saveBtn = form.find("input.save");

            switch (state) {
                case EDIT:
                    form.attr("data-state", SAVE);
                    labels.removeClass("state-disabled");
                    inputs.removeAttr("disabled");
                    tr.addClass("selected-row");

                    _this.hide();
                    cancelBtn.show();
                    saveBtn.show();
                    return false;

                case SAVE:
                    return true;
            }

        }).on("click", "form button.cancel", function () {

            var _this = $(this), form = _this.closest("form"), state = form.data("state"), labels = form.find("label.checkbox"),
                tr = form.find("tr"), inputs = form.find("input[type=checkbox]"), saveBtn = form.find("input.save"),
                editBtn = form.find("button.edit");

            form.attr("data-state", EDIT);
            labels.addClass("state-disabled");
            inputs.attr("disabled", "disabled");
            tr.removeClass("selected-row");

            editBtn.show();
            _this.hide();
            saveBtn.hide();

        });


        $(document)
            .on('click', 'form button.edit_all', function () {
                var _this = $(this), form = _this.closest("form"), state = form.attr("data-state"), labels = form.find("label.checkbox"),
                    tr = form.find("tr").not("[data-category=1]"), inputs = form.find("input[type=checkbox]"),
                    cancelBtn = form.find("button.cancel_all"), saveBtn = form.find("input.save_all"),
                    selectAllBtn = form.find("button.select_all"),deselectAllBtn = form.find("button.deselect_all");

                switch (state) {
                    case EDIT:
                        form.attr("data-state", SAVE);
                        labels.removeClass("state-disabled");
                        inputs.removeAttr("disabled");
                        tr.addClass("selected-row");

                        _this.hide();
                        cancelBtn.show();
                        saveBtn.show();
                        selectAllBtn.show();
                        deselectAllBtn.show();
                        return false;

                    case SAVE:
                        return true;
                }
            })
            .on("click", "form button.cancel_all", function () {

            var _this = $(this), form = _this.closest("form"), state = form.data("state"), labels = form.find("label.checkbox"),
                tr = form.find("tr").not("[data-category=1]"), inputs = form.find("input[type=checkbox]"), saveBtn = form.find("input.save_all"),
                editBtn = form.find("button.edit_all"),
                selectAllBtn = form.find("button.select_all"),deselectAllBtn = form.find("button.deselect_all");


            form.attr("data-state", EDIT);
            labels.addClass("state-disabled");
            inputs.attr("disabled", "disabled");
            tr.removeClass("selected-row");

            editBtn.show();
            _this.hide();
            saveBtn.hide();
            selectAllBtn.hide();
            deselectAllBtn.hide();

        }).on("click", "form button.select_all", function () {

            var _this = $(this), form = _this.closest("form"),
                inputs = form.find("input[type=checkbox]"),
                deselectAllBtn = form.find("button.deselect_all");

            inputs.prop("checked", "checked");

            //        deselectAllBtn.show();
            //        _this.hide();

        }).on("click", "form button.deselect_all", function () {

            var _this = $(this), form = _this.closest("form"),
                inputs = form.find("input[type=checkbox]"),
                selectAllBtn = form.find("button.select_all");

            inputs.removeAttr("checked");

            //        selectAllBtn.show();
            //        _this.hide();

        }).on("click", "a.airline_select_all", function () {

            var _this = $(this), form = _this.closest("form"),
                inputs = _this.parents("tr").find("input[type=checkbox]");

            if (form.attr("data-state") == SAVE) {
                if (!_this.attr("data-checked")) {
                    inputs.prop("checked", "checked");
                    _this.attr("data-checked", 1);
                } else {
                    inputs.removeAttr("checked");
                    _this.attr("data-checked", 0);
                }
            }
        })
        .on("click", "a.service_select_all", function () {

            var _this = $(this), serviceID = _this.data("id"), form = _this.closest("form"),
                inputs = _this.parents(".services_table").find(".airline_services[data-service_id=" + serviceID +"] input[type=checkbox]");

            if (form.attr("data-state") == SAVE) {
                if (!_this.attr("data-checked")) {
                    inputs.prop("checked", "checked");
                    _this.attr("data-checked", 1);
                } else {
                    inputs.removeAttr("checked");
                    _this.attr("data-checked", 0);
                }
            }
        });

        $(document).on('click', 'td.status-prev', function () {
            var _this = $(this), parent = _this.parent(), find_details = parent.nextUntil("tr.request").filter('tr.details');

            if (find_details.is(":visible")){
                find_details.hide();
            }
            else {
                find_details.show();
            }
        });


        var details_modal = $("#details_modal");

        $(document).on('click', 'td.status', function () {
            var _this = $(this), objID = _this.parent().attr("data-request-id"),
                parent = _this.parents(".tab-pane"),
                // all_details = parent.find("div.details"),
                find_details = parent.find("div.details.request-"+ objID),
                title = find_details.data("title");
                // parent = _this.parent(),
                // find_details = parent.nextUntil("tr.request").filter('tr.details')
            ;

            var data = find_details.clone();

            details_modal.find("#modal_title").html(title);
            details_modal.find(".modal-body").children().remove();
            details_modal.find(".modal-body").append(data);
            data.show();
            details_modal.modal('toggle');

            // if (find_details.is(":visible")){
            //     find_details.hide();
            // }
            // else {
            //     find_details.show();
            // }
        });

        $(document).on('click', 'button.hide-modify-form', function () {
            var _this = $(this), modify_form = _this.parents('div.modify_form');
            modify_form.hide();
        });


        $(document).on('click', 'button.modify', function () {
            var _this = $(this), parent = _this.parents('tr.request'), date_from = parent.find('td.date_from'),
                date_to = parent.find('td.date_to'),
                modify_form = $(document).find('div.modify_form'),
                periodInput = modify_form.find('input.daterangepicker-from-now'),
                leaveId = parent.attr('data-leave-id'),
                start = moment(date_from.text(), "DD MMM YY").toDate(),
                end = moment(date_to.text(), "DD MMM YY").toDate(),
                leaveIdInput = modify_form.find('select[name=leave_id]').val(leaveId),
                leaveRequestId = parent.attr('data-request-id'),
                leaveRequestIdInput = modify_form.find('input[type=hidden][name=leave_request_id]');

            if (modify_form.is(":visible")){
                if (leaveRequestIdInput.val() == leaveRequestId){
                    modify_form.hide();

                }
                else {
                    leaveRequestIdInput.val(leaveRequestId);
                    leaveIdInput.multiselect('rebuild');
                    periodInput.daterangepicker("setRange", {start: start, end: end});
                }
            }
            else {
                leaveIdInput.multiselect('rebuild');
                leaveRequestIdInput.val(leaveRequestId);
                periodInput.daterangepicker("setRange", {start: start, end: end});
                modify_form.show();
            }
        });

        var btnUpload = $(document).find("input[name=upload]"),
            btnDelete = $(document).find("input[name=delete]");

        $(document).on('click', 'a.edit-update', function () {
            $(this).parents("tr").find(".upload-container").toggle(400, function () {
                $(this).val(($(this).is(":visible")) ? "1" : "0");
            });
        });
    });

    loadScript("<?php echo e(asset("/assets/js/views/user/edit.js?6")); ?>", pagefunction);

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/staff/edit.blade.php ENDPATH**/ ?>