<?php echo Form::open(['method' => 'POST', 'class' => 'form-horizontal', 'url' => url("staff-report?tab=hours") ]); ?>

<div class="col-sm-12 margin-bottom-10">
    <label><?php echo app('translator')->get("content.airport"); ?> </label>

    <div class="btn-group margin-right-20">
        <?php echo Form::select('airport', $airports, \request("airport"), ['class'=>'singleselect', 'id'=>'airport']); ?>

    </div>



    <?php if(env(MULTIPLE_AIRLINE)): ?>
        <label><?php echo app('translator')->get("content.airline"); ?> </label>

        <div class="btn-group margin-right-20">
            <?php echo Form::select('airline[]', $airlines, \request("airline"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'airline']); ?>

        </div>
    <?php endif; ?>

    <label>SLA </label>
    <?php echo Form::select('service_id[]', $services, $selectedServices, [ 'multiple' => 'multiple', 'class'=>'form-control multiselect_search']); ?>


    <label><?php echo app('translator')->get("content.flight_number"); ?> </label>

    <div class="btn-group margin-right-20">
        <?php if(is_array($flightNumbers)): ?>
            <?php echo Form::select('flightNumber[]', $flightNumbers, \request("flightNumber"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id' => 'flight_number']); ?>

        <?php else: ?>
            <select name="flightNumber[]" class="multiselect_search" id="flight_number" multiple>
                <?php $__currentLoopData = $flightNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($each->id); ?>" <?php echo \request("flightNumber") && in_array($each->id, \request("flightNumber")) ? "selected" : ""; ?> data-airline_id ="<?php echo e($each->airline_id); ?>"><?php echo e($each->sector); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        <?php endif; ?>
    </div>

    <label for="report_type" class="control-label"><?php echo app('translator')->get("content.report_type"); ?></label>
    <div class="btn-group margin-right-20">
        <div class="btn-group">
            <?php echo Form::select('report_type', $reportTypes, \request("report_type"), ['required', 'class'=>'singleselect', 'id'=>'']); ?>

        </div>
    </div>

</div>

<div class="col-sm-12">
    <label for="export_ba_report" class="control-label">Export & BA Report</label>
    <div class="btn-group margin-right-10">
        <?php echo Form::checkbox('export_ba_report', 1, null, ['class'=>'form-control']); ?>

    </div>








    <label><?php echo Form::radio('dateSearch','fromTo', !\request("dateSearch") || \request("dateSearch") == 'fromTo'); ?> <?php echo app('translator')->get("content.from"); ?></label>
    <div class="btn-group margin-right-20">
        <?php echo Form::text('dateFrom', !\request("dateSearch") ? $dateToday : \request("dateFrom"), ['class'=>'form-control dateFrom myinput', 'placeholder'=>'From Date', 'id'=>'from_date']); ?>

    </div>

    <label form="dateTo"><?php echo app('translator')->get("content.to"); ?></label>
    <div class="btn-group margin-right-20">
        <?php echo Form::text('dateTo', !\request("dateSearch") ? $dateToday : \request("dateTo"), ['class'=>'form-control dateTo myinput', 'placeholder' => 'To Date', 'id'=>'to_date']); ?>

    </div>

    <label><?php echo Form::radio('dateSearch','monthYear', \request("dateSearch") == 'monthYear'); ?> <?php echo app('translator')->get("content.month"); ?></label>
    <div class="btn-group margin-right-20">
        <?php echo Form::select('month[]', $monthNames, \request("month"), ['multiple'=>'multiple', 'class'=>'multiselect_search', 'id'=>'month']); ?>

    </div>

    <label for="year" class="control-label"><?php echo app('translator')->get("content.year"); ?></label>
    <div class="btn-group margin-right-20">
        <?php echo Form::select('year', $years, getSelectedYear(), ['class'=>'singleselect', 'id'=>'period']); ?>

    </div>

    <label for="period" class="control-label"><?php echo app('translator')->get("content.period"); ?></label>
    <div class="btn-group margin-right-20">
        <?php echo Form::select('period', $periods, \request("period"), ['class'=>'multiselect_search']); ?>

    </div>


    <div class="btn-group">
        <?php echo Form::submit("Submit", ["class" => "btn btn-primary btn-sm"]); ?>


    </div>
</div>

<?php echo Form::close(); ?>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/staff-report/layouts/index-hours-form.blade.php ENDPATH**/ ?>