<?php

//initialize the page
require_once(public_path("smart/inc/init.php"));

//require UI configuration (nav, ribbon, etc.)
require_once(public_path("smart/inc/config.ui.php"));

include_once(public_path("smart/inc/user_variables.php"));


/*---------------- PHP Custom Scripts ---------

YOU CAN SET CONFIGURATION VARIABLES HERE BEFORE IT GOES TO NAV, RIBBON, ETC.
E.G. $page_title = "Custom Title" */

$page_title = trans("modules.flight_watch");

/* ---------------- END PHP Custom Scripts ------------- */

//include header
//you can add your custom css in $page_css array.
//Note: all css files are inside css/ folder
$page_css[] = "your_style.css";

$no_main_header = true;

$page_body_prop = array("id"=>"extr-page", "class"=>"animated fadeInDown");

include(public_path("smart/inc/header.php"));

?>

<style>
    span.item {
        display: inline-block;
        margin-top: 8px;
    }
    div.fleetwatch_form .form-control{
        font-size: 14px !important;
    }
    div.fleetwatch_form select.crew{
        max-width: 200px !important;
    }
    div.fleetwatch_form label{
        font-size: 14px !important;
    }
    body{
        background-color: #FFFFff;
    }
    .form-inline input[type="text"],
    .form-inline input[type="email"],
    .form-inline select {
        margin-right: 10px;
        max-width: 160px;
    }
    #mytimeline .ui-widget-content {
        background: #FFF;
    }
    .message-item > pre {
        max-width: 890px;
    }

    div.timeline-groups-text{
        font-weight: bold;
    }

    a.left_sidebar:hover{
        cursor: pointer !important;
    }
    th.checkbox-column:hover{
        cursor: pointer !important;
    }

    #header_container{
        display: flex;
        flex-flow: row;
        width: 100%;
        padding: 20px 30px;
    }

    #airports_airlines_group {
        display: flex;
        flex-flow: column;
        flex-grow: 1;
        justify-content: center;
    }

    #airports_container{
        display: flex;
        justify-content: center;
    }

    #airports_container > a{
        margin-right: 5px;
    }

    #airlines_container{
        display: flex;
        justify-content: center;
        flex-wrap: wrap;
    }

    #airlines_container > a, #airlines_container > img{
        margin: 2px;
    }

    /*Time container*/
    #form_and_time_container{
        margin: 10px;
        display: flex;
        flex-flow: row;
        width: 100%;
    }

    #time_container{
        flex-grow: 1;
        flex-flow: column;
        justify-content: center;
    }

    #logo-group{
        margin-right: 30px;
    }

    .flight-form {
        width: 100%;
        flex-direction: row;
        align-items: center;
        display: flex;
        padding: 10px;
        text-align: center;
        flex-wrap: wrap;
    }

    .flight-form input {
        display: block;
        padding: 6px 12px;
        font-size: 13px;
        color: #555;
        background-color: #fff;
        background-image: none;
        min-width: 0;
        border: 1px solid #ccc;
    }

    .info-box input.width-50{
        padding: 5px;
        width: 50px !important;
    }
    .p-0{
        padding: 0 !important;
    }
    .fg-1{
        flex-grow: 1;
    }
    .fg-2{
        flex-grow: 2;
    }
    .fg-3{
        flex-grow: 3;
    }
    .fg-4{
        flex-grow: 4;
    }
    .fg-5{
        flex-grow: 5;
    }
    .box-grow{
        display: flex;
    }
    .box-grow > *{
        flex-grow: 1;
    }
    .box-grow > *:not(:last-child) {
        margin-right: 10px;
    }

    .box-column{
        display: flex;
        flex-direction: column;
        flex-wrap: wrap;
    }
    .box-column.margin-bottom-5 > *{
        margin-bottom: 5px;
    }

    .box,
    .box-column
    {
        display: flex;
        flex-wrap: wrap;
    }

    .box-nowrap{
        flex-wrap: nowrap !important;
        display: flex;
    }

    .box:not(.table-bordered) > *,
    .box-column:not(.table-bordered) > *,
    .box-nowrap:not(.table-bordered) > *
    {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
        margin: 5px;
    }

    .box input[type=text]:not(.datetimepicker, .width-50), .box select,
    .box-column input[type=text]:not(.datetimepicker, .width-50), .box-column select,
    .box-grow input[type=text]:not(.datetimepicker, .width-50), .box-grow select,
    label.width-80
    {
        flex-basis: 80px !important;
        min-width: 80px !important;
    }

    label.width-50
    {
        flex-basis: 50px !important;
        min-width: 50px !important;
    }

    .box input.datetimepicker,
    .box-column input.datetimepicker,
    .box-grow input.datetimepicker
    {
        width: 150px !important;
    }

    .align-items-center{
        align-items: center;
    }
    .justify-content-center{
        justify-content: center;
    }

    .min-70{
        min-width: 70px !important;
    }

    .box-bordered{
        border: 2px solid #868686;
        border-radius: 15px;
    }
    .color-dark-blue > *,
    .color-dark-blue
    {
        color: #11237c
    }
    .color-dark-red > *,
    .color-dark-red
    {
        color: #ac0909
    }
    .my-0{
        margin-top: 0 !important;
        margin-bottom: 0 !important;
    }
    .mx-1{
        margin-left: 10px;
        margin-right: 10px;
    }
    .box.item-delay{
        width: 270px;
        margin: 5px 0;
    }
</style>


<div id="header_container">
    <div id="logo-group" style="<?php echo e($div_external_page); ?>">
        <img style="<?php echo e($logo_external_page); ?>" src="<?php echo e($logo_fw); ?>"  alt="Logo">
        <h2 style="<?php echo e($logo_text_external_page); ?>"><?php echo e($logo_text); ?></h2>
        <!-- END AJAX-DROPDOWN -->
    </div>

    <?php if(env(CARRIER) == HANDLING): ?>
        <div id="airports_airlines_group">
            <?php if(count($handlingAirports) > 1): ?>
                <div id="airports_container">
                    <a id="all_stations" style="cursor:pointer;  margin-bottom: 5px;" class="btn btn-success font-md quick-airports <?php echo e(!count($staffStations) ? "btn-warning" : ""); ?>" data-id="">ALL</a>
                    <?php $__currentLoopData = $handlingAirports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array($id, $staffStations)): ?>
                            <a style="cursor:pointer; margin-bottom: 5px;" class="btn btn-primary font-md quick-airports <?php echo e(in_array($id, $staffStations) ? "btn-warning" : ""); ?>" data-id="<?php echo e($id); ?>"><?php echo e($each); ?></a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <?php if(!$isMobile && count($handlingAirlines) > 1): ?>
                <div id="airlines_container">
                    <a id="all_airlines" style="cursor:pointer;" class="btn btn-success font-sm quick-airlines <?php echo e(!count($staffAirlines) ? "selected" : ""); ?>" data-id="">ALL</a>
                    <?php $__currentLoopData = $handlingAirlines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(in_array($id, $staffAirlines)): ?>
                            <img style="cursor:pointer;"  data-id="<?php echo e($id); ?>" class="header-airline-logo quick-airlines <?php echo e(in_array($id, $staffAirlines) ? "selected" : ""); ?>" src="<?php echo e(asset("storage/airlines/img/{$each}")); ?>" />
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<div class="clearfix"></div>

<div id="main" role="main" style="padding: 0 10px !important;">

    <!-- MAIN CONTENT -->
    <div id="content" class="">

        <?php echo $__env->make('general.tab-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div id="form_and_time_container">

            <div id="form_container">
                <?php echo Form::open(["method"=>"get", "id"=>"go_to_date_form", 'class' => 'form-inline']); ?>

                <button id="btn_prev_date" style="font-size:18px; padding: 0 10px; margin-right: 5px;" class="floatOnly btn btn-primary"><?php echo e(LEFT_ARROW); ?></button>
                <?php echo Form::input("text", "go_to_date", \request()->get("go_to_date") ? \request()->get("go_to_date") : date("Y-m-d"), ["class"=>"form-control height27 floatOnly date fleetwatch-input-date margin-right-5", "placeholder"=>"Date", "id"=>"go_to_date"]); ?>

                <button id="btn_next_date" style="font-size:18px; padding: 0 10px; margin-right: 5px;" class="floatOnly btn btn-primary"><?php echo e(RIGHT_ARROW); ?></button>
                
                
                <?php echo Form::submit("Submit", [ "id" => "btn_go_to_date", "class" => "btn btn-primary"]); ?>

                <span style="font-size: 11px; color: #5f5f5f; display: none; margin-left: 20px;" id="loading-fleetwatch-data">
                        <img width="24" src="<?php echo e(asset("/assets/img/2.GIF")); ?>" alt="Loading..."/>
                    </span>
                <?php echo Form::close(); ?>


            </div>

            <div id="time_container" class="text-center">
                <span class="timeNow"><?php echo app('translator')->get("content.today"); ?>: <?php echo gmdate('D, d M Y'); ?></span>
                <h4 class="timeNow" style="color: #ff0400"><?php echo app('translator')->get("content.time_now"); ?>:<span class="timeNow" id="timeNow" style="color: #ff0400"></span></h4>
            </div>
        </div>

        <div id="fleetwatch_message_block" style="clear: both"></div>

        <!-- Fleet watch timeline -->
        <div id="mytimeline" style="min-height: 50px;  min-width: 950px; width: 100%; margin-bottom: 20px;"></div>

        <div class="col-sm-12">
            <span class="color_item"><span class="flight_color available"></span> - <?php echo app('translator')->get("content.scheduled"); ?></span>
            <span class="color_item"><span class="flight_color on_time"></span> - <?php echo app('translator')->get("content.on_time"); ?></span>
            <span class="color_item"><span class="flight_color delayed"></span> - <?php echo app('translator')->get("content.delayed"); ?></span>
            <span class="color_item"><span class="flight_color et_delayed"></span> - ETD/ETA</span>
            <span class="color_item"><span class="flight_color diversion"></span> - <?php echo app('translator')->get("content.diversion"); ?></span>
            <span class="color_item"><span class="flight_color created_by_email"></span> - <?php echo app('translator')->get("content.auto_created"); ?></span>
            <span class="color_item"><span class="flight_color edited_by_email"></span> - <?php echo app('translator')->get("content.auto_edited"); ?></span>
            <span class="color_item"><span class="flight_color edited"></span> - <?php echo app('translator')->get("content.schedule_update"); ?></span>
            <span class="color_item"><span class="flight_color manually_created"></span> - <?php echo app('translator')->get("content.manually_created"); ?></span>
            

            <span style="display: none; margin-left: 20px;" id="loading-fleetwatch-form">
                <img width="24" src="<?php echo e(asset("/assets/img/2.GIF")); ?>" alt="Loading..."/> Loading, please wait...
            </span>
        </div>

        <div class="clearfix"></div>

        <hr/>

        <!--------Crew Hours Info Modal------------>
        

        <!-------- Include Flight Form ---------------->
        <?php echo $__env->make("flight-watch.templates.form", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Include Flight modal information window -->
        <?php echo $__env->make("flight-watch.templates.modal_info", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Include Flight maintenance modal window -->
        <?php echo $__env->make("flight/modal_maintenance_info", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>

</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<script type="text/javascript">
    var baseUrl = "<?php echo e(url('/')); ?>";
    var baseDashboardUrl = "<?php echo e(url('home/dashboard')); ?>";
    var baseHomeUrl = "<?php echo e(route("homepage")); ?>";
    var AIRLINE = "<?php echo e(env("AIRLINE")); ?>";
    var CARRIER = "<?php echo e(env("CARRIER")); ?>";
    var CURRENT_IATA_CODE = "<?php echo e(env("IATA_CODE")); ?>";

    var ETD = 'ETD';
    var ATD = 'ATD';
    var ABN = 'ABN';
    var ETA = 'ETA';
    var ATA = 'ATA';
    var TDN = 'TDN';

    var LDS = 'LDS';
    var MVT = 'MVT';
    var CPM = 'CPM';
    var LDM = 'LDM';
    var LPM = 'LPM';
    var PSM = 'PSM';
    var PTM = 'PTM';
    var UCM = 'UCM';
    var TPM = 'TPM';
    var PL = 'PL';
    var PNL = 'PNL';
    var PRL = 'PRL';
    var ADL = 'ADL';
    var NOT = 'NOT';
    var SLS = 'SLS';
    var HBG = 'HBG';
    var LIR = 'LIR';
    var CAL = 'CAL';
    var CREW_LIST = 'CREW LIST';
    var NOTOC = 'NOTOC';
    var OTHS = 'OTHS';
    var ONLOAD = 'ONLOAD';
    var LOADSHEET = "L O A D S H E E T";
    var LOADSHEET_FINAL = "LOADSHEET FINAL";

</script>

<?php include(public_path("smart/inc/scripts.php")); ?>

<link rel="stylesheet" href="<?php echo e(asset("/assets/timeline/timeline.css?5")); ?>" />
<link rel="stylesheet" href="<?php echo e(asset("/assets/timeline/timeline-theme.css?5")); ?>" />
<link rel="stylesheet" href="<?php echo e(asset("/packages/ionicons/css/ionicons.min.css")); ?>" />

<script src="<?php echo asset("/assets/js/vendor/underscore-min.js"); ?>"></script>

<script src="<?php echo e(asset("/assets/js/vendor/bootstrap-tooltip.js")); ?>"></script>
<script type="text/javascript">

    pageSetUp();

    var $airlineModule = <?php echo e($airlineModule ? 1 : 0); ?>,
        $groupsWidth = "<?php echo e($airlineModule ? "130px" : "100px"); ?>",
        $timelinePeriod = <?php echo e($airlineName == COASTAL ? 12 : 24); ?>,
        $userAnyAdmin = <?php echo e(userAnyAdmin()); ?>,
        airportId = "<?php echo e(\request()->get("airport_id")); ?>",
        airlineId = "<?php echo e(\request()->get("airline_id")); ?>",
        editable = 1; //isset($userModules) && isset($module) && isset($userModules[$module->id]) && in_array(10,$userModules[$module->id]) ? 1 : 0
    json = <?php echo $json; ?>,
        goToDate = '<?php echo e((\request()->get("go_to_date")) ? date('D M d Y H:i:s O', strtotime(\request()->get("go_to_date"))) : false); ?>',
        startVisibleDate = '<?php echo (\request()->get("start_time")) ? \request()->get("start_time") : false; ?>',
        endVisibleDate = '<?php echo (\request()->get("end_time")) ? \request()->get("end_time") : false; ?>',

        aircraftByAirline = <?php echo json_encode($aircraftByAirline); ?>,
        acTypesByAirline = <?php echo json_encode($acTypesByAirline); ?>,
        flightNumbersObj = <?php echo json_encode($flightNumbersObj); ?>,
        aircraftByType = <?php echo json_encode($aircraftByType); ?>


    // Tooltip
    $("[data-toggle='tooltip']").popover({ trigger: "hover" });

</script>


<script type="text/javascript" src="https://www.google.com/jsapi"></script>

<script src="<?php echo e(asset("/assets/timeline/timeline.js")); ?>"></script>
<script src="<?php echo e(asset("/assets/js/views/operation/timeline.js?189")); ?>"></script>
<script src="<?php echo e(asset("/assets/js/vendor/jquery.bpopup.min.js")); ?>"></script>
<script src="<?php echo e(asset("/assets/js/vendor/jquery.datetimepicker.js")); ?>"></script>
<script src="<?php echo e(asset("/assets/js/vendor/select-sync-mine.js")); ?>"></script>
<script src="<?php echo e(asset("/assets/js/views/operation/form.js?187")); ?>"></script>

<script type="text/javascript">

    runAllForms();

    ApplySpecificFormSubmit($(document).find("#formParseMessages"));
    //    ApplySpecificFormSubmit($(document).find("#formMVTDeparture"));
    //    ApplyFormInputSubmit("#formMVTArrival");

    ApplyTableFilter("#tableFltDepartures");
    ApplyTableFilter("#tableFltArrivals");
    ApplyTableFilter("#tableFltAll");

    ApplyTableFilter("#flightMessages");
    
    

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-watch/index.blade.php ENDPATH**/ ?>