<?php require_once(public_path("smart/inc/init.php")); ?>

        <!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

            <?php echo $__env->make('general.tab-header', ['departmentName' => trans("content.admin"), 'moduleName' => trans("content.module_mapping")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div>

            <?php if(Session::get("message")): ?>
            <?php $message = Session::get("message"); ?>
            <div class="alert alert-<?php echo $message["type"]; ?>">
                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span><span class="sr-only"><?php echo app('translator')->get("content.add_new"); ?>Close</span></button>
                <h4><?php echo $message["title"]; ?></h4>
                <p><?php echo $message["text"]; ?></p>
            </div>
            <?php endif; ?>

            <div id="notification-block"></div>

            <?php if(isset($departments) && count($departments)): ?>
            <div class="row">
                <div class="col-sm-7">
                    <table class="table table-responsive">
                        <tr>
                            <th><?php echo app('translator')->get("content.department_name"); ?></th>
                            <th><?php echo app('translator')->get("content.list_of_modules"); ?></th>
                        </tr>
                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department_id => $department_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $i = 0?>
                        <tr>
                            <td style="width: 250px"><?php echo $department_name; ?></td>
                            <td>
                                <table class="table table-bordered table-striped table-hover" <?php echo ($department_id == 0) ? 'id="home_table"' : ''; ?>>
                                <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($module->department_id == $department_id): ?>
                                        <?php if($i == 0): ?>
                                        <thead>
                                            <tr class="header-tr">
                                                <th><?php echo app('translator')->get("content.name"); ?></th>
                                                <th><?php echo app('translator')->get("content.actions"); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php endif; ?>

                                        <tr>
                                            <td style="width: 200px"><?php echo $module->name; ?></td>
                                            <td>
                                                <?php if($department_id != 0): ?>
                                                <button data-department-id="<?php echo $department_id; ?>" data-module-id="<?php echo $module->id; ?>" type="button" class="btn btn-sm remove-button btn-danger"><?php echo app('translator')->get("content.remove"); ?></button>
                                                <?php endif; ?>
                                                <button data-department-id="<?php echo $department_id; ?>" data-module-id="<?php echo $module->id; ?>" type="button" class="btn btn-sm edit-button btn-primary"><?php echo app('translator')->get("content.edit"); ?></button>
                                            </td>
                                        </tr>
                                        <?php $i++?>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                </table>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </table>
                </div>
            </div>
            <?php endif; ?>
            <a class="btn-sm btn btn-default" href="<?php echo route("homepage")."#". url("module"); ?>"><?php echo app('translator')->get("content.back"); ?></a>

            </div>

        </article>

    </div>

</section>


<script type="text/javascript">

    pageSetUp();

    var structure__departments = <?php echo json_encode($departments); ?>;

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter("#table");
    };

    loadScript("<?php echo e(asset("/assets/js/views/module/map.js")); ?>", pagefunction);

</script>
<?php /**PATH /home/avbis/public_html/coastal/resources/views/module/map.blade.php ENDPATH**/ ?>