<?php $currentAirlineId = isset($currentAirlineId) ? $currentAirlineId : '' ?>

<div class="col-md-12 no-padding margin-bottom-10">
    <a target="_blank" href="<?php echo e(route("homepage")."#". url("flight-number/create?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}")); ?>" class="btn btn-primary"><?php echo app('translator')->get("content.add_new_flight_number"); ?></a>
</div>

<div class="clearfix"></div>

<?php if(count($flightNumbers)): ?>

    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-online" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false">

    <header>
        <span class="widget-icon"> <i class="fa fa-table"></i> </span>

        <h2><?php echo app('translator')->get("content.list"); ?></h2>
    </header>

    <!-- widget div-->
    <div class="editable_div">

        <!-- widget edit box -->
        <div class="jarviswidget-editbox">
            <!-- This area used as dropdown edit box -->

        </div>
        <!-- end widget edit box -->

        <!-- widget content -->
        <div class="widget-body no-padding" style="min-height: 50px !important;">

            <div class="table-responsive">

                <table class="table table-bordered table-hover" id="table-flight-numbers" style="min-width: 100% !important;">
                    <thead>
                    <tr>
                        <th>No</th>
                        <th><?php echo app('translator')->get("content.airline"); ?></th>
                        
                        <th><?php echo app('translator')->get("content.flight_number"); ?></th>
                        <th>SVC TYPE</th>
                        <th>ATC C/S</th>
                        <th><?php echo app('translator')->get("content.departure_airport"); ?></th>
                        <th><?php echo app('translator')->get("content.arrival_airport"); ?></th>
                        <th><?php echo app('translator')->get("content.direction"); ?></th>
                        <th><?php echo app('translator')->get("content.duration"); ?></th>
                        <th><?php echo app('translator')->get("content.distance"); ?>, km</th>
                        <th style="min-width: 240px;"><?php echo app('translator')->get("content.actions"); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $flightNumbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $each): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($each->deleted_at): ?>
                            <?php continue; ?>
                        <?php endif; ?>

                        <?php $departureAirport = $each->departureAirport ? $each->departureAirport->iata : "" ?>
                        <?php $arrivalAirport   = $each->arrivalAirport   ? $each->arrivalAirport->iata   : "" ?>
                        <?php if($each->distance): ?>
                            <?php $distance = $each->distance ?>
                        <?php elseif($each->departureAirport && $each->arrivalAirport): ?>
                            <?php $distance = getDistanceBetweenPoints($each->departureAirport->latitude, $each->departureAirport->longitude, $each->arrivalAirport->latitude, $each->arrivalAirport->longitude, "Km" ) ?>
                        <?php else: ?>
                            <?php $distance = "" ?>
                        <?php endif; ?>
                        <tr>
                            <td><?php echo e($j + 1); ?></td>
                            
                            <td><?php echo e($each->airline ? ($each->airline->iata ." - ".$each->airline->airline) : ""); ?></td>
                            <td><?php echo e($each->flight_number); ?></td>
                            <td>
                                <a href="#" data-field='flight_type_id' data-model="FlightNumber" data-type="select" data-id='<?php echo e($each->id); ?>'
                                   data-placeholder="Required" data-value='<?php echo e($each->flight_type_id); ?>' class="editable <?php echo e($each->flight_type_id ? 'editable-click' : 'editable-empty'); ?>">
                                    <?php echo e($each->flightType ? ($each->flightType->abbr ? $each->flightType->abbr : $each->flightType->type) : 'Empty'); ?></a>
                            </td>
                            <td><?php echo e($each->cs); ?></td>
                            <td><?php echo e($departureAirport); ?></td>
                            <td><?php echo e($arrivalAirport); ?></td>
                            <td><?php echo e($each->bound == 0 || !$each->bound ? "Outbound" : "Inbound"); ?></td>
                            <td><?php echo e($each->duration); ?></td>
                            <td><?php echo e($distance ? round($distance) : ""); ?></td>
                            <td>
                                <div class="btn-group">
                                    <a target="_blank" href="<?php echo e(route("homepage")."#flight-number/{$each->id}"); ?>"
                                       class="btn btn-success"><?php echo app('translator')->get("content.show_flights"); ?></a>
                                    <a target="_blank" href="<?php echo e(route("homepage")."#flight-number/{$each->id}/edit?s=".rand(100, 999)."&current_airline_id={$currentAirlineId}"); ?>"
                                       class="btn btn-warning"><?php echo app('translator')->get("content.edit"); ?></a>
                                    <a href="<?php echo e(route("homepage")."#flight-number/{$each->id}/delete?current_airline_id={$currentAirlineId}"); ?>"
                                       class="btn btn-danger"><?php echo app('translator')->get("content.delete"); ?></a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>

            </div>

        </div>

    </div>

</div>

<?php endif; ?><?php /**PATH /home/avbis/public_html/coastal/resources/views/flight-number/flight-number-list.blade.php ENDPATH**/ ?>