<?php
/**
 * Created by PhpStorm.
 * User: dimmer
 */
?>

<?php require_once(public_path("smart/inc/init.php")); ?>

<!-- widget grid -->
<section id="widget-grid" class="">

    <!-- row -->
    <div class="row">

        <?php echo $__env->make("template.message", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <article class="col-md-12">

            <div class="col-md-12 no-padding margin-bottom-10">
                <a href="<?php echo e(route("homepage")."#handling-flight-schedule/create?s=".rand(100, 999)); ?>" class="btn btn-primary"><?php echo app('translator')->get("content.create_schedule"); ?></a>
                <a target="_blank" href="<?php echo e(url("handling-flight-schedule-upload")); ?>" class="btn btn-success"><?php echo app('translator')->get("content.upload_schedule"); ?></a>
            </div>

            <div class="clearfix"></div>

            <ul id="tabStations" class="nav nav-tabs bordered">
                <li class="active">
                    <a href="#active" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.active"); ?></a>
                </li>

                <li class="">
                    <a href="#inactive" role="tab" data-toggle="tab"><?php echo app('translator')->get("content.inactive"); ?></a>
                </li>




            </ul>

            <?php $active = 0 ?>
            <div id="tabContent" class="tab-content padding-10 background-white">


                <div class="tab-pane active" id="active">
                    <?php echo $__env->make("handling-flight-schedule.schedule-list", ["list" => $schedules], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>

                <div class="tab-pane" id="inactive">
                    <?php echo $__env->make("handling-flight-schedule.schedule-list", ["list" => $inactiveSchedules], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>




            </div>

        </article>

    </div>

</section>

<script type="text/javascript">

    pageSetUp();

    var pagefunction = function() {

        ApplyFormSubmit();

        ApplyDateFormats();

        Apply_Multiselect();

        ApplyTableFilter(".table");

        $(".permanent_deletion").on("click", function () {
            var _this = $(this), scheduleID = _this.data("sch_id"),
                _from = _this.next(".delete_from").val();


            var request = $.ajax({
                type: "GET",
                dataType: "json",
                url: baseUrl + "/fix/delete-schedule/" + scheduleID,
                data: {
                    date: _from,
                }
            });

            request.done(function (data) {
                alert(data.message);

                if (data.success){
                    location.reload();
                    return false;
                }
            });
        })

    };

    pagefunction();

</script>

<?php /**PATH /home/avbis/public_html/coastal/resources/views/handling-flight-schedule/index.blade.php ENDPATH**/ ?>