<?php

use App\Models\User;
use App\Notifications\ReadAndSignNotification;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

\Illuminate\Support\Facades\View::share('CURRENT_IATA_CODE', env(IATA_CODE));

Route::get('/', function () {
    return view('welcome');
});

Route::get("auth/login",     [\App\Http\Controllers\Auth\AuthController::class, "getLogin"])->name("login");
Route::get("auth/logout",    [\App\Http\Controllers\Auth\AuthController::class, "logout"])->name("logout");

Route::post('login', [\App\Http\Controllers\Auth\AuthController::class, "login"]);

Route::post('logout', [
    'as' => 'logout',
    'uses' => 'Auth\AuthController@logout'
]);

Route::get("error/401", function(){
    return view("smart/ajax/error401");
});

Route::get('airline/picture/{airline}', "AirlineController@picture");

Route::get('math', function () {
    $x = 123;
    $n = 0;

    do {
        $n++;
    }while(pow(10, $n) < $x);

    $y = 0;
    for ($m = 0; $m < $n; $m++){
        for ($i = 0; $i <= $m; $i++){
            $y += pow(10, $i);
        }
    }

    debug($y);

    return ($x % $y == 0 ? "True" : "False");
});

Route::get('avaz',                    [\App\Http\Controllers\TestController::class, "avaz"]);

// for middleware -> 'permissions'
Route::middleware(['auth'])->group(function() {

    Route::get("php/info",      "TestController@phpInfo")->name("php-info");

//    Route::get('flight-data',               ['uses' => 'FlightDataController@index']);
//    Route::get('flight-data/2',             ['uses' => 'FlightDataController@index?view=index2']);


    // Temp routes
    Route::get('fix/delete-schedule/{flight_schedule}',   [\App\Http\Controllers\FixController::class, "deleteFlightSchedule"]);
    Route::get('fix/flight-sectors',            [\App\Http\Controllers\FixController::class, "getFlightSectors"]);
    Route::get('fix/ckin-num',                  [\App\Http\Controllers\FixController::class, "ckinNum"]);
    Route::get('fix/flight-routes',             [\App\Http\Controllers\FixController::class, "getFlightRoutes"]);
    Route::get('fix/flight-number',             [\App\Http\Controllers\FixController::class, "getFlightNumber"]);
    Route::get('fix/remove-flights',            [\App\Http\Controllers\FixController::class, "getRemoveFlightsWithOneStation"]);
    Route::get('fix/aircraft',                [\App\Http\Controllers\FixController::class, "getAircraft"]);
    Route::get('fix/aircraft-type',           [\App\Http\Controllers\FixController::class, "getAircraftType"]);
    Route::get('fix/backup-messages',         [\App\Http\Controllers\FixController::class, "backupMessages"]);
    Route::get('fix/delete-messages',         [\App\Http\Controllers\FixController::class, "deleteMessages"]);
    Route::get('fix/update-types',            [\App\Http\Controllers\FixController::class, "updateTypes"]);
    Route::get('fix/resize-logos',            [\App\Http\Controllers\FixController::class, "resizeLogos"]);
    Route::get('fix/psm',                    [\App\Http\Controllers\FixController::class, "psm"]);
    // End temp routes

    Route::get('/', [\App\Http\Controllers\WelcomeController::class, 'index']);

    Route::get('send/email', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }
        sendSimpleEmail("TEST", "No-reply");
        return 1;
    });

    Route::get('off/days', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        /*
        $users = User::whereNotNull("roster_off_days")
            ->whereNull("vs")
            ->get();

        foreach ($users as $each) {
            if (!isset($list[$each->id])){
                $list[$each->id] = [];
            }

            $days = explode(";", $each->roster_off_days);
            $userPreferred = getPreferredDaysOff($each->id);
            debug($each->id);
            debug($days);
            foreach ($days as $day) {
                $userPreferred->{"{$day}_from"} = "00:00";
                $userPreferred->{"{$day}_to"} = "23:59";
                $userPreferred->save();
            }
        }
        */
        return 1;
    });

    Route::get('test/job', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
//            return "Unauthorized";
        }
        dispatch(new \App\Jobs\TestJob());
        return 1;
    });

    Route::get('inactivity/logout', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }
        \Illuminate\Support\Facades\Artisan::call("inactivity:logout");
        return 1;
    });

    Route::get('set/departure', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        $depCols = ["std", "ptd", "atd", "etd", "abn", "sta", "pta", "ata", "eta", 'tdn'];

        foreach ($depCols as $col) {
            \App\Models\Flight::whereNull("departure_date")
                ->whereNotNull($col)
                ->update([
                    "departure_date"    => \DB::raw("{$col}")
                ]);
        }

//        $result = \App\Models\Flight::whereNull("departure_date")->get();
//        foreach ($result as &$item) {
//            setFlightDepartureDate($item, true);
//        }

        return 1;
    });

    Route::get('set/arrival', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        $arrCols = ["sta", "pta", "ata", "eta", "tdn", "std", "ptd", "atd", "etd", "abn"];

        foreach ($arrCols as $col) {
            \App\Models\Flight::whereNull("arrival_date")
                ->whereNotNull($col)
                ->update([
                    "arrival_date"    => \DB::raw("{$col}")
                ]);
        }

//        $result = \App\Models\Flight::whereNull("departure_date")->get();
//        foreach ($result as &$item) {
//            setFlightDepartureDate($item, true);
//        }

        return 1;
    });

    Route::get('read/sign', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        try {
            $library = \App\Models\Library::find(140);
            User::find(44)->notify(new ReadAndSignNotification($library));
        }
        catch (Exception $e){
            debug($e);
        }

        return 1;
    });

    Route::get('force/lg/{id}', function ($id) {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        $user = User::find($id);

        if (!$user){
            return "User Not Found!";
        }

        try {
            \Illuminate\Support\Facades\Auth::login($user);
        }
        catch (Exception $e){
            debug($e);
        }

        return redirect()->back();
    });

    Route::get('entitlement/set', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        return "Disabled";

        $exceptUserIDs = \App\Models\UserEntitlement::pluck("user_id")->all();

        $users = \App\Models\User::getUsers(true);

        for ($i = 2021; $i <= 2022; $i++) {
            foreach ($users as $user) {
                if (in_array($user->id, $exceptUserIDs)){
                    continue;
                }

                \App\Models\UserEntitlement::create([
                    "user_id"       => $user->id,
                    "year"          => $i,
                    "entitlement"   => 20,
                    "type"          => WORKING_DAYS,
                ]);
            }
        }

        return 1;
    });



    Route::get('test/command', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }
        \Illuminate\Support\Facades\Artisan::call("test:command");
        return 1;
    });

    Route::get('match/parent-flights', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("match:parent_flights", [
            '--date'  => request("date")
        ]);
        return 1;
    });

    Route::get('parse/parse-messages', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("parse:parse_messages");
        return 1;
    });


    Route::get('parse/fetch-messages', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("parse:fetch_messages");
        return 1;
    });


    Route::get('php/info', function () {
        if (!\Illuminate\Support\Facades\Auth::user()
            || !in_array(\Illuminate\Support\Facades\Auth::user()->id, [42, 44])
        ){
            return "Unauthorized";
        }

        return  phpinfo();
    });


    Route::get('notification/send_email', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("notification:send_email");
        return 1;
    });
    Route::get('duplicate/fn', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("duplicate:fn");
        return 1;
    });
    Route::get('remove/no_station', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("remove:no_station");
        return 1;
    });
    Route::get('update/messages', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("update:messages");
        return 1;
    });

    Route::get('flight-com/archive', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("flight_com:archive");
        return 1;
    });

    Route::get('pax-details/removal', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("pax_details:removal");
        return 1;
    });

    Route::get('match/pnl_and_prl', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call('match:pnl_and_prl');
        return 1;
    });

    Route::get('sirena/xml', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call('sirena:xml');
        return 1;
    });

    Route::get('email/mvt-parsing', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call("email:mvt_parsing");
        return 1;
    });

    Route::get('email/parse-pl', function () {
        if (!\Illuminate\Support\Facades\Auth::user() || \Illuminate\Support\Facades\Auth::user()->id != 44){
            return "Unauthorized";
        }

        \Illuminate\Support\Facades\Artisan::call('emails:parse_from_zamar');
        return 1;
    });

    Route::get('radarbox/feed3', function () {
        \Illuminate\Support\Facades\Artisan::call('radarbox:feed3');
        return 1;
    });

    Route::get('radarbox/feed4', function () {
        \Illuminate\Support\Facades\Artisan::call('radarbox:feed4');
        return 1;
    });

    Route::get('lang/{lang}',       [\App\Http\Controllers\LanguageController::class, "switchLang"]);

    if (env("CARRIER") == HANDLING) {
        Route::get("home/dashboard",        [\App\Http\Controllers\HomeController::class, "handlingDashboard"]);
        Route::post("home/dashboard",       [\App\Http\Controllers\HomeController::class, "handlingDashboard"]);
    }
    else {
        Route::get('home/dashboard',        [\App\Http\Controllers\HomeController::class, "airlineDashboard"]);
        Route::post('home/dashboard',       [\App\Http\Controllers\HomeController::class, "airlineDashboard"]);
    }

    include_once("Routes/hrm.php");

    include_once("Routes/template.php");
    include_once("Routes/position.php");
    include_once("Routes/subdepartment.php");
    include_once("Routes/export.php");

    include_once("Routes/add-new-staff.php");
    include_once("Routes/aircraft.php");
    include_once("Routes/aircraft-utilization.php");
    include_once("Routes/aircraft-maintenance.php");
    include_once("Routes/aircraft-certificate.php");
    include_once("Routes/aircraft-engine.php");
    include_once("Routes/aircraft-type.php");

    include_once("Routes/airlines.php");
    include_once("Routes/airports.php");
    include_once("Routes/departments.php");
    include_once("Routes/licenses.php");
    include_once("Routes/organization.php");
    include_once("Routes/users-admin.php");
    include_once("Routes/users-modules.php");
    include_once("Routes/modules.php");
    include_once("Routes/handling-flight-schedule.php");
    include_once("Routes/handling-flight-schedule-upload.php");
    include_once("Routes/handling-punctuality.php");
    include_once("Routes/handling-punctuality-report.php");
    include_once("Routes/handling-pax-report.php");
    include_once("Routes/handling-ops-report.php");
    include_once("Routes/staff-upload.php");
    include_once("Routes/staff-list.php");
    include_once("Routes/staff-report.php");
    include_once("Routes/staff-roster.php");
    include_once("Routes/flight-number.php");
    include_once("Routes/flight-view.php");
    include_once("Routes/flight-tracker.php");
    include_once("Routes/flight-watch.php");
    include_once("Routes/delay-codes.php");
    include_once("Routes/email-notification.php");

    include_once("Routes/operation-flight-list.php");

    // Add modules
    include_once("Routes/users-tracking.php");
    // Hidden Modules
    include_once("Routes/airline-service.php");
    include_once("Routes/service.php");
    include_once("Routes/airline-license.php");
    include_once("Routes/staff-license.php");
    include_once("Routes/airport-license.php");
    include_once("Routes/passenger-report.php");
    include_once("Routes/delay-upload.php");

    // New
    include_once("Routes/uld-report.php");
    include_once("Routes/scm-report.php");

    // Airline Modules
    include_once("Routes/flight-schedule-upload.php");

    include_once("Routes/forwardbooking.php");
    include_once("Routes/forwardrevenue.php");
    include_once("Routes/commercial.php");

    include_once("Routes/revenue-data.php");
    include_once("Routes/seatfactors.php");

    include_once("Routes/country.php");
    include_once("Routes/revenue-target.php");
    include_once("Routes/revenue-target-period.php");

    include_once("Routes/crew.php");
    include_once("Routes/standby.php");
    include_once("Routes/crew-schedule.php");
    include_once("Routes/crew-query.php");

    include_once("Routes/crew-upload.php");
    include_once("Routes/fleet-management.php");
    include_once("Routes/airline-library.php");
    include_once("Routes/library.php");
    include_once("Routes/library-view.php");

    include_once("Routes/flight-docs.php");
    include_once("Routes/revenue-by-flight.php");
    include_once("Routes/agencies.php");
    include_once("Routes/flight-com.php");
    include_once("Routes/flight-staff.php");

    include_once("Routes/notification.php");

    include_once("Routes/system-log.php");

    // Chat testing
    include_once("Routes/chat.php");

    include_once("Routes/staff-watch.php");
    include_once("Routes/user-services.php");

    include_once("Routes/holiday.php");
    include_once("Routes/payroll-hours.php");
    include_once("Routes/finance.php");


    Route::get('user-notifications',                ['uses' => 'UserNotificationsController@index']);

    Route::get('home',                              [\App\Http\Controllers\HomeController::class, "index"])->name("homepage");
    Route::get('home/config',                       [\App\Http\Controllers\HomeController::class, "config"]);
    Route::get('home/config/{any}',                 [\App\Http\Controllers\HomeController::class, "config"]);
    Route::post('home/config/new',                  [\App\Http\Controllers\HomeController::class, "store"]);
    Route::post('home/config/{homepage_chart}',     [\App\Http\Controllers\HomeController::class, "update"]);
    Route::delete('home/config/{homepage_chart}',   [\App\Http\Controllers\HomeController::class, "delete"]);

    Route::get('smart/dashboard',           [\App\Http\Controllers\SmartController::class, "dashboard"]);
    Route::get('smart/dashboard-social',    [\App\Http\Controllers\SmartController::class, "dashboardSocial"]);
    Route::get('smart/test',                [\App\Http\Controllers\SmartController::class, "test"]);
    Route::get('smart/smartui-datatable',   [\App\Http\Controllers\SmartController::class, "smartuiDatatable"]);
    Route::get('smart/gmap-xml',            [\App\Http\Controllers\SmartController::class, "gmapXml"]);

    Route::any('aircraft/add-part',                 [\App\Http\Controllers\AircraftController::class, "addPart"]);
    Route::get('aircraft/ajax-get-aircraft-id',     [\App\Http\Controllers\AircraftController::class, "ajaxGetAircraftId"]);
    Route::get('aircraft/ajax-aircraft',            [\App\Http\Controllers\AircraftController::class, "ajaxAircraft"]);
    Route::any('aircraft/edit-part',                 [\App\Http\Controllers\AircraftController::class, "editPart"]);
    Route::get('aircraft/delete-part',              [\App\Http\Controllers\AircraftController::class, "deletePart"]);

    Route::get('iata/terms',        [\App\Http\Controllers\IataController::class, "terms"]);
    Route::get('crew-details',      [\App\Http\Controllers\CrewDetailsController::class, "index"]);

    Route::get('passenger/ajax-get-pnl-list',       [\App\Http\Controllers\PassengerController::class, "ajaxGetPnlList"]);
    Route::get('passenger/ajax-get-pl-list',        [\App\Http\Controllers\PassengerController::class, "ajaxGetPlList"]);

    // PAX Record Restrictions
    if (passengerRecordPermitted()){
        Route::get('passenger/list',                    [\App\Http\Controllers\PassengerController::class, "paxList"]);
        Route::get('passenger/{passenger}',             [\App\Http\Controllers\PassengerController::class, "show"]);
        Route::post('passenger/upload-photo/{id}',      [\App\Http\Controllers\PassengerController::class, "uploadPhoto"]);
        Route::delete('passenger/upload-photo/{id}',    [\App\Http\Controllers\PassengerController::class, "deletePhoto"]);
    }
    else {
        Route::get('passenger/{passenger}',       function(){
            return redirect()->to('error/page-not-found');
        });
    }

    Route::get('flight-info/handling/{id}',         [\App\Http\Controllers\FlightInfoController::class, "handlingIndex"]);
    Route::get('flight-info/{id}',                  [\App\Http\Controllers\FlightInfoController::class, "handlingIndex"]);

    // REPORT AIRLINE
    Route::any('report/ops',                    [\App\Http\Controllers\ReportController::class, "ops"]);
    Route::any('report/punctuality',            [\App\Http\Controllers\ReportController::class, "punctuality"]);
    Route::any('report/punctuality-report',     [\App\Http\Controllers\ReportController::class, "punctualityReport"]);

    // REPORT END

    Route::get('indicator/user/{id}/delete',    [\App\Http\Controllers\IndicatorController::class, "deleteUserIndicator"]);
    Route::get('indicator/user/{id}/update',    [\App\Http\Controllers\IndicatorController::class, "updateUserIndicator"]);

    Route::get('user/leave-request/picture/{user_leave_request}',  [\App\Http\Controllers\UserController::class, "viewLeaveRequestDoc"]);

    Route::get('user/ajaxgetuserimage',         [\App\Http\Controllers\UserController::class, "getAjaxgetuserimage"]);
    Route::get('user/delete',                   [\App\Http\Controllers\UserController::class, "delete"]);
    Route::get('user/profile',                  [\App\Http\Controllers\UserController::class, "profile"]);

    Route::get('user/create',                               [\App\Http\Controllers\UserController::class, "create"]);
    Route::post('user',                                     [\App\Http\Controllers\UserController::class, "store"]);
    Route::post('user/upload/{id}',                         [\App\Http\Controllers\UserController::class, "upload"]);
    Route::delete('user/upload/{id}',                       [\App\Http\Controllers\UserController::class, "delete"]);

    Route::get('user/{id}',                                 [\App\Http\Controllers\UserController::class, "show"]);
    Route::get('user/{id}/edit',                            [\App\Http\Controllers\UserController::class, "edit"]);
    Route::post('user/leave-apply',                         [\App\Http\Controllers\UserController::class, "leaveApply"]);
    Route::post('user/leave-manager-actions',               [\App\Http\Controllers\UserController::class, "leaveManagerActions"]);
    Route::post('user/leave-employee-actions',              [\App\Http\Controllers\UserController::class, "leaveEmployeeActions"]);
    Route::post('user/{id}',                                [\App\Http\Controllers\UserController::class, "update"]);

    Route::get('user/upload-photo/{id}',                    [\App\Http\Controllers\UserController::class, "uploadPhoto"]);
    Route::post('user/upload-photo/{id}',                   [\App\Http\Controllers\UserController::class, "updatePhoto"]);

    Route::get('chart/search',      [\App\Http\Controllers\ChartController::class, "search"]);
    Route::get('chart/{chart}',     [\App\Http\Controllers\ChartController::class, "show"]);


    Route::post('messenger/change-status',              [\App\Http\Controllers\MessengerController::class, "changeStatus"]);
    Route::post('messenger/send-message',               [\App\Http\Controllers\MessengerController::class, "sendMessage"]);
    Route::post('messenger/load-users',                 [\App\Http\Controllers\MessengerController::class, "loadUsers"]);
    Route::post('messenger/search-and-load-users',      [\App\Http\Controllers\MessengerController::class, "searchAndLoadUsers"]);
    Route::post('messenger/load-messages',              [\App\Http\Controllers\MessengerController::class, "loadMessages"]);
    Route::post('messenger/load-previous-messages',     [\App\Http\Controllers\MessengerController::class, "loadPreviousMessages"]);
    Route::post('messenger/load-new-messages',          [\App\Http\Controllers\MessengerController::class, "loadNewMessages"]);
    Route::post('messenger/load-passive-new-messages',  [\App\Http\Controllers\MessengerController::class, "loadPassiveNewMessages"]);

    Route::get('mhb',                       [\App\Http\Controllers\MhbController::class, "index"]);
    Route::get('mhb/export-pdf/{mhb}',      [\App\Http\Controllers\MhbController::class, "export"]);
    Route::get('mhb/create',                [\App\Http\Controllers\MhbController::class, "create"]);
    Route::post('mhb',                      [\App\Http\Controllers\MhbController::class, "store"]);
    Route::delete('mhb/{mhb}',              [\App\Http\Controllers\MhbController::class, "delete"]);
    Route::post('mhb/{mhb}',                [\App\Http\Controllers\MhbController::class, "update"]);

    Route::get('error/page-not-found',      [\App\Http\Controllers\ErrorController::class, "pageNotFound"]);
    Route::get('error/user-report',         [\App\Http\Controllers\ErrorController::class, "userReport"]);
    Route::get('error/view-user-reports',   [\App\Http\Controllers\ErrorController::class, "viewUserReports"]);
    Route::post('error/user-report',        [\App\Http\Controllers\ErrorController::class, "storeUserReport"]);
    Route::get('error/get-video/{id}',      [\App\Http\Controllers\ErrorController::class, "getVideo"]);
    Route::get('error/get-image/{id}',      [\App\Http\Controllers\ErrorController::class, "getImage"]);

    /** FLIGHT ROUTE  * Standard CRUD */
    Route::get('flight-route',                          [\App\Http\Controllers\FlightRouteController::class, "index"]);
    Route::get('flight-route/create',                   [\App\Http\Controllers\FlightRouteController::class, "create"]);
    Route::post('flight-route',                         [\App\Http\Controllers\FlightRouteController::class, "store"]);
    Route::get('flight-route/{flight_route}/edit',      [\App\Http\Controllers\FlightRouteController::class, "edit"]);
    Route::post('flight-route/{flight_route}',          [\App\Http\Controllers\FlightRouteController::class, "update"]);
    Route::post('flight-route/restore/{flight_route}',  [\App\Http\Controllers\FlightRouteController::class, "restore"]);
    Route::delete('flight-route/{flight_route}',        [\App\Http\Controllers\FlightRouteController::class, "destroy"]);

    Route::get('check-in',          [\App\Http\Controllers\CheckInController::class, "index"]);
    Route::post('check-in',         [\App\Http\Controllers\CheckInController::class, "check"]);



    Route::any('crewroster/load',               [\App\Http\Controllers\CrewRosterController::class, "load"]);
    Route::get('crewroster/ccm-settings',       [\App\Http\Controllers\CrewRosterController::class, "ccmSettings"]);
    Route::post('crewroster/ccm-settings',      [\App\Http\Controllers\CrewRosterController::class, "saveCcmSettings"]);
    Route::get('crewroster/fcm-settings',       [\App\Http\Controllers\CrewRosterController::class, "fcmSettings"]);
    Route::post('crewroster/fcm-settings',      [\App\Http\Controllers\CrewRosterController::class, "saveFcmSettings"]);

    Route::get('crewroster/ajax-load-roster-list',       [\App\Http\Controllers\CrewRosterController::class, "ajaxLoadRosterList"]);
    Route::post('crewroster/ajax-generate-crew-roster',  [\App\Http\Controllers\CrewRosterController::class, "ajaxGenerateCrewRoster"]);
    Route::post('crewroster/ajax-save-changes',          [\App\Http\Controllers\CrewRosterController::class, "ajaxSaveChanges"]);
    Route::post('crewroster/ajax-save-roster',           [\App\Http\Controllers\CrewRosterController::class, "ajaxSaveRoster"]);
    Route::post('crewroster/ajax-publish-roster',        [\App\Http\Controllers\CrewRosterController::class, "ajaxPublishRoster"]);
    Route::post('crewroster/ajax-load-roster',           [\App\Http\Controllers\CrewRosterController::class, "ajaxLoadRoster"]);
    Route::get('crewroster/ajax-cancel-roster',          [\App\Http\Controllers\CrewRosterController::class, "ajaxCancelRoster"]);

    Route::get('crewroster/expiry-summary',     [\App\Http\Controllers\CrewRosterController::class, "expirySummary"]);
    Route::get('crewroster/ccm-roster',         [\App\Http\Controllers\CrewRosterController::class, "ccmRoster"]);
    Route::get('crewroster/fcm-roster',         [\App\Http\Controllers\CrewRosterController::class, "fcmRoster"]);



    Route::any('admin/add-hub',                     [\App\Http\Controllers\AdminController::class, "addHub"]);
    Route::any('admin/edit-hub',                    [\App\Http\Controllers\AdminController::class, "editHub"]);
    Route::get('admin/delete-hub',                  [\App\Http\Controllers\AdminController::class, "deleteHub"]);

    Route::get('flight-schedule',                         [\App\Http\Controllers\FlightScheduleController::class, "index"]);
    Route::post('flight-schedule/save-as-template',       [\App\Http\Controllers\FlightScheduleController::class, "saveAsTemplate"]);
    Route::post('flight-schedule/ajax-update-template',   [\App\Http\Controllers\FlightScheduleController::class, "ajaxUpdateTemplate"]);
    Route::get('flight-schedule/ajax-delete-template',    [\App\Http\Controllers\FlightScheduleController::class, "ajaxDeleteTemplate"]);
    Route::post('flight-schedule/upload-to-fleetwatch',   [\App\Http\Controllers\FlightScheduleController::class, "uploadToFleetwatch"]);

    Route::get('fleetwatch/index',                [\App\Http\Controllers\FleetWatchController::class, "index"]);
    Route::get('fleetwatch/ajax-get-range',       [\App\Http\Controllers\FleetWatchController::class, "ajaxGetRange"]);
    Route::get('fleetwatch/ajax-get-crew-info',   [\App\Http\Controllers\FleetWatchController::class, "ajaxGetCrewInfo"]);

    Route::get('flight',                                [\App\Http\Controllers\FlightController::class, "details"]);
    Route::get('flight/restore/{flight}',               [\App\Http\Controllers\FlightController::class, "restore"]);
    Route::get('flight/cancel/{flight}',                [\App\Http\Controllers\FlightController::class, "cancel"]);
    Route::get('flight/remove/{flight}',                [\App\Http\Controllers\FlightController::class, "remove"]);
    Route::post('flight/add',                           [\App\Http\Controllers\FlightController::class, "add"]);
    Route::get('flight/ajax-get-sod',                   [\App\Http\Controllers\FlightController::class, "ajaxGetSOD"]);
    Route::get('flight/ajax-get-flight',                [\App\Http\Controllers\FlightController::class, "ajaxGetFlight"]);
    Route::get('flight/ajax-flight-get-parent-flight',  [\App\Http\Controllers\FlightController::class, "ajaxFlightGetParentFlight"]);
    Route::get('flight/ajax-parent-flight-id',          [\App\Http\Controllers\FlightController::class, "ajaxParentFlightId"]);
    Route::get('flight/ajax-parent-flight-number-id',   [\App\Http\Controllers\FlightController::class, "ajaxParentFlightNumberId"]);
    Route::get('flight/ajax-delete-flight',             [\App\Http\Controllers\FlightController::class, "ajaxDeleteFlight"]);
    Route::get('flight/ajax-fuel',                      [\App\Http\Controllers\FlightController::class, "ajaxFuel"]);
    Route::get('flight/ajax-change-flight',             [\App\Http\Controllers\FlightController::class, "ajaxChangeFlight"]);
    Route::get('flight/ajax-get-mvt-messages-list',     [\App\Http\Controllers\FlightController::class, "ajaxGetMvtMessagesList"]);
    Route::post('flight/ajax-send-mvt-message',         [\App\Http\Controllers\FlightController::class, "ajaxSendMvtMessage"]);
    Route::get('flight/ajax-get-messages',              [\App\Http\Controllers\FlightController::class, "ajaxGetMessages"]);

    Route::get('flight/{flight}/edit',                  [\App\Http\Controllers\FlightController::class, "edit"]);
    Route::post('flight/{flight}',                      [\App\Http\Controllers\FlightController::class, "update"]);

    Route::get('sales-organisation/profile/{id}',            [\App\Http\Controllers\SalesOrganisationController::class, "profile"]);
    Route::post('sales-organisation/ajax-add-sales-call',    [\App\Http\Controllers\SalesOrganisationController::class, "ajaxAddSalesCall"]);

    Route::get('message/log',               [\App\Http\Controllers\MessageController::class, "log"]);
    Route::post('message/parse',            [\App\Http\Controllers\MessageController::class, "parse"]);

    Route::get('change-record/ajax-remove-user-history',    [\App\Http\Controllers\ChangeRecordController::class, "ajaxRemoveUserHistory"]);
    Route::post('change-record/ajax-save-record-universal', [\App\Http\Controllers\ChangeRecordController::class, "ajaxSaveRecordUniversal"]);
    Route::get('change-record/ajax-save-user-history',      [\App\Http\Controllers\ChangeRecordController::class, "ajaxSaveUserHistory"]);
    Route::post('change-record/ajax-save-changes',          [\App\Http\Controllers\ChangeRecordController::class, "ajaxSaveChanges"]);
    Route::post('change-record/ajax-save-records',          [\App\Http\Controllers\ChangeRecordController::class, "ajaxSaveRecords"]);

    Route::get('user-module',                               [\App\Http\Controllers\UserModuleController::class, "index"]);
    Route::post('user-module/{user}',                       [\App\Http\Controllers\UserModuleController::class, "update"]);

    Route::get('test/messages',                 [\App\Http\Controllers\TestController::class, "messages"]);
    Route::get('test/parse-again/{type}',       [\App\Http\Controllers\TestController::class, "parseAgain"]);
    Route::get('test/parse-single/{type}/{id}',[\App\Http\Controllers\TestController::class, "parseSingleMessage"]);
    Route::post('test/messages',                [\App\Http\Controllers\TestController::class, "checkMessages"]);
    Route::get('test/flights-messages',         [\App\Http\Controllers\TestController::class, "flightsMessages"]);

    Route::get('parse',                             [\App\Http\Controllers\ParseController::class, "index"]);

});

/*
Route::filter('csrf', function()
{
    $token = \Request::ajax() ? \Request::header('x-csrf-token') : \Illuminate\Support\Facades\Request::get('_token');

    if (\Session::token() != $token)
    {
        throw new Illuminate\Session\TokenMismatchException;
    }
});

    Route::controllers([
        'fix'               => 'FixController',
        'hrm'               => 'HrmController',
        'finance'           => 'FinanceController',
        'flightquery'       => 'FlightQueryController',
    ]);

Route::get('api/flight-details',          ['uses' => 'ApiController@getFlightDetails']);
Route::get('api/flight-numbers-range',    ['uses' => 'ApiController@getFlightNumbersRange']);
Route::get('api/todays-landed-flights',   ['uses' => 'ApiController@getTodaysLandedFlights']);
Route::get('setup',                       [\App\Http\Controllers\SetupController::class, "index"]);
Route::get('setup/create-admin',          [\App\Http\Controllers\SetupController::class, "createAdmin"]);
Route::post('setup/store-admin',          [\App\Http\Controllers\SetupController::class, "storeAdmin"]);
Route::get('setup/create-airline-info',   [\App\Http\Controllers\SetupController::class, "createAirlineInfo"]);
Route::post('setup/store-airline-info',   [\App\Http\Controllers\SetupController::class, "storeAirlineInfo"]);

Route::get('setup/create-aircraft-types', [\App\Http\Controllers\SetupController::class, "createAircraftTypes"]);
Route::post('setup/store-aircraft-types', [\App\Http\Controllers\SetupController::class, "storeAircraftTypes"]);

Route::get('setup/create-aircraft',       [\App\Http\Controllers\SetupController::class, "createAircraft"]);
Route::post('setup/store-aircraft',       [\App\Http\Controllers\SetupController::class, "storeAircraft"]);

Route::get('setup/create-flight-crew',    [\App\Http\Controllers\SetupController::class, "createFlightCrew"]);
Route::post('setup/store-flight-crew',    [\App\Http\Controllers\SetupController::class, "storeFlightCrew"]);

Route::get('setup/create-cabin-crew',     [\App\Http\Controllers\SetupController::class, "createCabinCrew"]);
Route::post('setup/store-cabin-crew',     [\App\Http\Controllers\SetupController::class, "storeCabinCrew"]);
*/
