<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('admin/users', [
    'as'                        => 'admin/users',
    'middleware'                => ['permissions.required'],
    'module'                    => USERS_ADMIN,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'AdminController@users'
]);

Route::get('admin/add-user', [
    'as'                        => 'admin/add-user',
    'middleware'                => ['permissions.required'],
    'module'                    => USERS_ADMIN,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'AdminController@add-User'
]);

Route::post('admin/ajax-user-delete-restore', [
    'as'                        => 'admin/ajax-user-delete-restore',
    'middleware'                => ['permissions.required'],
    'module'                    => USERS_ADMIN,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'AdminController@ajaxUserDeleteRestore'
]);

Route::get('admin/ajax-send-temp-password', [
    'as'                        => 'admin/ajax-send-temp-password',
    'middleware'                => ['permissions.required'],
    'module'                    => USERS_ADMIN,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AdminController@ajaxSendTempPassword'
]);

Route::get('admin/ajax-user-activation', [
    'as'                        => 'admin/ajax-user-activation',
    'middleware'                => ['permissions.required'],
    'module'                    => USERS_ADMIN,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'AdminController@ajaxUserActivation'
]);
