<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */


Route::get('system-log/login-as-user/{user}', [
    'middleware'                => ['permissions.required'],
    'module'                    => SYSTEM_LOG,
    'permissions'               => [LOGIN_AS_USER],
    'permissions_require_all'   => true,
    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'SystemLogController@loginAsUser'
]);

Route::get('system-log/staff-license/{staff_license}', [
    'middleware'                => ['permissions.required'],
    'module'                    => SYSTEM_LOG,
    'permissions'               => [],
    'permissions_require_all'   => true,
    'uses'                      => 'SystemLogController@staffLicense'
]);

Route::get('system-log/user/{user}', [
    'middleware'                => ['permissions.required'],
    'module'                    => SYSTEM_LOG,
    'permissions'               => [],
    'permissions_require_all'   => true,
    'uses'                      => 'SystemLogController@user'
]);

Route::get('system-log/flight/{flight}', [
    'middleware'                => ['permissions.required'],
    'module'                    => SYSTEM_LOG,
    'permissions'               => [],
    'permissions_require_all'   => true,
    'uses'                      => 'SystemLogController@flight'
]);

Route::get('system-log/flight-staff/{flight}', [
    'middleware'                => ['permissions.required'],
    'module'                    => SYSTEM_LOG,
    'permissions'               => [],
    'permissions_require_all'   => true,
    'uses'                      => 'SystemLogController@flightStaff'
]);

