<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('standby', [
    'as'                        => 'standby/index',
    'middleware'                => ['permissions.required'],
    'module'                    => STANDBY_CREW,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StandbyController@index'
]);

Route::any('standby/delete/{standby_crew}', [
    'as'                        => 'standby/delete',
    'middleware'                => ['permissions.required'],
    'module'                    => STANDBY_CREW,
    'permissions'               => [DELETE_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StandbyController@delete'
]);

Route::any('standby/{standby_crew}/edit', [
    'as'                        => 'standby/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => STANDBY_CREW,
    'permissions'               => [EDIT_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StandbyController@edit'
]);

Route::any('standby/add-fcm', [
    'as'                        => 'standby/add-fcm',
    'middleware'                => ['permissions.required'],
    'module'                    => STANDBY_CREW,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StandbyController@addFcm'
]);

Route::any('standby/add-ccm', [
    'as'                        => 'standby/add-ccm',
    'middleware'                => ['permissions.required'],
    'module'                    => STANDBY_CREW,
    'permissions'               => [CREATE_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StandbyController@addCcm'
]);
