<?php
/**
 * Created by PhpStorm.
 * User: user
 * Date: 14.04.17

 */

Route::get('staff-watch', [
    'as'                        => 'staff-watch',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
//    'user_roles'                => [SUPER_ADMIN],
    'uses'                      => 'StaffWatchController@index'
]);

Route::get('staff-watch/ajax-get-flight-staff', [
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
        'uses'                      => 'StaffWatchController@ajaxGetFlightStaff',
//    'skip_log'                  => true,
]);

Route::get('staff-watch/ajax-get-flight-staff/{flight_staff}', [
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffWatchController@ajaxGetFlightStaff',
//    'skip_log'                  => true,
]);

Route::get('staff-watch/ajax-get-range', [
    'as'                        => 'staff-watch/ajax-get-range',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffWatchController@ajaxGetRange',
    'skip_log'                  => true,
]);

Route::get('staff-watch/ajax-search-airport', [
    'as'                        => 'staff-watch/ajax-search-airport',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffWatchController@ajaxSearchAirport'
]);

Route::get('staff-watch/quick-link', [
    'as'                        => 'staff-watch/quick-link',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [VIEW_PERMISSION],
    'permissions_require_all'   => true,
    'uses'                      => 'StaffWatchController@quickLink'
]);

Route::post('staff-watch/create', [
    'as'                        => 'staff-watch/create',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [CREATE_PERMISSION],
    'uses'                      => 'StaffWatchController@create'
]);

Route::post('staff-watch/{flight_staff}/edit', [
    'as'                        => 'staff-watch/edit',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [EDIT_PERMISSION],
    'uses'                      => 'StaffWatchController@edit'
]);

Route::post('staff-watch/cancel', [
    'as'                        => 'staff-watch/cancel',
    'middleware'                => ['permissions.required'],
    'module'                    => STAFF_WATCH,
    'permissions'               => [DELETE_PERMISSION],
    'uses'                      => 'StaffWatchController@cancel'
]);
